/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.mail;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Set;
import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.message.DefaultBodyDescriptorBuilder;
import org.apache.james.mime4j.parser.MimeStreamParser;
import org.apache.james.mime4j.stream.MimeConfig;
import org.apache.tika.config.Field;
import org.apache.tika.detect.Detector;
import org.apache.tika.exception.TikaException;
import org.apache.tika.extractor.EmbeddedDocumentUtil;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.mail.MailContentHandler;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class RFC822Parser
implements Parser {
    private static final long serialVersionUID = -5504243905998074168L;
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.singleton(MediaType.parse("message/rfc822"));
    private Detector detector;
    @Field
    private boolean extractAllAlternatives = false;

    @Override
    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    @Override
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        MimeConfig config = new MimeConfig.Builder().setMaxLineLen(100000).setMaxHeaderLen(100000).build();
        config = context.get(MimeConfig.class, config);
        Detector localDetector = context.get(Detector.class);
        if (localDetector == null) {
            if (this.detector == null) {
                EmbeddedDocumentUtil embeddedDocumentUtil = new EmbeddedDocumentUtil(context);
                this.detector = embeddedDocumentUtil.getDetector();
            }
            localDetector = this.detector;
        }
        MimeStreamParser parser = new MimeStreamParser(config, null, new DefaultBodyDescriptorBuilder());
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        MailContentHandler mch = new MailContentHandler(xhtml, localDetector, metadata, context, config.isStrictParsing(), this.extractAllAlternatives);
        parser.setContentHandler(mch);
        parser.setContentDecoding(true);
        parser.setNoRecurse();
        xhtml.startDocument();
        TikaInputStream tstream = TikaInputStream.get(stream);
        try {
            parser.parse(tstream);
        }
        catch (IOException e) {
            tstream.throwIfCauseOf(e);
            throw new TikaException("Failed to parse an email message", e);
        }
        catch (MimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof TikaException) {
                throw (TikaException)cause;
            }
            if (cause instanceof SAXException) {
                throw (SAXException)cause;
            }
            throw new TikaException("Failed to parse an email message", e);
        }
        xhtml.endDocument();
    }

    public void setExtractAllAlternatives(boolean extractAllAlternatives) {
        this.extractAllAlternatives = extractAllAlternatives;
    }
}

