/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage;

import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.UnaryOperator;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageInputStream;
import javax.sql.DataSource;
import org.apache.sis.io.InvalidSeekException;
import org.apache.sis.io.stream.ChannelDataInput;
import org.apache.sis.io.stream.ChannelDataOutput;
import org.apache.sis.io.stream.ChannelFactory;
import org.apache.sis.io.stream.ChannelImageInputStream;
import org.apache.sis.io.stream.ChannelImageOutputStream;
import org.apache.sis.io.stream.IOUtilities;
import org.apache.sis.io.stream.InputStreamAdapter;
import org.apache.sis.io.stream.InternalOptionKey;
import org.apache.sis.io.stream.RewindableLineReader;
import org.apache.sis.setup.OptionKey;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.ForwardOnlyStorageException;
import org.apache.sis.storage.ProbeProviderPair;
import org.apache.sis.storage.UnsupportedStorageException;
import org.apache.sis.storage.base.StoreUtilities;
import org.apache.sis.storage.internal.Resources;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Classes;
import org.apache.sis.util.ObjectConverters;
import org.apache.sis.util.UnconvertibleObjectException;
import org.apache.sis.util.collection.DefaultTreeTable;
import org.apache.sis.util.collection.TableColumn;
import org.apache.sis.util.collection.TreeTable;
import org.apache.sis.util.internal.Strings;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;

public class StorageConnector
implements Serializable {
    private static final long serialVersionUID = 2524083964906593093L;
    public static final int DEFAULT_BUFFER_SIZE = 16384;
    static final int READ_AHEAD_LIMIT = 8192;
    static final int MINIMAL_BUFFER_SIZE = 256;
    private static final byte CASCADE_ON_CLOSE = 1;
    private static final byte CASCADE_ON_RESET = 2;
    private static final byte CLEAR_ON_RESET = 4;
    private static final Map<Class<?>, Opener<?>> OPENERS = new IdentityHashMap(16);
    final Object storage;
    private transient String name;
    private transient String extension;
    private Map<OptionKey<?>, Object> options;
    transient ProbeProviderPair probing;
    private transient Map<Class<?>, Coupled> views;

    private static <S> void add(Class<S> type, Opener<S> op) {
        if (OPENERS.put(type, op) != null) {
            throw new AssertionError(type);
        }
    }

    public StorageConnector(Object storage) {
        ArgumentChecks.ensureNonNull("storage", storage);
        this.storage = storage;
    }

    public <T> T getOption(OptionKey<T> key) {
        ArgumentChecks.ensureNonNull("key", key);
        return key.getValueFrom(this.options);
    }

    public <T> void setOption(OptionKey<T> key, T value) {
        ArgumentChecks.ensureNonNull("key", key);
        this.options = key.setValueInto(this.options, value);
    }

    public Object getStorage() throws DataStoreException {
        this.reset();
        return this.storage;
    }

    public String getStorageName() {
        if (this.name == null) {
            this.name = Strings.trimOrNull(IOUtilities.filename(this.storage));
            if (this.name == null) {
                this.name = Strings.trimOrNull(IOUtilities.toString(this.storage));
                if (this.name == null) {
                    this.name = Classes.getShortClassName(this.storage);
                }
            }
        }
        return this.name;
    }

    public String getFileExtension() {
        if (this.extension == null) {
            this.extension = IOUtilities.extension(this.storage);
        }
        return this.extension;
    }

    static boolean isSupportedType(Class<?> type) {
        return OPENERS.containsKey(type);
    }

    public <S> S getStorageAs(Class<S> type) throws IllegalArgumentException, DataStoreException {
        Object view;
        ArgumentChecks.ensureNonNull("type", type);
        if (this.views != null && this.views.isEmpty()) {
            throw new IllegalStateException(Resources.format((short)56));
        }
        Coupled value = this.getView(type);
        if (this.reset(value)) {
            return type.cast(value.view);
        }
        if (type.isInstance(this.storage)) {
            Reader in;
            Object view2 = this.storage;
            this.reset();
            int cascade = 0;
            if (type == InputStream.class) {
                InputStream in2 = (InputStream)view2;
                if (!in2.markSupported()) {
                    view2 = type.cast(new BufferedInputStream(in2));
                    cascade = 6;
                }
            } else if (type == Reader.class && !(in = (Reader)view2).markSupported()) {
                view2 = type.cast(new LineNumberReader(in));
                cascade = 6;
            }
            this.addView(type, view2, null, (byte)cascade);
            return (S)view2;
        }
        Opener<?> method = OPENERS.get(type);
        if (method == null) {
            S view3;
            try {
                view3 = ObjectConverters.convert(this.storage, type);
            }
            catch (UnconvertibleObjectException e) {
                if (!OPENERS.containsKey(type)) {
                    throw e;
                }
                Logging.recoverableException(StoreUtilities.LOGGER, StorageConnector.class, "getStorageAs", e);
                view3 = null;
            }
            this.addView(type, view3);
            return view3;
        }
        try {
            view = method.open(this);
        }
        catch (DataStoreException e) {
            throw e;
        }
        catch (Exception e) {
            short key = 9;
            if (e instanceof NoSuchFileException) {
                key = 39;
            }
            throw new DataStoreException(Errors.format(key, this.getStorageName()), e);
        }
        return type.cast(view);
    }

    private boolean reset(Coupled c) throws DataStoreException {
        boolean done;
        if (c == null) {
            return false;
        }
        try {
            done = c.reset();
        }
        catch (IOException e) {
            throw new ForwardOnlyStorageException(Resources.format((short)18, this.getStorageName()), e);
        }
        if (done) {
            c.invalidateSources();
            c.invalidateUsages();
        }
        return c.isValid;
    }

    private void reset() throws DataStoreException {
        if (this.views != null && !this.views.isEmpty() && !this.reset(this.views.get(null))) {
            throw new ForwardOnlyStorageException(Resources.format((short)18, this.getStorageName()));
        }
    }

    public boolean wasProbingAbsentFile() {
        return this.probing != null && this.probing.probe != null;
    }

    private ChannelDataInput createChannelDataInput(boolean asImageInputStream) throws IOException, DataStoreException {
        this.reset();
        if (this.storage instanceof InputStream) {
            ((InputStream)this.storage).mark(8192);
        }
        if (this.storage instanceof ByteBuffer) {
            ChannelImageInputStream asDataInput = new ChannelImageInputStream(this.getStorageName(), (ByteBuffer)this.storage);
            this.addView(ChannelDataInput.class, asDataInput);
            return asDataInput;
        }
        ChannelFactory factory = this.createChannelFactory(false);
        if (factory == null) {
            return null;
        }
        if (this.probing != null && factory.isCreateNew()) {
            this.probing.setProbingAbsentFile();
            return null;
        }
        String name = this.getStorageName();
        ReadableByteChannel channel = factory.readable(name, null);
        this.addView(ReadableByteChannel.class, channel, null, factory.isCoupled() ? (byte)2 : 0);
        ByteBuffer buffer = this.getChannelBuffer(factory);
        ChannelDataInput asDataInput = asImageInputStream ? new ChannelImageInputStream(name, channel, buffer, false) : new ChannelDataInput(name, channel, buffer, false);
        this.addView(ChannelDataInput.class, asDataInput, ReadableByteChannel.class, (byte)2);
        if (factory.canReopen()) {
            this.addView(ChannelFactory.class, factory);
        }
        return asDataInput;
    }

    private DataInput createDataInput() throws IOException, DataStoreException {
        DataInput asDataInput;
        Coupled c = this.getView(ChannelDataInput.class);
        ChannelDataInput in = this.reset(c) ? (ChannelDataInput)c.view : this.createChannelDataInput(true);
        if (in != null) {
            c = this.getView(ChannelDataInput.class);
            if (in instanceof DataInput) {
                asDataInput = (DataInput)((Object)in);
            } else {
                asDataInput = new ChannelImageInputStream(in);
                c.view = asDataInput;
            }
            this.views.put(DataInput.class, c);
        } else {
            if (this.wasProbingAbsentFile()) {
                return null;
            }
            this.reset();
            try {
                asDataInput = ImageIO.createImageInputStream(this.storage);
            }
            catch (IIOException e) {
                throw StorageConnector.unwrap(e);
            }
            this.addView(DataInput.class, asDataInput, null, (byte)3);
        }
        return asDataInput;
    }

    private ByteBuffer getChannelBuffer(ChannelFactory factory) {
        ByteBuffer buffer = this.getOption(OptionKey.BYTE_BUFFER);
        if (buffer == null) {
            buffer = factory.suggestDirectBuffer ? ByteBuffer.allocateDirect(16384) : ByteBuffer.allocate(16384);
        }
        return buffer;
    }

    private ByteBuffer createByteBuffer() throws IOException, DataStoreException {
        ChannelDataInput c = this.getStorageAs(ChannelDataInput.class);
        ByteBuffer asByteBuffer = null;
        if (c != null) {
            asByteBuffer = c.buffer.asReadOnlyBuffer();
        } else {
            if (this.wasProbingAbsentFile()) {
                return null;
            }
            ImageInputStream in = this.getStorageAs(ImageInputStream.class);
            if (in != null) {
                in.mark();
                byte[] buffer = new byte[256];
                int n = in.read(buffer);
                in.reset();
                if (n >= 1) {
                    asByteBuffer = ByteBuffer.wrap(buffer).order(in.getByteOrder());
                    asByteBuffer.limit(n);
                }
            }
        }
        this.addView(ByteBuffer.class, asByteBuffer);
        return asByteBuffer;
    }

    final boolean prefetch() throws DataStoreException {
        try {
            Coupled c = this.getView(ChannelDataInput.class);
            if (c != null) {
                this.reset(c);
                return c.isValid && ((ChannelDataInput)c.view).prefetch() > 0;
            }
            c = this.getView(ImageInputStream.class);
            if (this.reset(c)) {
                ByteBuffer buffer;
                ImageInputStream input = (ImageInputStream)c.view;
                c = this.getView(ByteBuffer.class);
                if (this.reset(c) && (buffer = (ByteBuffer)c.view) != null) {
                    int p = buffer.limit();
                    long mark = input.getStreamPosition();
                    input.seek(Math.addExact(mark, (long)p));
                    int n = input.read(buffer.array(), p, buffer.capacity() - p);
                    input.seek(mark);
                    if (n > 0) {
                        buffer.limit(p + n);
                        return true;
                    }
                }
            }
        }
        catch (IOException e) {
            throw new DataStoreException(Errors.format((short)12, this.getStorageName()), e);
        }
        return false;
    }

    private ImageInputStream createImageInputStream() throws DataStoreException {
        Class<DataInput> source = DataInput.class;
        DataInput input = this.getStorageAs(source);
        if (input instanceof ImageInputStream) {
            this.views.put(ImageInputStream.class, this.views.get(source));
            return (ImageInputStream)input;
        }
        if (!this.wasProbingAbsentFile()) {
            this.addView(ImageInputStream.class, null);
        }
        return null;
    }

    private InputStream createInputStream() throws IOException, DataStoreException {
        Class<DataInput> source = DataInput.class;
        DataInput input = this.getStorageAs(source);
        if (input instanceof InputStream) {
            this.views.put(InputStream.class, this.views.get(source));
            return (InputStream)((Object)input);
        }
        if (input instanceof ImageInputStream) {
            InputStreamAdapter in = new InputStreamAdapter((ImageInputStream)input);
            this.addView(InputStream.class, in, source, (byte)(this.getView(source).cascade & 2));
            return in;
        }
        if (!this.wasProbingAbsentFile()) {
            this.addView(InputStream.class, null);
        }
        return null;
    }

    private Reader createReader() throws IOException, DataStoreException {
        InputStream input = this.getStorageAs(InputStream.class);
        if (input == null) {
            if (!this.wasProbingAbsentFile()) {
                this.addView(Reader.class, null);
            }
            return null;
        }
        input.mark(8192);
        RewindableLineReader in = new RewindableLineReader(input, this.getOption(OptionKey.ENCODING));
        this.addView(Reader.class, in, InputStream.class, (byte)6);
        return in;
    }

    private Connection createConnection() throws SQLException {
        if (this.storage instanceof DataSource) {
            Connection c = ((DataSource)this.storage).getConnection();
            this.addView(Connection.class, c, null, (byte)0);
            return c;
        }
        return null;
    }

    private String createString() {
        return IOUtilities.toString(this.storage);
    }

    private <S> void addView(Class<S> type, S view) {
        this.addView(type, view, null, (byte)0);
    }

    private ChannelFactory createChannelFactory(boolean allowWriteOnly) throws IOException {
        ChannelFactory factory = ChannelFactory.prepare(this.storage, allowWriteOnly, this.getOption(OptionKey.URL_ENCODING), this.getOption(OptionKey.OPEN_OPTIONS));
        UnaryOperator<ChannelFactory> wrapper = this.getOption(InternalOptionKey.CHANNEL_FACTORY_WRAPPER);
        if (factory != null && wrapper != null) {
            factory = (ChannelFactory)wrapper.apply(factory);
        }
        return factory;
    }

    private ChannelDataOutput createChannelDataOutput() throws IOException, DataStoreException {
        this.reset();
        ChannelFactory factory = this.createChannelFactory(true);
        if (factory == null) {
            return null;
        }
        String name = this.getStorageName();
        WritableByteChannel channel = factory.writable(name, null);
        this.addView(WritableByteChannel.class, channel, null, factory.isCoupled() ? (byte)2 : 0);
        ByteBuffer buffer = this.getChannelBuffer(factory);
        ChannelDataOutput asDataOutput = new ChannelDataOutput(name, channel, buffer);
        this.addView(ChannelDataOutput.class, asDataOutput, WritableByteChannel.class, (byte)2);
        if (factory.canReopen()) {
            this.addView(ChannelFactory.class, factory);
        }
        return asDataOutput;
    }

    private DataOutput createDataOutput() throws IOException, DataStoreException {
        DataOutput asDataOutput;
        Coupled c = this.getView(ChannelDataOutput.class);
        ChannelDataOutput out = this.reset(c) ? (ChannelDataOutput)c.view : this.createChannelDataOutput();
        if (out != null) {
            c = this.getView(ChannelDataOutput.class);
            if (out instanceof DataOutput) {
                asDataOutput = (DataOutput)((Object)out);
            } else {
                asDataOutput = new ChannelImageOutputStream(out);
                c.view = asDataOutput;
            }
            this.views.put(DataOutput.class, c);
        } else {
            this.reset();
            try {
                asDataOutput = ImageIO.createImageOutputStream(this.storage);
            }
            catch (IIOException e) {
                throw StorageConnector.unwrap(e);
            }
            this.addView(DataOutput.class, asDataOutput, null, (byte)3);
        }
        return asDataOutput;
    }

    private OutputStream createOutputStream() throws IOException, DataStoreException {
        Class<DataOutput> target = DataOutput.class;
        DataOutput output = this.getStorageAs(target);
        if (output instanceof OutputStream) {
            this.views.put(OutputStream.class, this.views.get(target));
            return (OutputStream)((Object)output);
        }
        this.addView(OutputStream.class, null);
        return null;
    }

    private <S> void addView(Class<S> type, S view, Class<?> source, byte cascade) {
        Coupled c;
        if (this.views == null) {
            this.views = new IdentityHashMap();
            this.views.put(null, new Coupled(this.storage));
        }
        if ((c = this.views.get(type)) == null) {
            if (view == this.storage) {
                c = this.views.get(null);
                c.invalidateUsages();
            } else {
                c = new Coupled(cascade != 0 ? this.views.get(source) : null, cascade);
            }
            this.views.put(type, c);
        } else {
            assert (c.view == null || c.view == view) : c;
            assert (c.cascade == cascade) : cascade;
            assert (c.wrapperFor == (cascade != 0 ? this.views.get(source) : null)) : c;
            c.invalidateUsages();
        }
        c.view = view;
        c.isValid = true;
        c.invalidateSources();
    }

    private Coupled getView(Class<?> type) {
        return this.views != null ? this.views.get(type) : null;
    }

    public <S> S commit(Class<S> type, String format) throws IllegalArgumentException, DataStoreException {
        S view;
        try {
            view = this.getStorageAs(type);
        }
        catch (Throwable ex) {
            try {
                this.closeAllExcept(null);
            }
            catch (Throwable se) {
                ex.addSuppressed(se);
            }
            throw ex;
        }
        this.closeAllExcept(view);
        if (view == null) {
            throw new UnsupportedStorageException(null, format, this.storage, this.getOption(OptionKey.OPEN_OPTIONS));
        }
        return view;
    }

    public void closeAllExcept(Object view) throws DataStoreException {
        if (this.views == null) {
            this.views = Map.of();
            if (this.storage != view && this.storage instanceof AutoCloseable) {
                try {
                    ((AutoCloseable)this.storage).close();
                }
                catch (DataStoreException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new DataStoreException(e);
                }
            }
            return;
        }
        IdentityHashMap<AutoCloseable, Boolean> toClose = new IdentityHashMap<AutoCloseable, Boolean>(this.views.size());
        for (Coupled c : this.views.values()) {
            Object v = c.view;
            if (v != view) {
                if (!(v instanceof AutoCloseable)) continue;
                toClose.putIfAbsent((AutoCloseable)v, Boolean.TRUE);
                continue;
            }
            c.protect(toClose);
            do {
                if (!((v = c.view) instanceof AutoCloseable)) continue;
                toClose.put((AutoCloseable)v, Boolean.FALSE);
            } while ((c = c.wrapperFor) != null);
        }
        Iterator<Object> it = toClose.values().iterator();
        while (it.hasNext()) {
            if (!Boolean.FALSE.equals(it.next())) continue;
            it.remove();
        }
        if (!toClose.isEmpty()) {
            block8: for (Coupled c : this.views.values()) {
                if (c.cascadeOnClose() || !toClose.containsKey(c.view)) continue;
                while ((c = c.wrapperFor) != null) {
                    toClose.remove(c.view);
                    if (!c.cascadeOnClose()) continue;
                    continue block8;
                }
            }
        }
        this.views = Map.of();
        Throwable failure = null;
        for (AutoCloseable c : toClose.keySet()) {
            try {
                c.close();
            }
            catch (Exception e) {
                if (failure == null) {
                    failure = e instanceof DataStoreException ? (DataStoreException)e : new DataStoreException(e);
                    continue;
                }
                failure.addSuppressed(e);
            }
        }
        if (failure != null) {
            throw failure;
        }
    }

    private static IOException unwrap(IIOException e) {
        Throwable cause = e.getCause();
        return cause instanceof IOException ? (IOException)cause : e;
    }

    public String toString() {
        Coupled c;
        DefaultTreeTable table = new DefaultTreeTable(TableColumn.NAME, TableColumn.VALUE);
        TreeTable.Node root = table.getRoot();
        root.setValue(TableColumn.NAME, Classes.getShortClassName(this));
        root.setValue(TableColumn.VALUE, this.getStorageName());
        if (this.options != null) {
            TreeTable.Node op = root.newChild();
            op.setValue(TableColumn.NAME, "options");
            op.setValue(TableColumn.VALUE, this.options);
        }
        if ((c = this.getView(null)) != null) {
            c.append(root.newChild(), this.views);
        }
        return ((Object)table).toString();
    }

    static {
        StorageConnector.add(String.class, StorageConnector::createString);
        StorageConnector.add(ByteBuffer.class, StorageConnector::createByteBuffer);
        StorageConnector.add(DataInput.class, StorageConnector::createDataInput);
        StorageConnector.add(DataOutput.class, StorageConnector::createDataOutput);
        StorageConnector.add(ImageInputStream.class, StorageConnector::createImageInputStream);
        StorageConnector.add(InputStream.class, StorageConnector::createInputStream);
        StorageConnector.add(OutputStream.class, StorageConnector::createOutputStream);
        StorageConnector.add(Reader.class, StorageConnector::createReader);
        StorageConnector.add(Connection.class, StorageConnector::createConnection);
        StorageConnector.add(ChannelDataInput.class, s -> s.createChannelDataInput(false));
        StorageConnector.add(ChannelDataOutput.class, StorageConnector::createChannelDataOutput);
        StorageConnector.add(ChannelFactory.class, s -> null);
        StorageConnector.add(URI.class, null);
        StorageConnector.add(URL.class, null);
        StorageConnector.add(File.class, null);
        StorageConnector.add(Path.class, null);
    }

    private static final class Coupled {
        Object view;
        final Coupled wrapperFor;
        private Coupled[] wrappedBy;
        final byte cascade;
        boolean isValid;

        Coupled(Object storage) {
            this.view = storage;
            this.wrapperFor = null;
            this.cascade = 0;
            this.isValid = true;
        }

        Coupled(Coupled wrapperFor, byte cascade) {
            this.wrapperFor = wrapperFor;
            this.cascade = cascade;
            if (wrapperFor != null) {
                Coupled[] w = wrapperFor.wrappedBy;
                int n = w != null ? w.length : 0;
                Coupled[] e = new Coupled[n + 1];
                if (n != 0) {
                    System.arraycopy(w, 0, e, 0, n);
                }
                e[n] = this;
                wrapperFor.wrappedBy = e;
            }
        }

        final boolean cascadeOnClose() {
            return (this.cascade & 1) != 0;
        }

        final boolean cascadeOnReset() {
            return (this.cascade & 2) != 0;
        }

        final void invalidateSources() {
            boolean sync = this.cascadeOnReset();
            Coupled c = this.wrapperFor;
            while (sync) {
                c.isValid = false;
                sync = c.cascadeOnReset();
                c = c.wrapperFor;
            }
        }

        final void invalidateUsages() {
            if (this.wrappedBy != null) {
                for (Coupled c : this.wrappedBy) {
                    if (!c.cascadeOnReset()) continue;
                    c.isValid = false;
                    c.invalidateUsages();
                }
            }
        }

        final void protect(Map<AutoCloseable, Boolean> toClose) {
            if (this.wrappedBy != null) {
                for (Coupled c : this.wrappedBy) {
                    if (c.cascadeOnClose()) continue;
                    if (c.view instanceof AutoCloseable) {
                        toClose.put((AutoCloseable)c.view, Boolean.FALSE);
                    }
                    c.protect(toClose);
                }
            }
        }

        final boolean reset() throws IOException {
            if (this.isValid) {
                return false;
            }
            if (this.cascadeOnReset()) {
                this.wrapperFor.reset();
            }
            if ((this.cascade & 4) != 0) {
                this.view = null;
                return true;
            }
            if (this.view instanceof InputStream) {
                ((InputStream)this.view).reset();
            } else if (this.view instanceof Reader) {
                ((Reader)this.view).reset();
            } else if (this.view instanceof ChannelDataInput) {
                ChannelDataInput input = (ChannelDataInput)this.view;
                input.buffer.limit(0);
                input.setStreamPosition(0L);
            } else if (this.view instanceof Channel) {
                String name = null;
                if (this.wrappedBy != null) {
                    for (Coupled c : this.wrappedBy) {
                        if (!(c.view instanceof ChannelDataInput)) continue;
                        ChannelDataInput in = (ChannelDataInput)c.view;
                        if (this.view instanceof SeekableByteChannel) {
                            ((SeekableByteChannel)this.view).position(in.channelOffset);
                            return true;
                        }
                        name = in.filename;
                    }
                }
                if (name == null) {
                    name = Classes.getShortClassName(this.view);
                }
                throw new InvalidSeekException(Resources.format((short)13, name));
            }
            this.isValid = true;
            return true;
        }

        public String toString() {
            return Strings.toString(this.getClass(), "view", Classes.getShortClassName(this.view), "wrapperFor", this.wrapperFor != null ? Classes.getShortClassName(this.wrapperFor.view) : null, "cascade", this.cascade, "isValid", this.isValid);
        }

        final void append(TreeTable.Node appendTo, Map<Class<?>, Coupled> views) {
            Class<?> type = null;
            for (Map.Entry<Class<?>, Coupled> entry : views.entrySet()) {
                Class<?> t;
                if (entry.getValue() != this || (t = Classes.findCommonClass(type, entry.getKey())) == Object.class) continue;
                type = t;
            }
            appendTo.setValue(TableColumn.NAME, Classes.getShortName(type));
            appendTo.setValue(TableColumn.VALUE, Classes.getShortClassName(this.view));
            if (this.wrappedBy != null) {
                for (Coupled c : this.wrappedBy) {
                    c.append(appendTo.newChild(), views);
                }
            }
        }
    }

    @FunctionalInterface
    private static interface Opener<S> {
        public S open(StorageConnector var1) throws Exception;
    }
}

