/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.strategy.optimization;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.lambda.IdentityTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.lambda.TokenTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.lambda.ValueTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.step.ByModulating;
import org.apache.tinkerpop.gremlin.process.traversal.step.Grouping;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.FoldStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.IdStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.LabelStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.PropertiesStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.PropertyKeyStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.PropertyValueStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.IdentityStep;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.AbstractTraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.optimization.IdentityRemovalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.optimization.PathProcessorStrategy;
import org.apache.tinkerpop.gremlin.structure.PropertyType;
import org.apache.tinkerpop.gremlin.structure.T;

public final class ByModulatorOptimizationStrategy
extends AbstractTraversalStrategy<TraversalStrategy.OptimizationStrategy>
implements TraversalStrategy.OptimizationStrategy {
    private static final ByModulatorOptimizationStrategy INSTANCE = new ByModulatorOptimizationStrategy();
    private static final Set<Class<? extends TraversalStrategy.OptimizationStrategy>> PRIORS = new HashSet<Class>(Arrays.asList(PathProcessorStrategy.class, IdentityRemovalStrategy.class));

    private ByModulatorOptimizationStrategy() {
    }

    public static ByModulatorOptimizationStrategy instance() {
        return INSTANCE;
    }

    private void optimizeByModulatingTraversal(TraversalParent step, Traversal.Admin<?, ?> traversal) {
        if (traversal == null) {
            return;
        }
        List<Step> steps = traversal.asAdmin().getSteps();
        if (steps.size() == 1) {
            Step singleStep = steps.get(0);
            this.optimizeForStep(step, traversal, singleStep);
        }
    }

    private void optimizeForStep(TraversalParent step, Traversal.Admin<?, ?> traversal, Step singleStep) {
        if (singleStep instanceof PropertiesStep) {
            PropertiesStep ps = (PropertiesStep)singleStep;
            if (ps.getReturnType().equals((Object)PropertyType.VALUE) && ps.getPropertyKeys().length == 1) {
                step.replaceLocalChild(traversal, new ValueTraversal(ps.getPropertyKeys()[0]));
            }
        } else if (singleStep instanceof IdStep) {
            step.replaceLocalChild(traversal, new TokenTraversal(T.id));
        } else if (singleStep instanceof LabelStep) {
            step.replaceLocalChild(traversal, new TokenTraversal(T.label));
        } else if (singleStep instanceof PropertyKeyStep) {
            step.replaceLocalChild(traversal, new TokenTraversal(T.key));
        } else if (singleStep instanceof PropertyValueStep) {
            step.replaceLocalChild(traversal, new TokenTraversal(T.value));
        } else if (singleStep instanceof IdentityStep) {
            step.replaceLocalChild(traversal, new IdentityTraversal());
        }
    }

    @Override
    public void apply(Traversal.Admin<?, ?> traversal) {
        block1: {
            TraversalParent byModulatingStep;
            block2: {
                List<Step> stepsInCurrentValueTraversal;
                Traversal.Admin currentValueTraversal;
                block3: {
                    Step<?, ?> step = traversal.getParent().asStep();
                    if (!(step instanceof ByModulating) || !(step instanceof TraversalParent)) break block1;
                    byModulatingStep = (TraversalParent)((Object)step);
                    if (!(step instanceof Grouping)) break block2;
                    Grouping grouping = (Grouping)((Object)step);
                    this.optimizeByModulatingTraversal(byModulatingStep, grouping.getKeyTraversal());
                    currentValueTraversal = grouping.getValueTraversal();
                    stepsInCurrentValueTraversal = currentValueTraversal.getSteps();
                    if (stepsInCurrentValueTraversal.size() != 1 || !(stepsInCurrentValueTraversal.get(0) instanceof IdentityStep)) break block3;
                    this.optimizeForStep(byModulatingStep, currentValueTraversal, stepsInCurrentValueTraversal.get(0));
                    break block1;
                }
                if (stepsInCurrentValueTraversal.size() != 2 || !(stepsInCurrentValueTraversal.get(1) instanceof FoldStep)) break block1;
                this.optimizeForStep(byModulatingStep, currentValueTraversal, stepsInCurrentValueTraversal.get(0));
                break block1;
            }
            for (Traversal.Admin byModulatingTraversal : byModulatingStep.getLocalChildren()) {
                this.optimizeByModulatingTraversal(byModulatingStep, byModulatingTraversal);
            }
        }
    }

    @Override
    public Set<Class<? extends TraversalStrategy.OptimizationStrategy>> applyPrior() {
        return PRIORS;
    }
}

