/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.loader;

import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.openejb.loader.BasicURLClassPath;
import org.apache.openejb.loader.JarLocation;
import org.apache.openejb.loader.LoaderRuntimeException;

public class SystemClassPath
extends BasicURLClassPath {
    private URLClassLoader sysLoader;

    @Override
    public void addJarsToPath(File dir) throws Exception {
        this.addJarsToPath(dir, this.getSystemLoader());
        if (this.getSystemLoader() == ClassLoader.getSystemClassLoader()) {
            this.rebuildJavaClassPathVariable();
        }
    }

    @Override
    public void addJarToPath(URL jar) throws Exception {
        this.addJarToPath(jar, this.getSystemLoader());
        if (this.getSystemLoader() == ClassLoader.getSystemClassLoader()) {
            this.rebuildJavaClassPathVariable();
        }
    }

    @Override
    public ClassLoader getClassLoader() {
        try {
            return this.getSystemLoader();
        }
        catch (Exception e) {
            throw new LoaderRuntimeException(e);
        }
    }

    private URLClassLoader getSystemLoader() throws Exception {
        if (this.sysLoader == null) {
            ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
            this.sysLoader = URLClassLoader.class.isInstance(systemClassLoader) ? (URLClassLoader)URLClassLoader.class.cast(systemClassLoader) : this.createCustomizableURLClassLoader(systemClassLoader);
        }
        return this.sysLoader;
    }

    private BasicURLClassPath.CustomizableURLClassLoader createCustomizableURLClassLoader(ClassLoader systemClassLoader) {
        BasicURLClassPath.CustomizableURLClassLoader customizableURLClassLoader = new BasicURLClassPath.CustomizableURLClassLoader(systemClassLoader);
        try {
            customizableURLClassLoader.add(JarLocation.jarLocation(SystemClassPath.class).toURI().toURL());
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return customizableURLClassLoader;
    }

    private void rebuildJavaClassPathVariable() throws Exception {
        URLClassLoader loader = this.getSystemLoader();
        Object cp = this.getURLClassPath(loader);
        Method getURLsMethod = this.getGetURLsMethod();
        URL[] urls = (URL[])getURLsMethod.invoke(cp, new Object[0]);
        if (urls.length < 1) {
            return;
        }
        StringBuilder path = new StringBuilder(urls.length * 32);
        File s = new File(URLDecoder.decode(urls[0].getFile(), "UTF-8"));
        path.append(s.getPath());
        for (int i = 1; i < urls.length; ++i) {
            path.append(File.pathSeparator);
            s = new File(URLDecoder.decode(urls[i].getFile(), "UTF-8"));
            path.append(s.getPath());
        }
        try {
            System.setProperty("java.class.path", path.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Method getGetURLsMethod() {
        return AccessController.doPrivileged(new PrivilegedAction<Method>(){

            @Override
            public Method run() {
                try {
                    URLClassLoader loader = SystemClassPath.this.getSystemLoader();
                    Object cp = SystemClassPath.this.getURLClassPath(loader);
                    Class<?> clazz = cp.getClass();
                    try {
                        return clazz.getDeclaredMethod("getURLs", URL.class);
                    }
                    catch (NoSuchMethodException e) {
                        return clazz.getDeclaredMethod("getURLs", new Class[0]);
                    }
                }
                catch (Exception e) {
                    throw new LoaderRuntimeException(e);
                }
            }
        });
    }
}

