/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.loader;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Properties;
import org.apache.openejb.loader.ClassPath;
import org.apache.openejb.loader.FileUtils;
import org.apache.openejb.loader.LoaderRuntimeException;
import org.apache.openejb.loader.SystemInstance;

public class OpenEJBInstance {
    private final Method init;
    private final Method isInitialized;
    static final String NO_HOME = "The openejb.home is not set.";
    static final String BAD_HOME = "Invalid openejb.home: ";
    static final String NOT_THERE = "The path specified does not exist.";
    static final String NOT_DIRECTORY = "The path specified is not a directory.";
    static final String NO_DIST = "The path specified is not correct, it does not contain a 'dist' directory.";
    static final String NO_LIBS = "The path specified is not correct, it does not contain any OpenEJB libraries.";
    static final String INSTRUCTIONS = "Please edit the web.xml of the openejb_loader webapp and set the openejb.home init-param to the full path where OpenEJB is installed.";

    public OpenEJBInstance() throws Exception {
        Class<?> openejb = this.loadOpenEJBClass();
        this.init = openejb.getMethod("init", Properties.class);
        this.isInitialized = openejb.getMethod("isInitialized", new Class[0]);
    }

    public void init(Properties props) throws Exception {
        try {
            this.init.invoke(null, props);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof Exception) {
                throw (Exception)e.getCause();
            }
            throw (Error)e.getCause();
        }
        catch (Exception e) {
            throw new LoaderRuntimeException("OpenEJB.init: ", e);
        }
    }

    public boolean isInitialized() {
        try {
            return (Boolean)this.isInitialized.invoke(null, new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw new LoaderRuntimeException("OpenEJB.isInitialized: ", e.getCause());
        }
        catch (Exception e) {
            throw new LoaderRuntimeException("OpenEJB.isInitialized: ", e);
        }
    }

    private Class<?> loadOpenEJBClass() throws Exception {
        ClassPath classPath = SystemInstance.get().getClassPath();
        ClassLoader classLoader = classPath.getClassLoader();
        try {
            return classLoader.loadClass("org.apache.openejb.OpenEJB");
        }
        catch (Exception e) {
            try {
                this.checkOpenEjbHome(SystemInstance.get().getHome().getDirectory());
                FileUtils home = SystemInstance.get().getHome();
                classPath.addJarsToPath(home.getDirectory("lib"));
            }
            catch (Exception e2) {
                throw new Exception("Could not load OpenEJB libraries. Exception: " + e2.getClass().getName() + " " + e2.getMessage());
            }
            try {
                return classLoader.loadClass("org.apache.openejb.OpenEJB");
            }
            catch (Exception e2) {
                throw new Exception("Could not load OpenEJB class after embedding libraries. Exception: " + e2.getClass().getName() + " " + e2.getMessage());
            }
        }
    }

    private void checkOpenEjbHome(File openejbHome) throws Exception {
        try {
            File openejbHomeLibs;
            String homePath = openejbHome.getAbsolutePath();
            if (!openejbHome.exists()) {
                this.handleError(BAD_HOME + homePath, NOT_THERE, INSTRUCTIONS);
            }
            if (!openejbHome.isDirectory()) {
                this.handleError(BAD_HOME + homePath, NOT_DIRECTORY, INSTRUCTIONS);
            }
            if (!(openejbHomeLibs = new File(openejbHome, "lib")).exists()) {
                this.handleError(BAD_HOME + homePath, NO_DIST, INSTRUCTIONS);
            }
            String[] libs = openejbHomeLibs.list();
            boolean found = false;
            for (int i = 0; i < libs.length && !found; ++i) {
                found = libs[i].startsWith("openejb-") && libs[i].endsWith(".jar");
            }
            if (!found) {
                this.handleError(BAD_HOME + homePath, NO_LIBS, INSTRUCTIONS);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void handleError(String m1, String m2, String m3) throws Exception {
        System.err.println("--[PLEASE FIX]-------------------------------------");
        System.err.println(m1);
        System.err.println(m2);
        System.err.println(m3);
        System.err.println("---------------------------------------------------");
        throw new Exception(m1 + " " + m2 + " " + m3);
    }
}

