/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.torque.dynamic;

import java.sql.Connection;
import org.apache.fulcrum.security.entity.Group;
import org.apache.fulcrum.security.entity.Permission;
import org.apache.fulcrum.security.entity.Role;
import org.apache.fulcrum.security.entity.User;
import org.apache.fulcrum.security.model.dynamic.AbstractDynamicModelManager;
import org.apache.fulcrum.security.model.dynamic.DynamicModelManager;
import org.apache.fulcrum.security.model.dynamic.entity.DynamicGroup;
import org.apache.fulcrum.security.model.dynamic.entity.DynamicPermission;
import org.apache.fulcrum.security.model.dynamic.entity.DynamicRole;
import org.apache.fulcrum.security.model.dynamic.entity.DynamicUser;
import org.apache.fulcrum.security.torque.security.TorqueAbstractSecurityEntity;
import org.apache.fulcrum.security.util.DataBackendException;
import org.apache.fulcrum.security.util.UnknownEntityException;
import org.apache.torque.TorqueException;
import org.apache.torque.util.TorqueConnection;
import org.apache.torque.util.Transaction;

public class TorqueDynamicModelManagerImpl
extends AbstractDynamicModelManager
implements DynamicModelManager {
    private static final long serialVersionUID = -4102444603078107928L;

    public synchronized void revoke(Group group, Role role) throws DataBackendException, UnknownEntityException {
        boolean groupExists = this.getGroupManager().checkExists(group);
        boolean roleExists = this.getRoleManager().checkExists(role);
        if (groupExists && roleExists) {
            ((DynamicGroup)group).removeRole(role);
            ((DynamicRole)role).removeGroup(group);
            TorqueConnection con = null;
            try {
                con = Transaction.begin();
                ((TorqueAbstractSecurityEntity)role).update((Connection)con);
                ((TorqueAbstractSecurityEntity)group).update((Connection)con);
                Transaction.commit((Connection)con);
                con = null;
            }
            catch (TorqueException e) {
                throw new DataBackendException("revoke('" + group.getName() + "', '" + role.getName() + "') failed", (Throwable)e);
            }
            finally {
                if (con != null) {
                    Transaction.safeRollback((Connection)con);
                }
            }
            return;
        }
        if (!groupExists) {
            throw new UnknownEntityException("Unknown group '" + group.getName() + "'");
        }
        if (!roleExists) {
            throw new UnknownEntityException("Unknown role '" + role.getName() + "'");
        }
    }

    public synchronized void grant(Role role, Permission permission) throws DataBackendException, UnknownEntityException {
        boolean roleExists = this.getRoleManager().checkExists(role);
        boolean permissionExists = this.getPermissionManager().checkExists(permission);
        if (roleExists && permissionExists) {
            ((DynamicRole)role).addPermission(permission);
            ((DynamicPermission)permission).addRole(role);
            TorqueConnection con = null;
            try {
                con = Transaction.begin();
                ((TorqueAbstractSecurityEntity)role).update((Connection)con);
                ((TorqueAbstractSecurityEntity)permission).update((Connection)con);
                Transaction.commit((Connection)con);
                con = null;
            }
            catch (TorqueException e) {
                throw new DataBackendException("grant('" + role.getName() + "', '" + permission.getName() + "') failed", (Throwable)e);
            }
            finally {
                if (con != null) {
                    Transaction.safeRollback((Connection)con);
                }
            }
            return;
        }
        if (!roleExists) {
            throw new UnknownEntityException("Unknown role '" + role.getName() + "'");
        }
        if (!permissionExists) {
            throw new UnknownEntityException("Unknown permission '" + permission.getName() + "'");
        }
    }

    public synchronized void revoke(Role role, Permission permission) throws DataBackendException, UnknownEntityException {
        boolean roleExists = this.getRoleManager().checkExists(role);
        boolean permissionExists = this.getPermissionManager().checkExists(permission);
        if (roleExists && permissionExists) {
            ((DynamicRole)role).removePermission(permission);
            ((DynamicPermission)permission).removeRole(role);
            TorqueConnection con = null;
            try {
                con = Transaction.begin();
                ((TorqueAbstractSecurityEntity)role).update((Connection)con);
                ((TorqueAbstractSecurityEntity)permission).update((Connection)con);
                Transaction.commit((Connection)con);
                con = null;
            }
            catch (TorqueException e) {
                throw new DataBackendException("revoke('" + role.getName() + "', '" + permission.getName() + "') failed", (Throwable)e);
            }
            finally {
                if (con != null) {
                    Transaction.safeRollback((Connection)con);
                }
            }
            return;
        }
        if (!roleExists) {
            throw new UnknownEntityException("Unknown role '" + role.getName() + "'");
        }
        if (!permissionExists) {
            throw new UnknownEntityException("Unknown permission '" + permission.getName() + "'");
        }
    }

    public synchronized void grant(User user, Group group) throws DataBackendException, UnknownEntityException {
        boolean groupExists = this.getGroupManager().checkExists(group);
        boolean userExists = this.getUserManager().checkExists(user);
        if (groupExists && userExists) {
            ((DynamicUser)user).addGroup(group);
            ((DynamicGroup)group).addUser(user);
            TorqueConnection con = null;
            try {
                con = Transaction.begin();
                ((TorqueAbstractSecurityEntity)user).update((Connection)con);
                ((TorqueAbstractSecurityEntity)group).update((Connection)con);
                Transaction.commit((Connection)con);
                con = null;
            }
            catch (TorqueException e) {
                throw new DataBackendException("grant('" + user.getName() + "', '" + group.getName() + "') failed", (Throwable)e);
            }
            finally {
                if (con != null) {
                    Transaction.safeRollback((Connection)con);
                }
            }
            return;
        }
        if (!groupExists) {
            throw new UnknownEntityException("Unknown group '" + group.getName() + "'");
        }
        if (!userExists) {
            throw new UnknownEntityException("Unknown user '" + user.getName() + "'");
        }
    }

    public synchronized void revoke(User user, Group group) throws DataBackendException, UnknownEntityException {
        boolean groupExists = this.getGroupManager().checkExists(group);
        boolean userExists = this.getUserManager().checkExists(user);
        if (groupExists && userExists) {
            ((DynamicUser)user).removeGroup(group);
            ((DynamicGroup)group).removeUser(user);
            TorqueConnection con = null;
            try {
                con = Transaction.begin();
                ((TorqueAbstractSecurityEntity)user).update((Connection)con);
                ((TorqueAbstractSecurityEntity)group).update((Connection)con);
                Transaction.commit((Connection)con);
                con = null;
            }
            catch (TorqueException e) {
                throw new DataBackendException("revoke('" + user.getName() + "', '" + group.getName() + "') failed", (Throwable)e);
            }
            finally {
                if (con != null) {
                    Transaction.safeRollback((Connection)con);
                }
            }
            return;
        }
        if (!groupExists) {
            throw new UnknownEntityException("Unknown group '" + group.getName() + "'");
        }
        if (!userExists) {
            throw new UnknownEntityException("Unknown user '" + user.getName() + "'");
        }
    }

    public synchronized void grant(Group group, Role role) throws DataBackendException, UnknownEntityException {
        boolean groupExists = this.getGroupManager().checkExists(group);
        boolean roleExists = this.getRoleManager().checkExists(role);
        if (groupExists && roleExists) {
            ((DynamicGroup)group).addRole(role);
            ((DynamicRole)role).addGroup(group);
            TorqueConnection con = null;
            try {
                con = Transaction.begin();
                ((TorqueAbstractSecurityEntity)role).update((Connection)con);
                ((TorqueAbstractSecurityEntity)group).update((Connection)con);
                Transaction.commit((Connection)con);
                con = null;
            }
            catch (TorqueException e) {
                throw new DataBackendException("grant('" + group.getName() + "', '" + role.getName() + "') failed", (Throwable)e);
            }
            finally {
                if (con != null) {
                    Transaction.safeRollback((Connection)con);
                }
            }
            return;
        }
        if (!groupExists) {
            throw new UnknownEntityException("Unknown group '" + group.getName() + "'");
        }
        if (!roleExists) {
            throw new UnknownEntityException("Unknown role '" + role.getName() + "'");
        }
    }

    public synchronized void addDelegate(User delegator, User delegatee) throws DataBackendException, UnknownEntityException {
        boolean delegatorExists = this.getUserManager().checkExists(delegator);
        boolean delegateeExists = this.getUserManager().checkExists(delegatee);
        if (delegatorExists && delegateeExists) {
            super.addDelegate(delegator, delegatee);
            TorqueConnection con = null;
            try {
                con = Transaction.begin();
                ((TorqueAbstractSecurityEntity)delegator).update((Connection)con);
                ((TorqueAbstractSecurityEntity)delegatee).update((Connection)con);
                Transaction.commit((Connection)con);
                con = null;
            }
            catch (TorqueException e) {
                throw new DataBackendException("addDelegate('" + delegator.getName() + "', '" + delegatee.getName() + "') failed", (Throwable)e);
            }
            finally {
                if (con != null) {
                    Transaction.safeRollback((Connection)con);
                }
            }
            return;
        }
        if (!delegatorExists) {
            throw new UnknownEntityException("Unknown user '" + delegator.getName() + "'");
        }
        if (!delegateeExists) {
            throw new UnknownEntityException("Unknown user '" + delegatee.getName() + "'");
        }
    }

    public synchronized void removeDelegate(User delegator, User delegatee) throws DataBackendException, UnknownEntityException {
        boolean delegatorExists = this.getUserManager().checkExists(delegator);
        boolean delegateeExists = this.getUserManager().checkExists(delegatee);
        if (delegatorExists && delegateeExists) {
            super.removeDelegate(delegator, delegatee);
            TorqueConnection con = null;
            try {
                con = Transaction.begin();
                ((TorqueAbstractSecurityEntity)delegator).update((Connection)con);
                ((TorqueAbstractSecurityEntity)delegatee).update((Connection)con);
                Transaction.commit((Connection)con);
                con = null;
            }
            catch (TorqueException e) {
                throw new DataBackendException("removeDelegate('" + delegator.getName() + "', '" + delegatee.getName() + "') failed", (Throwable)e);
            }
            finally {
                if (con != null) {
                    Transaction.safeRollback((Connection)con);
                }
            }
            return;
        }
        if (!delegatorExists) {
            throw new UnknownEntityException("Unknown user '" + delegator.getName() + "'");
        }
        if (!delegateeExists) {
            throw new UnknownEntityException("Unknown user '" + delegatee.getName() + "'");
        }
    }
}

