/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.messagelet.impl;

import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.collections.iterators.IteratorEnumeration;
import org.apache.commons.messagelet.impl.HttpSessionImpl;
import org.apache.commons.messagelet.impl.RequestUtil;
import org.apache.commons.messagelet.impl.ServletRequestImpl;

public class HttpServletRequestImpl
extends ServletRequestImpl
implements HttpServletRequest {
    protected String authType = null;
    protected String contextPath = "";
    protected ArrayList cookies = new ArrayList();
    protected SimpleDateFormat[] formats = new SimpleDateFormat[]{new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEEEEE, dd-MMM-yy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEE MMMM d HH:mm:ss yyyy", Locale.US)};
    protected HashMap headers = new HashMap();
    protected String method = null;
    protected String pathInfo = null;
    protected String queryString = null;
    protected boolean requestedSessionCookie = false;
    protected String requestedSessionId = null;
    protected boolean requestedSessionURL = false;
    protected String requestURI = null;
    protected String servletPath = null;
    protected HttpSessionImpl session = null;
    protected Principal userPrincipal = null;
    private Map parameters = null;

    public HttpServletRequestImpl(ServletContext servletContext) {
        super(servletContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCookie(Cookie cookie) {
        ArrayList arrayList = this.cookies;
        synchronized (arrayList) {
            this.cookies.add(cookie);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHeader(String name, String value) {
        name = name.toLowerCase();
        HashMap hashMap = this.headers;
        synchronized (hashMap) {
            ArrayList<String> values = (ArrayList<String>)this.headers.get(name);
            if (values == null) {
                values = new ArrayList<String>();
                this.headers.put(name, values);
            }
            values.add(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCookies() {
        ArrayList arrayList = this.cookies;
        synchronized (arrayList) {
            this.cookies.clear();
        }
    }

    public void clearHeaders() {
        this.headers.clear();
    }

    public void setAuthType(String authType) {
        this.authType = authType;
    }

    public void setContextPath(String path) {
        this.contextPath = path == null ? "" : path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setPathInfo(String path) {
        this.pathInfo = path;
    }

    public void setQueryString(String query) {
        this.queryString = query;
        this.parameters = null;
    }

    public void setRequestedSessionCookie(boolean flag) {
        this.requestedSessionCookie = flag;
    }

    public void setRequestedSessionId(String id) {
        this.requestedSessionId = id;
    }

    public void setRequestedSessionURL(boolean flag) {
        this.requestedSessionURL = flag;
    }

    public void setRequestURI(String uri) {
        this.requestURI = uri;
    }

    public void setServletPath(String path) {
        this.servletPath = path;
    }

    public void setUserPrincipal(Principal principal) {
        this.userPrincipal = principal;
    }

    public String getAuthType() {
        return this.authType;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cookie[] getCookies() {
        ArrayList arrayList = this.cookies;
        synchronized (arrayList) {
            if (this.cookies.size() < 1) {
                return null;
            }
            Cookie[] results = new Cookie[this.cookies.size()];
            return this.cookies.toArray(results);
        }
    }

    public long getDateHeader(String name) {
        String value = this.getHeader(name);
        if (value == null) {
            return -1L;
        }
        value = value + " ";
        int i = 0;
        while (i < this.formats.length) {
            try {
                Date date = this.formats[i].parse(value);
                return date.getTime();
            }
            catch (ParseException e) {
                ++i;
            }
        }
        throw new IllegalArgumentException(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getHeader(String name) {
        name = name.toLowerCase();
        HashMap hashMap = this.headers;
        synchronized (hashMap) {
            ArrayList values = (ArrayList)this.headers.get(name);
            if (values != null) {
                return (String)values.get(0);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getHeaders(String name) {
        name = name.toLowerCase();
        HashMap hashMap = this.headers;
        synchronized (hashMap) {
            ArrayList values = (ArrayList)this.headers.get(name);
            if (values != null) {
                return new IteratorEnumeration(((AbstractList)values).iterator());
            }
            return new IteratorEnumeration(Collections.EMPTY_LIST.iterator());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getHeaderNames() {
        HashMap hashMap = this.headers;
        synchronized (hashMap) {
            return new IteratorEnumeration(this.headers.keySet().iterator());
        }
    }

    public int getIntHeader(String name) {
        String value = this.getHeader(name);
        if (value == null) {
            return -1;
        }
        return Integer.parseInt(value);
    }

    public String getMethod() {
        return this.method;
    }

    public Map getParameterMap() {
        block3: {
            if (this.parameters != null) break block3;
            this.parameters = new HashMap();
            if (this.queryString != null) {
                try {
                    RequestUtil.parseParameters(this.parameters, this.queryString, this.getCharacterEncoding());
                }
                catch (UnsupportedEncodingException e) {
                    this.servletContext.log("Could not parse query string: " + this.queryString, (Throwable)e);
                }
            }
        }
        return this.parameters;
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public String getPathTranslated() {
        if (this.pathInfo == null) {
            return null;
        }
        return this.servletContext.getRealPath(this.pathInfo);
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getRemoteUser() {
        if (this.userPrincipal != null) {
            return this.userPrincipal.getName();
        }
        return null;
    }

    public String getRequestedSessionId() {
        return this.requestedSessionId;
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public StringBuffer getRequestURL() {
        StringBuffer url = new StringBuffer();
        String scheme = this.getScheme();
        int port = this.getServerPort();
        if (port < 0) {
            port = 80;
        }
        url.append(scheme);
        url.append("://");
        url.append(this.getServerName());
        if (scheme.equals("http") && port != 80 || scheme.equals("https") && port != 443) {
            url.append(':');
            url.append(port);
        }
        url.append(this.getRequestURI());
        return url;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public HttpSession getSession(boolean create) {
        if (this.session != null && !this.session.isValid()) {
            this.session = null;
        }
        if (create && this.session == null) {
            this.session = new HttpSessionImpl(this.servletContext);
        }
        return this.session;
    }

    public boolean isRequestedSessionIdFromCookie() {
        if (this.requestedSessionId != null) {
            return this.requestedSessionCookie;
        }
        return false;
    }

    public boolean isRequestedSessionIdFromURL() {
        if (this.requestedSessionId != null) {
            return this.requestedSessionURL;
        }
        return false;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdValid() {
        return false;
    }

    public boolean isUserInRole(String role) {
        return false;
    }

    public Principal getUserPrincipal() {
        return this.userPrincipal;
    }
}

