/*
 * Decompiled with CFR 0.152.
 */
package ojb.odmg.collections;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Vector;
import ojb.broker.PersistenceBroker;
import ojb.broker.PersistenceBrokerException;
import ojb.broker.metadata.ClassDescriptor;
import ojb.broker.metadata.ClassNotPersistenceCapableException;
import ojb.broker.metadata.DescriptorRepository;
import ojb.broker.metadata.FieldDescriptor;
import ojb.broker.query.Criteria;
import ojb.broker.query.CriteriaException;
import ojb.broker.query.Query;
import ojb.broker.query.QueryByCriteria;
import ojb.odmg.DatabaseImpl;
import ojb.odmg.OJB;
import ojb.odmg.TransactionImpl;
import ojb.odmg.collections.DListEntry;
import ojb.odmg.collections.DListImpl;
import ojb.odmg.collections.DSetEntry;
import ojb.odmg.collections.DSetIterator;
import ojb.odmg.oql.OQLQueryImpl;
import org.odmg.DCollection;
import org.odmg.DList;
import org.odmg.DSet;
import org.odmg.OQLQuery;
import org.odmg.QueryInvalidException;
import org.odmg.Transaction;

public class DSetImpl
extends AbstractSet
implements DSet {
    private int id;
    private Vector elements;
    private int size;
    static /* synthetic */ Class class$ojb$odmg$collections$DListImpl;

    public DSetImpl() {
        this.elements = new Vector();
        this.id = this.generateNewId();
        this.size = 0;
    }

    public DSetImpl(int theId, int theSize) {
        this.id = theId;
        this.size = theSize;
    }

    public boolean add(Object o) {
        if (!this.contains(o)) {
            ++this.size;
            DSetEntry entry = new DSetEntry(this, o);
            this.elements.add(entry);
            TransactionImpl tx = (TransactionImpl)OJB.getInstance().currentTransaction();
            if (tx != null) {
                tx.lock(this, 4);
                tx.lock(entry, 4);
                tx.lock(o, 1);
            }
            return true;
        }
        return false;
    }

    public DSet difference(DSet otherSet) {
        DSetImpl result = new DSetImpl();
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            Object candidate = iter.next();
            if (otherSet.contains(candidate)) continue;
            result.add(candidate);
        }
        return result;
    }

    public boolean existsElement(String predicate) throws QueryInvalidException {
        DList results = (DList)this.query(predicate);
        return results != null && results.size() != 0;
    }

    private int generateNewId() {
        PersistenceBroker broker = ((DatabaseImpl)OJB.getInstance().getDatabase(null)).getBroker();
        try {
            return broker.getUniqueId(class$ojb$odmg$collections$DListImpl == null ? (class$ojb$odmg$collections$DListImpl = DSetImpl.class$("ojb.odmg.collections.DListImpl")) : class$ojb$odmg$collections$DListImpl, "id");
        }
        catch (PersistenceBrokerException e) {
            return -1;
        }
    }

    Vector getElements() {
        return this.elements;
    }

    int getId() {
        return this.id;
    }

    public DSet intersection(DSet otherSet) {
        DSet union = this.union(otherSet);
        DSetImpl result = new DSetImpl();
        Iterator iter = union.iterator();
        while (iter.hasNext()) {
            Object candidate = iter.next();
            if (!this.contains(candidate) || !otherSet.contains(candidate)) continue;
            result.add(candidate);
        }
        return result;
    }

    public Iterator iterator() {
        return new DSetIterator(this);
    }

    public boolean properSubsetOf(DSet otherSet) {
        return this.size() > 0 && this.size() < otherSet.size() && this.subsetOf(otherSet);
    }

    public boolean properSupersetOf(DSet otherSet) {
        return otherSet.size() > 0 && otherSet.size() < this.size() && this.supersetOf(otherSet);
    }

    public DCollection query(String predicate) throws QueryInvalidException {
        String oql = "select all from java.lang.Object where " + predicate;
        OQLQuery predicateQuery = OJB.getInstance().newOQLQuery();
        predicateQuery.create(oql);
        Query pQ = ((OQLQueryImpl)predicateQuery).getQuery();
        Criteria pCrit = pQ.getCriteria();
        Criteria allElementsCriteria = this.getPkCriteriaForAllElements();
        pCrit.addAndCriteria(allElementsCriteria);
        Class clazz = this.getElementsExtentClass();
        QueryByCriteria q = new QueryByCriteria(clazz, pCrit);
        System.out.println(((Object)q).toString());
        PersistenceBroker broker = ((DatabaseImpl)OJB.getInstance().getDatabase(null)).getBroker();
        Transaction tx = OJB.getInstance().currentTransaction();
        boolean needsCommit = false;
        if (tx == null) {
            tx = OJB.getInstance().newTransaction();
            tx.begin();
            needsCommit = true;
        }
        DListImpl result = null;
        try {
            result = (DListImpl)broker.getCollectionByQuery(class$ojb$odmg$collections$DListImpl == null ? (class$ojb$odmg$collections$DListImpl = DSetImpl.class$("ojb.odmg.collections.DListImpl")) : class$ojb$odmg$collections$DListImpl, q);
        }
        catch (PersistenceBrokerException e) {
            // empty catch block
        }
        if (needsCommit) {
            tx.commit();
        }
        return result;
    }

    private Criteria getPkCriteriaForAllElements() {
        try {
            Criteria crit = null;
            int i = 0;
            while (i < this.elements.size()) {
                DListEntry entry = (DListEntry)this.elements.get(i);
                Object obj = entry.getRealSubject();
                ClassDescriptor cld = DescriptorRepository.getInstance().getDescriptorFor(obj.getClass());
                FieldDescriptor[] pkFields = cld.getPkFields();
                Object[] pkValues = cld.getKeyValues(obj);
                Criteria criteria = new Criteria();
                int j = 0;
                while (j < pkFields.length) {
                    FieldDescriptor fld = pkFields[j];
                    criteria.addEqualTo(fld.getPersistentField().getName(), pkValues[j]);
                    ++j;
                }
                try {
                    if (crit == null) {
                        crit = criteria;
                    } else {
                        crit.addOrCriteria(criteria);
                    }
                }
                catch (CriteriaException e) {
                    // empty catch block
                }
                ++i;
            }
            return crit;
        }
        catch (ClassNotPersistenceCapableException e) {
            return null;
        }
    }

    private Class getElementsExtentClass() {
        DListEntry entry = (DListEntry)this.elements.get(0);
        Class<?> elementsClass = entry.getRealSubject().getClass();
        Class extentClass = DescriptorRepository.getInstance().getExtentClass(elementsClass);
        return extentClass;
    }

    public Iterator select(String predicate) throws QueryInvalidException {
        return this.query(predicate).iterator();
    }

    public Object selectElement(String predicate) throws QueryInvalidException {
        return ((DList)this.query(predicate)).get(0);
    }

    void setElements(Vector newElements) {
        this.elements = newElements;
    }

    void setId(int newId) {
        this.id = newId;
    }

    public int size() {
        return this.elements.size();
    }

    public boolean subsetOf(DSet otherSet) {
        return otherSet.containsAll(this);
    }

    public boolean supersetOf(DSet otherSet) {
        return this.containsAll(otherSet);
    }

    public DSet union(DSet otherSet) {
        DSetImpl result = new DSetImpl();
        result.addAll(this);
        result.addAll(otherSet);
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

