/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util;

import org.apache.turbine.om.security.Permission;
import org.apache.turbine.om.security.Role;
import org.apache.turbine.services.security.TurbineSecurity;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.security.RoleSet;
import org.apache.turbine.util.security.UnknownEntityException;

public class SecurityCheck {
    private String message;
    private String failScreen;
    private RunData data = null;
    private boolean initialize;

    public SecurityCheck(RunData data, String message, String failedScreen) {
        this(data, message, failedScreen, false);
    }

    public SecurityCheck(RunData data, String message, String failedScreen, boolean initialize) {
        this.data = data;
        this.message = message;
        this.failScreen = failedScreen;
        this.initialize = initialize;
    }

    public boolean hasRole(Role role) throws Exception {
        boolean value = false;
        if (this.data.getACL() == null || !this.data.getACL().hasRole(role)) {
            this.data.setScreen(this.failScreen);
            this.data.setMessage(this.message);
        } else {
            value = true;
        }
        return value;
    }

    public boolean hasRole(String role) throws Exception {
        Role roleObject = null;
        try {
            roleObject = TurbineSecurity.getRoleByName(role);
        }
        catch (UnknownEntityException e) {
            if (this.initialize) {
                roleObject = TurbineSecurity.createRole(role);
                TurbineSecurity.grant(this.data.getUser(), TurbineSecurity.getGlobalGroup(), roleObject);
            }
            throw e;
        }
        return this.hasRole(TurbineSecurity.getRoleByName(role));
    }

    public boolean hasPermission(Permission permission) throws Exception {
        boolean value = false;
        if (this.data.getACL() == null || !this.data.getACL().hasPermission(permission)) {
            this.data.setScreen(this.failScreen);
            this.data.setMessage(this.message);
        } else {
            value = true;
        }
        return value;
    }

    public boolean hasPermission(String permission) throws Exception {
        Permission permissionObject = null;
        try {
            permissionObject = TurbineSecurity.getPermissionByName(permission);
        }
        catch (UnknownEntityException e) {
            if (this.initialize) {
                permissionObject = TurbineSecurity.createPermission(permission);
                Role role = null;
                RoleSet roles = this.data.getACL().getRoles();
                if (roles.size() > 0) {
                    role = roles.getRolesArray()[0];
                }
                if (role == null && (roles = TurbineSecurity.getAllRoles()).size() > 0) {
                    role = roles.getRolesArray()[0];
                }
                if (role != null) {
                    TurbineSecurity.grant(this.data.getACL().getRoles().getRolesArray()[0], permissionObject);
                }
            }
            throw e;
        }
        return this.hasPermission(permissionObject);
    }

    public String getMessage() {
        return this.message;
    }

    public String getFailScreen() {
        return this.failScreen;
    }
}

