/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.om.security.peer;

import com.workingdogs.village.Record;
import java.util.ArrayList;
import java.util.List;
import org.apache.torque.Torque;
import org.apache.torque.TorqueException;
import org.apache.torque.om.BaseObject;
import org.apache.torque.om.NumberKey;
import org.apache.torque.om.ObjectKey;
import org.apache.torque.util.BasePeer;
import org.apache.torque.util.Criteria;
import org.apache.turbine.om.security.Group;
import org.apache.turbine.om.security.TurbineGroup;
import org.apache.turbine.services.security.TurbineSecurity;
import org.apache.turbine.util.db.map.TurbineMapBuilder;
import org.apache.turbine.util.security.DataBackendException;
import org.apache.turbine.util.security.GroupSet;

public class GroupPeer
extends BasePeer {
    private static final long serialVersionUID = 2902002237040953323L;
    private static final TurbineMapBuilder MAP_BUILDER;
    private static final String TABLE_NAME;
    public static final String GROUP_ID;
    public static final String NAME;
    public static final String OBJECTDATA;

    public static GroupSet retrieveSet() throws Exception {
        return GroupPeer.retrieveSet(new Criteria());
    }

    public static GroupSet retrieveSet(Criteria criteria) throws Exception {
        List results = GroupPeer.doSelect(criteria);
        GroupSet rs = new GroupSet();
        for (int i = 0; i < results.size(); ++i) {
            rs.add((Group)results.get(i));
        }
        return rs;
    }

    public static List doSelect(Criteria criteria) throws TorqueException {
        try {
            criteria.addSelectColumn(GROUP_ID).addSelectColumn(NAME).addSelectColumn(OBJECTDATA);
            if (criteria.getOrderByColumns() == null || criteria.getOrderByColumns().size() == 0) {
                criteria.addAscendingOrderByColumn(NAME);
            }
            List rows = BasePeer.doSelect((Criteria)criteria);
            ArrayList<Group> results = new ArrayList<Group>();
            for (int i = 0; i < rows.size(); ++i) {
                Group obj = TurbineSecurity.getGroupInstance(null);
                Record row = (Record)rows.get(i);
                ((TurbineGroup)obj).setPrimaryKey((ObjectKey)new NumberKey(row.getValue(1).asInt()));
                ((TurbineGroup)obj).setName(row.getValue(2).asString());
                results.add(obj);
            }
            return results;
        }
        catch (Exception ex) {
            throw new TorqueException((Throwable)ex);
        }
    }

    public static void doUpdate(Criteria criteria) throws TorqueException {
        Criteria selectCriteria = new Criteria(2);
        selectCriteria.put((Object)GROUP_ID, criteria.remove(GROUP_ID));
        BasePeer.doUpdate((Criteria)selectCriteria, (Criteria)criteria);
    }

    public static boolean checkExists(Group group) throws DataBackendException, Exception {
        Criteria criteria = new Criteria();
        criteria.addSelectColumn(GROUP_ID);
        criteria.add(NAME, (Object)((TurbineGroup)group).getName());
        List results = BasePeer.doSelect((Criteria)criteria);
        if (results.size() > 1) {
            throw new DataBackendException("Multiple groups named '" + ((TurbineGroup)group).getName() + "' exist!");
        }
        return results.size() == 1;
    }

    public static String getTableName() {
        return TABLE_NAME;
    }

    public static String getColumnName(String name) {
        StringBuffer sb = new StringBuffer();
        sb.append(TABLE_NAME);
        sb.append(".");
        sb.append(name);
        return sb.toString();
    }

    public static Criteria buildCriteria(Group group) {
        Criteria criteria = new Criteria();
        criteria.add(NAME, (Object)((TurbineGroup)group).getName());
        if (!((BaseObject)group).isNew()) {
            criteria.add(GROUP_ID, (Object)((BaseObject)group).getPrimaryKey());
        }
        return criteria;
    }

    static {
        try {
            MAP_BUILDER = (TurbineMapBuilder)Torque.getMapBuilder((String)TurbineMapBuilder.class.getName());
        }
        catch (TorqueException e) {
            log.error((Object)"Could not initialize Peer", (Throwable)e);
            throw new RuntimeException(e);
        }
        TABLE_NAME = MAP_BUILDER.getTableGroup();
        GROUP_ID = MAP_BUILDER.getGroup_GroupId();
        NAME = MAP_BUILDER.getGroup_Name();
        OBJECTDATA = MAP_BUILDER.getGroup_ObjectData();
    }
}

