/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.modules.screens;

import com.metaparadigm.jsonrpc.JSONRPCBridge;
import java.io.BufferedReader;
import java.io.CharArrayWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import org.apache.turbine.modules.screens.RawScreen;
import org.apache.turbine.services.jsonrpc.TurbineJsonRpc;
import org.apache.turbine.util.RunData;

public class JSONScreen
extends RawScreen {
    protected static final String JSONRPC_CONTENT_TYPE = "text/plain";
    protected static final int BUFFER_SIZE = 4096;

    protected String getContentType(RunData data) {
        return JSONRPC_CONTENT_TYPE;
    }

    protected void doOutput(RunData data) throws Exception {
        int ret;
        data.declareDirectResponse();
        HttpServletRequest request = data.getRequest();
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)request.getInputStream()));
        CharArrayWriter cdata = new CharArrayWriter();
        char[] buf = new char[4096];
        while ((ret = in.read(buf, 0, 4096)) != -1) {
            cdata.write(buf, 0, ret);
        }
        JSONRPCBridge json_bridge = TurbineJsonRpc.getBridge(data.getSession());
        Object json_res = TurbineJsonRpc.processCall(cdata, json_bridge, request);
        PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)data.getResponse().getOutputStream()));
        out.print(json_res.toString());
        out.flush();
        out.close();
    }
}

