/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque;

import org.apache.torque.adapter.DB;
import org.apache.torque.dsfactory.DataSourceFactory;
import org.apache.torque.map.DatabaseMap;
import org.apache.torque.oid.IDBroker;
import org.apache.torque.oid.IdGenerator;

public class Database {
    private String name;
    private DB adapter;
    private DatabaseMap databaseMap;
    private DataSourceFactory dataSourceFactory;

    Database(String aName) {
        this.name = aName;
    }

    public String getName() {
        return this.name;
    }

    public DB getAdapter() {
        return this.adapter;
    }

    public void setAdapter(DB anAdapter) {
        this.adapter = anAdapter;
    }

    public synchronized DatabaseMap getDatabaseMap() {
        if (this.databaseMap == null) {
            this.databaseMap = new DatabaseMap(this.name);
        }
        return this.databaseMap;
    }

    public DataSourceFactory getDataSourceFactory() {
        return this.dataSourceFactory;
    }

    public void setDataSourceFactory(DataSourceFactory aDataSourceFactory) {
        this.dataSourceFactory = aDataSourceFactory;
    }

    public IDBroker getIDBroker() {
        if (this.databaseMap == null) {
            return null;
        }
        return this.databaseMap.getIDBroker();
    }

    public synchronized boolean startIDBroker() {
        DatabaseMap dbMap = this.getDatabaseMap();
        if (dbMap.getIDBroker() != null) {
            return false;
        }
        return dbMap.startIdBroker();
    }

    public IdGenerator getIdGenerator(String type) {
        if (this.databaseMap == null) {
            return null;
        }
        return this.databaseMap.getIdGenerator(type);
    }

    public void addIdGenerator(String type, IdGenerator idGen) {
        this.getDatabaseMap().addIdGenerator(type, idGen);
    }

    public String getSchema() {
        DataSourceFactory dsf = this.getDataSourceFactory();
        if (dsf == null) {
            return null;
        }
        return dsf.getSchema();
    }

    public void setSchema(String schema) {
        this.getDataSourceFactory().setSchema(schema);
    }
}

