/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.intake.validator;

import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fulcrum.intake.IntakeException;
import org.apache.fulcrum.intake.model.Field;
import org.apache.fulcrum.intake.model.Group;
import org.apache.fulcrum.intake.validator.CompareCallback;
import org.apache.fulcrum.intake.validator.ValidationException;

public class FieldReference {
    protected static final Log log = LogFactory.getLog((Class)(class$org$apache$fulcrum$intake$validator$FieldReference == null ? (class$org$apache$fulcrum$intake$validator$FieldReference = FieldReference.class$("org.apache.fulcrum.intake.validator.FieldReference")) : class$org$apache$fulcrum$intake$validator$FieldReference));
    public static final String RANGE_LT = "less-than";
    public static final String RANGE_GT = "greater-than";
    public static final String RANGE_LTE = "less-than-or-equal";
    public static final String RANGE_GTE = "greater-than-or-equal";
    public static final int COMPARE_LT = 1;
    public static final int COMPARE_GT = 2;
    public static final int COMPARE_LTE = 3;
    public static final int COMPARE_GTE = 4;
    private int compare = 0;
    private String fieldName = null;
    private String message = null;
    static /* synthetic */ Class class$org$apache$fulcrum$intake$validator$FieldReference;

    public int getCompare() {
        return this.compare;
    }

    public void setCompare(int compare) {
        this.compare = compare;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public static int getCompareType(String key) {
        int compareType = 0;
        if (key.equals(RANGE_LT)) {
            compareType = 1;
        } else if (key.equals(RANGE_LTE)) {
            compareType = 3;
        } else if (key.equals(RANGE_GT)) {
            compareType = 2;
        } else if (key.equals(RANGE_GTE)) {
            compareType = 4;
        }
        return compareType;
    }

    public static void checkReferences(List fieldReferences, CompareCallback compareCallback, Object value, Group group) throws ValidationException {
        Iterator i = fieldReferences.iterator();
        while (i.hasNext()) {
            boolean comp_true;
            FieldReference ref;
            block6: {
                ref = (FieldReference)i.next();
                comp_true = true;
                try {
                    Field refField = group.get(ref.getFieldName());
                    if (!refField.isSet()) break block6;
                    if (!refField.isValidated()) {
                        refField.validate();
                    }
                    if (!refField.isValid()) break block6;
                    try {
                        comp_true = compareCallback.compareValues(ref.getCompare(), value, refField.getValue());
                    }
                    catch (ClassCastException e) {
                        throw new IntakeException("Type mismatch comparing " + value + " with " + refField.getValue(), e);
                    }
                }
                catch (IntakeException e) {
                    log.error((Object)"Validate operation failed.", (Throwable)e);
                    throw new ValidationException(ref.getMessage());
                }
            }
            if (comp_true) continue;
            throw new ValidationException(ref.getMessage());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

