/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.criteria;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.torque.criteria.SqlEnum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreparedStatementPart
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final StringBuilder sql = new StringBuilder();
    private final List<Object> preparedStatementReplacements = new ArrayList<Object>();

    public PreparedStatementPart() {
    }

    public PreparedStatementPart(String sql, Object ... preparedStatementReplacements) {
        if (!StringUtils.isEmpty((String)sql)) {
            this.sql.append(sql);
        }
        if (preparedStatementReplacements != null) {
            this.preparedStatementReplacements.addAll(Arrays.asList(preparedStatementReplacements));
        }
    }

    public StringBuilder getSql() {
        return this.sql;
    }

    public String getSqlAsString() {
        return this.sql.toString();
    }

    public List<Object> getPreparedStatementReplacements() {
        return this.preparedStatementReplacements;
    }

    public PreparedStatementPart append(PreparedStatementPart toAppend) {
        this.sql.append((CharSequence)toAppend.sql);
        this.preparedStatementReplacements.addAll(toAppend.preparedStatementReplacements);
        return this;
    }

    public PreparedStatementPart append(SqlEnum toAppend) {
        this.sql.append(toAppend);
        return this;
    }

    public int hashCode() {
        HashCodeBuilder hashCodeBuilder = new HashCodeBuilder();
        hashCodeBuilder.append((Object)this.sql);
        hashCodeBuilder.append(this.preparedStatementReplacements);
        return hashCodeBuilder.toHashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PreparedStatementPart other = (PreparedStatementPart)obj;
        EqualsBuilder equalsBuilder = new EqualsBuilder();
        equalsBuilder.append((Object)other.sql, (Object)this.sql);
        equalsBuilder.append(other.preparedStatementReplacements, this.preparedStatementReplacements);
        return equalsBuilder.isEquals();
    }

    public String toString() {
        return this.sql + ", preparedStatementReplacements=" + this.preparedStatementReplacements;
    }
}

