/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.yaafi.framework.context;

import java.io.File;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.DefaultContext;
import org.apache.fulcrum.yaafi.framework.util.Validate;

public class AvalonToYaafiContextMapper {
    private File tempRootDir;
    private DefaultContext defaultContext;
    private ClassLoader classLoader;

    public AvalonToYaafiContextMapper(File tempRootDir, Context context, ClassLoader classLoader) {
        Validate.notNull(tempRootDir, "tempRootDir");
        Validate.notNull(context, "context");
        Validate.notNull(classLoader, "classLoader");
        this.tempRootDir = tempRootDir;
        this.classLoader = classLoader;
        this.defaultContext = new DefaultContext(context);
    }

    public Context mapFrom(Context context, String from) throws ContextException {
        Validate.notNull(context, "context");
        Validate.notEmpty(from, "from");
        if ("phoenix".equals(from)) {
            return this.mapFromPhoenix(context);
        }
        if ("fortress".equals(from)) {
            return this.mapFromFortress(context);
        }
        if ("merlin".equals(from)) {
            return this.mapFromMerlin(context);
        }
        if ("yaafi".equals(from)) {
            return this.mapFromMerlin(context);
        }
        String msg = "Don't know the following container type : " + from;
        throw new IllegalArgumentException(msg);
    }

    private Context mapFromPhoenix(Context context) throws ContextException {
        DefaultContext result = this.getDefaultContext();
        String urnAvalonName = "yaafi";
        String urnAvalonPartition = (String)context.get((Object)"app.name");
        File urnAvalonHome = (File)context.get((Object)"app.home");
        File urnAvalonTemp = this.getTempRootDir();
        result.put((Object)"urn:avalon:name", (Object)urnAvalonName);
        result.put((Object)"urn:avalon:partition", (Object)urnAvalonPartition);
        result.put((Object)"urn:avalon:home", (Object)urnAvalonHome);
        result.put((Object)"urn:avalon:temp", (Object)urnAvalonTemp);
        result.put((Object)"urn:avalon:classloader", (Object)this.getClassLoader());
        result.put((Object)"componentAppRoot", (Object)urnAvalonHome.getAbsolutePath());
        result.put((Object)"component.id", (Object)urnAvalonPartition);
        result.put((Object)"component.logger", (Object)urnAvalonName);
        result.put((Object)"context-root", (Object)urnAvalonHome);
        result.put((Object)"impl.workDir", (Object)urnAvalonTemp);
        return result;
    }

    private Context mapFromFortress(Context context) throws ContextException {
        DefaultContext result = this.getDefaultContext();
        String urnAvalonPartition = (String)context.get((Object)"component.id");
        File urnAvalonHome = (File)context.get((Object)"context-root");
        File urnAvalonTemp = (File)context.get((Object)"impl.workDir");
        result.put((Object)"urn:avalon:name", (Object)"yaafi");
        result.put((Object)"urn:avalon:partition", (Object)urnAvalonPartition);
        result.put((Object)"urn:avalon:home", (Object)urnAvalonHome);
        result.put((Object)"urn:avalon:temp", (Object)urnAvalonTemp);
        result.put((Object)"urn:avalon:classloader", (Object)this.getClassLoader());
        result.put((Object)"componentAppRoot", (Object)urnAvalonHome.getAbsolutePath());
        return result;
    }

    private Context mapFromMerlin(Context context) throws ContextException {
        DefaultContext result = this.getDefaultContext();
        String urnAvalonPartition = (String)context.get((Object)"urn:avalon:partition");
        File urnAvalonHome = (File)context.get((Object)"urn:avalon:home");
        File urnAvalonTemp = (File)context.get((Object)"urn:avalon:temp");
        String urnAvalonName = (String)context.get((Object)"urn:avalon:name");
        result.put((Object)"component.id", (Object)urnAvalonPartition);
        result.put((Object)"component.logger", (Object)urnAvalonName);
        result.put((Object)"context-root", (Object)urnAvalonHome);
        result.put((Object)"impl.workDir", (Object)urnAvalonTemp);
        result.put((Object)"componentAppRoot", (Object)urnAvalonHome.getAbsolutePath());
        return result;
    }

    private ClassLoader getClassLoader() {
        return this.classLoader;
    }

    private DefaultContext getDefaultContext() {
        return this.defaultContext;
    }

    private File getTempRootDir() {
        return this.tempRootDir;
    }
}

