/*
 * Decompiled with CFR 0.152.
 */
package net.sf.uadetector.internal.data.domain;

import java.io.Serializable;
import java.util.Collections;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import net.sf.qualitycheck.Check;
import net.sf.uadetector.ReadableDeviceCategory;
import net.sf.uadetector.internal.data.domain.DevicePattern;
import net.sf.uadetector.internal.data.domain.Identifiable;

@Immutable
public final class Device
implements Identifiable,
Serializable {
    private static final long serialVersionUID = 1L;
    private final int hash;
    @Nonnull
    private final String icon;
    @Nonnull
    private final ReadableDeviceCategory.Category category;
    @Nonnegative
    private final int id;
    @Nonnull
    private final String infoUrl;
    @Nonnull
    private final String name;
    @Nonnull
    private final SortedSet<DevicePattern> patterns;

    private static int buildHashCode(@Nonnull ReadableDeviceCategory.Category category, @Nonnull String icon, @Nonnegative int id, @Nonnull String infoUrl, @Nonnull String name, @Nonnull SortedSet<DevicePattern> patterns) {
        int prime = 31;
        int result = 1;
        result = 31 * result + category.hashCode();
        result = 31 * result + icon.hashCode();
        result = 31 * result + id;
        result = 31 * result + infoUrl.hashCode();
        result = 31 * result + name.hashCode();
        result = 31 * result + patterns.hashCode();
        return result;
    }

    public Device(@Nonnull String name, @Nonnegative int id, @Nonnull ReadableDeviceCategory.Category category, @Nonnull String icon, @Nonnull String infoUrl, @Nonnull SortedSet<DevicePattern> patterns) {
        this.category = category;
        this.icon = (String)Check.notNull((Object)icon, (String)"icon");
        this.id = Check.notNegative((int)id, (String)"id");
        this.infoUrl = (String)Check.notNull((Object)infoUrl, (String)"infoUrl");
        this.name = (String)Check.notNull((Object)name, (String)"name");
        this.patterns = Collections.unmodifiableSortedSet(new TreeSet((SortedSet)Check.notNull(patterns, (String)"patterns")));
        this.hash = Device.buildHashCode(category, icon, id, infoUrl, name, patterns);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Device other = (Device)obj;
        if (this.category != other.category) {
            return false;
        }
        if (!this.icon.equals(other.icon)) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        if (!this.infoUrl.equals(other.infoUrl)) {
            return false;
        }
        if (!this.name.equals(other.name)) {
            return false;
        }
        return this.patterns.equals(other.patterns);
    }

    @Nonnull
    public ReadableDeviceCategory.Category getCategory() {
        return this.category;
    }

    @Nonnull
    public String getIcon() {
        return this.icon;
    }

    @Override
    @Nonnegative
    public int getId() {
        return this.id;
    }

    @Nonnull
    public String getInfoUrl() {
        return this.infoUrl;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public SortedSet<DevicePattern> getPatterns() {
        return this.patterns;
    }

    public int hashCode() {
        return this.hash;
    }

    public String toString() {
        return "Device [icon=" + this.icon + ", id=" + this.id + ", infoUrl=" + this.infoUrl + ", name=" + this.name + ", patterns=" + this.patterns + "]";
    }

    @NotThreadSafe
    public static final class Builder {
        private static final String EMPTY = "";
        @Nonnull
        private String icon = "";
        private int id = Integer.MIN_VALUE;
        @Nonnull
        private String infoUrl = "";
        private String name;
        @Nonnull
        private SortedSet<DevicePattern> patterns = new TreeSet<DevicePattern>();

        public Builder() {
        }

        private Builder(@Nonnull Builder builder) {
            Check.notNull((Object)builder, (String)"builder");
            this.icon = builder.icon;
            this.id = builder.id;
            this.infoUrl = builder.infoUrl;
            this.name = builder.name;
        }

        public Builder(@Nonnull Device device) {
            Check.notNull((Object)device, (String)"device");
            this.icon = (String)Check.notNull((Object)device.getIcon(), (String)"device.getIcon()");
            this.id = Check.notNegative((int)device.getId(), (String)"device.getId()");
            this.infoUrl = (String)Check.notNull((Object)device.getInfoUrl(), (String)"device.getInfoUrl()");
            this.name = (String)Check.notNull((Object)device.getName(), (String)"device.getName()");
            this.patterns = new TreeSet<DevicePattern>((SortedSet)Check.notNull(device.getPatterns(), (String)"device.getPatterns()"));
        }

        @Nonnull
        public Device build() {
            return new Device(this.name, this.id, ReadableDeviceCategory.Category.evaluate(this.name), this.icon, this.infoUrl, this.patterns);
        }

        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        public String getIcon() {
            return this.icon;
        }

        public int getId() {
            return this.id;
        }

        public String getInfoUrl() {
            return this.infoUrl;
        }

        public String getName() {
            return this.name;
        }

        public SortedSet<DevicePattern> getPatterns() {
            return this.patterns;
        }

        @Nonnull
        public Builder setIcon(@Nonnull String icon) {
            this.icon = (String)Check.notNull((Object)icon, (String)"icon");
            return this;
        }

        @Nonnull
        public Builder setId(@Nonnegative int id) {
            this.id = Check.notNegative((int)id, (String)"id");
            return this;
        }

        @Nonnull
        public Builder setId(@Nonnull String id) {
            this.setId(Integer.parseInt((String)Check.notEmpty((CharSequence)id, (String)"id")));
            return this;
        }

        @Nonnull
        public Builder setInfoUrl(@Nonnull String infoUrl) {
            this.infoUrl = (String)Check.notNull((Object)infoUrl, (String)"infoUrl");
            return this;
        }

        @Nonnull
        public Builder setName(@Nonnull String name) {
            this.name = (String)Check.notNull((Object)name, (String)"name");
            return this;
        }

        @Nonnull
        public Builder setPatterns(@Nonnull SortedSet<DevicePattern> patterns) {
            this.patterns = new TreeSet<DevicePattern>((SortedSet)Check.notNull(patterns, (String)"patterns"));
            return this;
        }
    }
}

