/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.pipeline;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.turbine.pipeline.AbstractValve;
import org.apache.turbine.pipeline.PipelineData;
import org.apache.turbine.pipeline.ValveContext;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.TurbineException;

public class DetermineTargetValve
extends AbstractValve {
    private static final Log log = LogFactory.getLog(DetermineTargetValve.class);

    @Override
    public void invoke(PipelineData pipelineData, ValveContext context) throws IOException, TurbineException {
        RunData runData = this.getRunData(pipelineData);
        if (!runData.hasScreen()) {
            String target = runData.getParameters().getString("screen");
            if (target != null) {
                runData.setScreen(target);
                log.debug((Object)"Set screen target from request parameter");
            } else {
                log.debug((Object)"No target screen");
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Screen Target is now: " + runData.getScreen()));
        }
        context.invokeNext(pipelineData);
    }
}

