/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.intake.validator;

import java.util.List;
import org.apache.fulcrum.intake.IntakeException;
import org.apache.fulcrum.intake.model.Field;
import org.apache.fulcrum.intake.model.Group;
import org.apache.fulcrum.intake.validator.CompareCallback;
import org.apache.fulcrum.intake.validator.ValidationException;

public class FieldReference {
    private Comparison compare = null;
    private String fieldName = null;
    private String message = null;

    public Comparison getComparison() {
        return this.compare;
    }

    public void setComparison(Comparison compare) {
        this.compare = compare;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public static Comparison getComparisonType(String key) {
        return Comparison.fromString(key);
    }

    public static <T> void checkReferences(List<FieldReference> fieldReferences, CompareCallback<T> compareCallback, T value, Group group) throws ValidationException {
        for (FieldReference ref : fieldReferences) {
            boolean comp_true = true;
            try {
                Field<?> refField = group.get(ref.getFieldName());
                if (refField.isSet()) {
                    if (!refField.isValidated()) {
                        refField.validate();
                    }
                    if (refField.isValid()) {
                        comp_true = compareCallback.compareValues(ref.getComparison(), value, refField.getValue());
                    }
                }
            }
            catch (IntakeException e) {
                throw new ValidationException(ref.getMessage());
            }
            if (comp_true) continue;
            throw new ValidationException(ref.getMessage());
        }
    }

    public static enum Comparison {
        LT("less-than"),
        GT("greater-than"),
        LTE("less-than-or-equal"),
        GTE("greater-than-or-equal");

        private final String text;

        private Comparison(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }

        public static Comparison fromString(String string) {
            if (string != null) {
                for (Comparison c : Comparison.values()) {
                    if (!string.equals(c.text)) continue;
                    return c;
                }
            }
            return null;
        }
    }
}

