/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.pool;

import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.fulcrum.factory.FactoryException;
import org.apache.fulcrum.factory.FactoryService;
import org.apache.fulcrum.pool.ArrayCtorRecyclable;
import org.apache.fulcrum.pool.PoolBuffer;
import org.apache.fulcrum.pool.PoolException;
import org.apache.fulcrum.pool.PoolService;

public class DefaultPoolService
extends AbstractLogEnabled
implements PoolService,
Serviceable,
Disposable,
Initializable,
Configurable {
    public static final String POOL_CAPACITY = "capacity";
    private int poolCapacity = 128;
    private HashMap<String, PoolBuffer> poolRepository = new HashMap();
    private Map<String, Integer> capacityMap;
    private FactoryService factoryService;
    private ServiceManager manager;

    public Object getInstance(String className) throws PoolException {
        try {
            Object instance = this.pollInstance(className, null, null);
            return instance == null ? this.getFactory().getInstance(className) : instance;
        }
        catch (FactoryException fe) {
            throw new PoolException((Exception)((Object)fe));
        }
    }

    public Object getInstance(String className, ClassLoader loader) throws PoolException {
        try {
            Object instance = this.pollInstance(className, null, null);
            return instance == null ? this.getFactory().getInstance(className, loader) : instance;
        }
        catch (FactoryException fe) {
            throw new PoolException((Exception)((Object)fe));
        }
    }

    public Object getInstance(String className, Object[] params, String[] signature) throws PoolException {
        try {
            Object instance = this.pollInstance(className, params, signature);
            return instance == null ? this.getFactory().getInstance(className, params, signature) : instance;
        }
        catch (FactoryException fe) {
            throw new PoolException((Exception)((Object)fe));
        }
    }

    public Object getInstance(String className, ClassLoader loader, Object[] params, String[] signature) throws PoolException {
        try {
            Object instance = this.pollInstance(className, params, signature);
            return instance == null ? this.getFactory().getInstance(className, loader, params, signature) : instance;
        }
        catch (FactoryException fe) {
            throw new PoolException((Exception)((Object)fe));
        }
    }

    public boolean isLoaderSupported(String className) throws FactoryException {
        return this.getFactory().isLoaderSupported(className);
    }

    @Override
    public Object getInstance(Class clazz) throws PoolException {
        try {
            Object instance = this.pollInstance(clazz.getName(), null, null);
            return instance == null ? this.factoryService.getInstance(clazz) : instance;
        }
        catch (FactoryException fe) {
            throw new PoolException((Exception)((Object)fe));
        }
    }

    @Override
    public Object getInstance(Class clazz, Object[] params, String[] signature) throws PoolException {
        try {
            Object instance = this.pollInstance(clazz.getName(), params, signature);
            return instance == null ? this.getFactory().getInstance(clazz.toString(), params, signature) : instance;
        }
        catch (FactoryException fe) {
            throw new PoolException((Exception)((Object)fe));
        }
    }

    @Override
    public boolean putInstance(Object instance) {
        if (instance != null) {
            HashMap repository = this.poolRepository;
            String className = instance.getClass().getName();
            PoolBuffer pool = repository.get(className);
            if (pool == null) {
                pool = new PoolBuffer(this.getCapacity(className));
                repository = (HashMap)repository.clone();
                repository.put(className, pool);
                this.poolRepository = repository;
                if (instance instanceof ArrayCtorRecyclable) {
                    pool.setArrayCtorRecyclable(true);
                }
            }
            return pool.offer(instance);
        }
        return false;
    }

    @Override
    public int getCapacity(String className) {
        PoolBuffer pool = this.poolRepository.get(className);
        if (pool == null) {
            Integer cap;
            int capacity = this.poolCapacity;
            if (this.capacityMap != null && (cap = this.capacityMap.get(className)) != null) {
                capacity = cap;
            }
            return capacity;
        }
        return pool.capacity();
    }

    @Override
    public void setCapacity(String className, int capacity) {
        HashMap<String, PoolBuffer> repository = this.poolRepository;
        repository = repository != null ? (HashMap)repository.clone() : new HashMap();
        repository.put(className, new PoolBuffer(capacity));
        this.poolRepository = repository;
    }

    @Override
    public int getSize(String className) {
        PoolBuffer pool = this.poolRepository.get(className);
        return pool != null ? pool.size() : 0;
    }

    @Override
    public void clearPool(String className) {
        HashMap repository = this.poolRepository;
        if (repository.get(className) != null) {
            repository = (HashMap)repository.clone();
            repository.remove(className);
            this.poolRepository = repository;
        }
    }

    @Override
    public void clearPool() {
        this.poolRepository = new HashMap();
    }

    private Object pollInstance(String className, Object[] params, String[] signature) throws PoolException {
        PoolBuffer pool = this.poolRepository.get(className);
        return pool != null ? pool.poll(params, signature, this.factoryService) : null;
    }

    protected FactoryService getFactory() {
        return this.factoryService;
    }

    public void configure(Configuration conf) {
        Configuration capacities = conf.getChild(POOL_CAPACITY, false);
        if (capacities != null) {
            Configuration defaultConf = capacities.getChild("default");
            int capacity = defaultConf.getValueAsInteger(128);
            if (capacity <= 0) {
                throw new IllegalArgumentException("Capacity must be >0");
            }
            this.poolCapacity = capacity;
            Configuration[] nameVal = capacities.getChildren();
            for (int i = 0; i < nameVal.length; ++i) {
                String key = nameVal[i].getName();
                if ("default".equals(key)) continue;
                capacity = nameVal[i].getValueAsInteger(this.poolCapacity);
                if (capacity < 0) {
                    capacity = this.poolCapacity;
                }
                if (this.capacityMap == null) {
                    this.capacityMap = new HashMap<String, Integer>();
                }
                this.capacityMap.put(key, capacity);
            }
        }
    }

    public void service(ServiceManager manager) {
        this.manager = manager;
    }

    public void initialize() throws Exception {
        try {
            this.factoryService = (FactoryService)this.manager.lookup(FactoryService.ROLE);
        }
        catch (Exception e) {
            throw new Exception("DefaultPoolService.initialize: Failed to get a Factory object", e);
        }
    }

    public void dispose() {
        if (this.factoryService != null) {
            this.manager.release((Object)this.factoryService);
        }
        this.factoryService = null;
        this.manager = null;
    }
}

