/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.yaafi.framework.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.logger.NullLogger;

public class InputStreamLocator {
    private File rootDir;
    private Logger logger;

    public InputStreamLocator() {
        this.rootDir = new File(new File("").getAbsolutePath());
        this.logger = new NullLogger();
    }

    public InputStreamLocator(File rootDir) {
        this(rootDir, (Logger)new NullLogger());
    }

    public InputStreamLocator(File rootDir, Logger logger) {
        this.rootDir = rootDir;
        this.logger = logger;
    }

    public InputStream locate(String location) throws IOException {
        if (location == null || location.length() == 0) {
            return null;
        }
        String baseName = null;
        File file = null;
        InputStream is = null;
        if (is == null) {
            file = new File(this.rootDir, location);
            this.logger.debug("Looking for " + location + " in the root directory");
            if (file.exists()) {
                is = new FileInputStream(file);
                this.logger.debug("Found " + location + " as " + file.getAbsolutePath());
            }
        }
        if (is == null) {
            file = new File(location);
            this.logger.debug("Looking for " + location + " as absolute file location");
            if (file.isAbsolute() && file.exists()) {
                is = new FileInputStream(file);
                this.logger.debug("Found " + location + " as " + file.getAbsolutePath());
            }
        }
        if (is == null && location.startsWith("/")) {
            this.logger.debug("Looking for " + location + " using the class loader");
            is = this.getClass().getResourceAsStream(location);
            if (is != null) {
                this.logger.debug("Successfully located " + location);
            }
        }
        if (is == null && !location.startsWith("/")) {
            baseName = '/' + new File(location).getName();
            this.logger.debug("Looking for " + baseName + " using the class loader");
            is = this.getClass().getResourceAsStream(baseName);
            if (is != null) {
                this.logger.debug("Successfully located " + baseName);
            }
        }
        if (is == null) {
            this.logger.info("Unable to find any resource with the name '" + location + "'");
        }
        return is;
    }

    protected File getRootDir() {
        return this.rootDir;
    }
}

