/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.security;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.configuration2.Configuration;
import org.apache.fulcrum.factory.FactoryService;
import org.apache.fulcrum.security.acl.AccessControlList;
import org.apache.fulcrum.security.model.turbine.TurbineUserManager;
import org.apache.fulcrum.security.model.turbine.entity.TurbineUser;
import org.apache.fulcrum.security.util.DataBackendException;
import org.apache.fulcrum.security.util.EntityExistsException;
import org.apache.fulcrum.security.util.PasswordMismatchException;
import org.apache.fulcrum.security.util.UnknownEntityException;
import org.apache.fulcrum.security.util.UserSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.turbine.om.security.User;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.ServiceManager;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.security.SecurityService;
import org.apache.turbine.services.security.UserManager;
import org.apache.turbine.util.ObjectUtils;

public class DefaultUserManager
implements UserManager {
    private TurbineUserManager umDelegate = null;
    private FactoryService factoryService = null;
    private String userWrapperClass;
    private static final Logger log = LogManager.getLogger(DefaultUserManager.class);

    protected <U extends User> U wrap(TurbineUser user) {
        U u = this.getUserWrapper(user);
        return u;
    }

    public <U extends User> U getUserWrapper(TurbineUser user) {
        try {
            Object[] params = new Object[]{user};
            String[] signature = new String[]{TurbineUser.class.getName()};
            return (U)((User)this.factoryService.getInstance(this.getUserWrapperClass(), params, signature));
        }
        catch (Exception e) {
            log.error("after init/late instantiation exception", (Throwable)e);
            return null;
        }
    }

    public String getUserWrapperClass() {
        return this.userWrapperClass;
    }

    public void setUserWrapperClass(String userWrapperClass2) {
        this.userWrapperClass = userWrapperClass2;
    }

    @Override
    public void init(Configuration conf) throws InitializationException {
        ServiceManager manager = TurbineServices.getInstance();
        this.umDelegate = (TurbineUserManager)manager.getService(TurbineUserManager.ROLE);
        String userWrapperClass = conf.getString("wrapper.class", SecurityService.USER_WRAPPER_DEFAULT);
        try {
            this.factoryService = (FactoryService)manager.getService(FactoryService.ROLE);
            TurbineUser turbineUser = (TurbineUser)this.umDelegate.getUserInstance();
            Object[] params = new Object[]{turbineUser};
            String[] signature = new String[]{TurbineUser.class.getName()};
            this.factoryService.getInstance(userWrapperClass, params, signature);
            this.setUserWrapperClass(userWrapperClass);
        }
        catch (Exception e) {
            throw new InitializationException("Failed to instantiate user wrapper class", e);
        }
    }

    @Override
    public boolean accountExists(User user) throws DataBackendException {
        if (user == null) {
            return false;
        }
        return this.umDelegate.checkExists((org.apache.fulcrum.security.entity.User)user.getUserDelegate());
    }

    @Override
    public boolean accountExists(String userName) throws DataBackendException {
        return this.umDelegate.checkExists(userName);
    }

    @Override
    public <U extends User> U retrieve(String username) throws UnknownEntityException, DataBackendException {
        TurbineUser u = (TurbineUser)this.umDelegate.getUser(username);
        return this.wrap(u);
    }

    @Override
    public List<? extends User> retrieveList(Object criteria) throws DataBackendException {
        UserSet uset = this.umDelegate.getAllUsers();
        ArrayList userList = new ArrayList();
        for (org.apache.fulcrum.security.entity.User u : uset) {
            TurbineUser tu = (TurbineUser)u;
            userList.add(this.wrap(tu));
        }
        return userList;
    }

    @Override
    public <U extends User> U retrieve(String username, String password) throws PasswordMismatchException, UnknownEntityException, DataBackendException {
        TurbineUser u = (TurbineUser)this.umDelegate.getUser(username, password);
        return this.wrap(u);
    }

    @Override
    public void store(User user) throws UnknownEntityException, DataBackendException {
        if (user == null) {
            throw new UnknownEntityException("user is null");
        }
        try {
            user.setObjectdata(ObjectUtils.serializeMap(user.getPermStorage()));
        }
        catch (Exception e) {
            throw new DataBackendException("Could not serialize permanent storage", (Throwable)e);
        }
        this.umDelegate.saveUser((org.apache.fulcrum.security.entity.User)user.getUserDelegate());
    }

    @Override
    public void saveOnSessionUnbind(User user) throws UnknownEntityException, DataBackendException {
        this.store(user);
    }

    @Override
    public void authenticate(User user, String password) throws PasswordMismatchException, UnknownEntityException, DataBackendException {
        this.umDelegate.authenticate((org.apache.fulcrum.security.entity.User)user, password);
    }

    @Override
    public void createAccount(User user, String initialPassword) throws UnknownEntityException, EntityExistsException, DataBackendException {
        if (user == null) {
            throw new UnknownEntityException("user is null");
        }
        this.umDelegate.addUser((org.apache.fulcrum.security.entity.User)user.getUserDelegate(), initialPassword);
    }

    @Override
    public void removeAccount(User user) throws UnknownEntityException, DataBackendException {
        if (user == null) {
            throw new UnknownEntityException("user is null");
        }
        this.umDelegate.removeUser((org.apache.fulcrum.security.entity.User)user.getUserDelegate());
    }

    @Override
    public void changePassword(User user, String oldPassword, String newPassword) throws PasswordMismatchException, UnknownEntityException, DataBackendException {
        if (user == null) {
            throw new UnknownEntityException("user is null");
        }
        this.umDelegate.changePassword((org.apache.fulcrum.security.entity.User)user.getUserDelegate(), oldPassword, newPassword);
    }

    @Override
    public void forcePassword(User user, String password) throws UnknownEntityException, DataBackendException {
        if (user == null) {
            throw new UnknownEntityException("user is null");
        }
        this.umDelegate.forcePassword((org.apache.fulcrum.security.entity.User)user.getUserDelegate(), password);
    }

    @Override
    public <U extends User> U getAnonymousUser() throws UnknownEntityException {
        TurbineUser u = (TurbineUser)this.umDelegate.getAnonymousUser();
        return this.wrap(u);
    }

    @Override
    public boolean isAnonymousUser(User u) {
        return this.umDelegate.isAnonymousUser((org.apache.fulcrum.security.entity.User)u);
    }

    @Override
    public <U extends User> U getUserInstance() throws DataBackendException {
        TurbineUser u = (TurbineUser)this.umDelegate.getUserInstance();
        return this.wrap(u);
    }

    @Override
    public <U extends User> U getUserInstance(String userName) throws DataBackendException {
        TurbineUser u = (TurbineUser)this.umDelegate.getUserInstance(userName);
        return this.wrap(u);
    }

    @Override
    public <A extends AccessControlList> A getACL(User user) throws UnknownEntityException {
        if (user == null) {
            throw new UnknownEntityException("user is null");
        }
        return (A)this.umDelegate.getACL((org.apache.fulcrum.security.entity.User)user.getUserDelegate());
    }
}

