/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.util;

import java.sql.SQLException;
import org.apache.commons.lang.StringUtils;
import org.apache.torque.ConstraintViolationException;
import org.apache.torque.DeadlockException;
import org.apache.torque.TorqueException;
import org.apache.torque.util.ExceptionMapper;

public class ExceptionMapperImpl
extends ExceptionMapper {
    public TorqueException toTorqueException(SQLException sqlException) {
        if (StringUtils.startsWith((String)sqlException.getSQLState(), (String)"23")) {
            return new ConstraintViolationException(sqlException);
        }
        if (StringUtils.equals((String)sqlException.getSQLState(), (String)"40001")) {
            return new DeadlockException(sqlException);
        }
        if (StringUtils.equals((String)sqlException.getSQLState(), (String)"40P01")) {
            return new DeadlockException(sqlException);
        }
        if (StringUtils.equals((String)sqlException.getSQLState(), (String)"61000") && sqlException.getErrorCode() == 60) {
            return new DeadlockException(sqlException);
        }
        return new TorqueException(sqlException);
    }
}

