/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util.velocity;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.HtmlEmail;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.turbine.Turbine;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.velocity.VelocityService;
import org.apache.velocity.context.Context;

public class VelocityHtmlEmail
extends HtmlEmail {
    private static final Logger log = LogManager.getLogger(VelocityHtmlEmail.class);
    private String htmlTemplate = null;
    private String textTemplate = null;
    private Context context = null;
    private Hashtable<String, String> embmap = null;
    private String mailServer;

    public VelocityHtmlEmail() {
    }

    public VelocityHtmlEmail(Context context) {
        this();
        this.context = context;
        this.embmap = new Hashtable();
    }

    public VelocityHtmlEmail setHtmlTemplate(String template) {
        this.htmlTemplate = template;
        return this;
    }

    public VelocityHtmlEmail setTextTemplate(String template) {
        this.textTemplate = template;
        return this;
    }

    public void setMailServer(String serverAddress) {
        this.mailServer = serverAddress;
    }

    public String getMailServer() {
        return StringUtils.isNotEmpty((CharSequence)this.mailServer) ? this.mailServer : Turbine.getConfiguration().getString("mail.server", "localhost");
    }

    public String send() throws EmailException {
        this.context.put("mail", (Object)this);
        try {
            VelocityService velocityService = (VelocityService)TurbineServices.getInstance().getService("VelocityService");
            if (this.htmlTemplate != null) {
                this.setHtmlMsg(velocityService.handleRequest(this.context, this.htmlTemplate));
            }
            if (this.textTemplate != null) {
                this.setTextMsg(velocityService.handleRequest(this.context, this.textTemplate));
            }
        }
        catch (Exception e) {
            throw new EmailException("Cannot parse velocity template", (Throwable)e);
        }
        this.setHostName(this.getMailServer());
        return super.send();
    }

    public String embed(String surl, String name) {
        String cid = "";
        try {
            URL url = new URL(surl);
            cid = super.embed(url, name);
            this.embmap.put(name, cid);
        }
        catch (MalformedURLException | EmailException e) {
            log.error("cannot embed {}", (Object)surl, (Object)e);
        }
        return cid;
    }

    public String getCid(String filename) {
        String cid = this.embmap.get(filename);
        return "cid:" + cid;
    }
}

