/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

#include <stdio.h>
#include <tvm_runtime.h>
#include <tvmgen_detection.h>

#include "uart_stdout.h"

// Header files generated by convert_image.py
#include "inputs.h"
#include "outputs.h"

int main(int argc, char** argv) {
  UartStdOutInit();
  printf("Starting Demo\n");

  printf("Running detection inference\n");
  struct tvmgen_detection_outputs detection_outputs = {
      .MobilenetV1_Predictions_Reshape_1 = output,
  };
  struct tvmgen_detection_inputs detection_inputs = {
      .input = input,
  };

  tvmgen_detection_run(&detection_inputs, &detection_outputs);

  // Report result
  if (output[1] > output[0]) {
    printf("Person detected.\n");
  } else {
    printf("No person detected.\n");
  }

  // The FVP will shut down when it receives "EXITTHESIM" on the UART
  printf("EXITTHESIM\n");
  while (1 == 1)
    ;
  return 0;
}
