/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.action;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.action.AbstractRutaAction;
import org.apache.uima.ruta.expression.bool.BooleanExpression;
import org.apache.uima.ruta.expression.number.NumberExpression;
import org.apache.uima.ruta.expression.resource.WordListExpression;
import org.apache.uima.ruta.expression.string.StringExpression;
import org.apache.uima.ruta.expression.type.TypeExpression;
import org.apache.uima.ruta.resource.RutaWordList;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.rule.RuleMatch;
import org.apache.uima.ruta.visitor.InferenceCrowd;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrieAction
extends AbstractRutaAction {
    private final WordListExpression list;
    private final Map<StringExpression, TypeExpression> map;
    private final BooleanExpression ignoreCase;
    private final NumberExpression ignoreLength;
    private final BooleanExpression edit;
    private final NumberExpression distance;
    private final StringExpression ignoreChar;

    public TrieAction(WordListExpression list, Map<StringExpression, TypeExpression> map, BooleanExpression ignoreCase, NumberExpression ignoreLength, BooleanExpression edit, NumberExpression distance, StringExpression ignoreChar) {
        this.list = list;
        this.map = map;
        this.ignoreCase = ignoreCase;
        this.ignoreLength = ignoreLength;
        this.edit = edit;
        this.distance = distance;
        this.ignoreChar = ignoreChar;
    }

    @Override
    public void execute(RuleMatch match, RuleElement element, RutaStream stream, InferenceCrowd crowd) {
        HashMap<String, Type> typeMap = new HashMap<String, Type>();
        for (StringExpression eachKey : this.map.keySet()) {
            String stringValue = eachKey.getStringValue(element.getParent());
            TypeExpression typeExpression = this.map.get(eachKey);
            if (typeExpression == null) continue;
            Type typeValue = typeExpression.getType(element.getParent());
            typeMap.put(stringValue, typeValue);
        }
        boolean ignoreCaseValue = this.ignoreCase.getBooleanValue(element.getParent());
        int ignoreLengthValue = this.ignoreLength.getIntegerValue(element.getParent());
        boolean editValue = this.edit.getBooleanValue(element.getParent());
        double distanceValue = this.distance.getDoubleValue(element.getParent());
        String ignoreCharValue = this.ignoreChar.getStringValue(element.getParent());
        RutaWordList wl = this.list.getList(element.getParent());
        Collection<AnnotationFS> found = wl.find(stream, typeMap, ignoreCaseValue, ignoreLengthValue, editValue, distanceValue, ignoreCharValue);
        if (found != null) {
            for (AnnotationFS annotation : found) {
                stream.addAnnotation(annotation, match);
                stream.getCas().addFsToIndexes((FeatureStructure)annotation);
            }
        }
    }

    public WordListExpression getList() {
        return this.list;
    }

    public Map<StringExpression, TypeExpression> getMap() {
        return this.map;
    }

    public BooleanExpression getIgnoreCase() {
        return this.ignoreCase;
    }

    public NumberExpression getIgnoreLength() {
        return this.ignoreLength;
    }

    public BooleanExpression getEdit() {
        return this.edit;
    }

    public NumberExpression getDistance() {
        return this.distance;
    }

    public StringExpression getIgnoreChar() {
        return this.ignoreChar;
    }
}

