/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.condition;

import java.util.List;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.condition.TerminalRutaCondition;
import org.apache.uima.ruta.expression.type.TypeExpression;
import org.apache.uima.ruta.rule.EvaluatedCondition;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.type.RutaBasic;
import org.apache.uima.ruta.visitor.InferenceCrowd;

public class VoteCondition
extends TerminalRutaCondition {
    private final TypeExpression type1;
    private final TypeExpression type2;

    public VoteCondition(TypeExpression type1, TypeExpression type2) {
        this.type1 = type1;
        this.type2 = type2;
    }

    public EvaluatedCondition eval(AnnotationFS annotation, RuleElement element, RutaStream stream, InferenceCrowd crowd) {
        int count1 = 0;
        int count2 = 0;
        int totalCount = 0;
        if (annotation != null) {
            List<RutaBasic> annotations = stream.getBasicsInWindow(annotation);
            Type t1 = this.type1.getType(element.getParent());
            Type t2 = this.type2.getType(element.getParent());
            for (RutaBasic each : annotations) {
                ++totalCount;
                if (each.beginsWith(t1)) {
                    ++count1;
                }
                if (!each.beginsWith(t2)) continue;
                ++count2;
            }
        }
        return new EvaluatedCondition(this, count1 > count2);
    }

    public TypeExpression getType1() {
        return this.type1;
    }

    public TypeExpression getType2() {
        return this.type2;
    }
}

