/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.textruler.core;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.uima.UIMAFramework;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.impl.XmiCasDeserializer;
import org.apache.uima.cas.impl.XmiCasSerializer;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.metadata.TypeDescription;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.ruta.textruler.TextRulerPlugin;
import org.apache.uima.ruta.textruler.core.GlobalCASSource;
import org.apache.uima.ruta.textruler.core.TextRulerAnnotation;
import org.apache.uima.ruta.textruler.core.TextRulerExample;
import org.apache.uima.ruta.textruler.core.TextRulerExampleDocument;
import org.apache.uima.ruta.textruler.core.TextRulerTarget;
import org.apache.uima.util.XMLInputSource;
import org.apache.uima.util.XMLSerializer;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.osgi.framework.Bundle;

public class TextRulerToolkit {
    public static final boolean LOGGING_ENABLED = true;
    public static final boolean DEBUG = false;
    public static final String RUTA_ALL_TYPE_NAME = "org.apache.uima.ruta.type.ALL";
    public static final String RUTA_ANY_TYPE_NAME = "org.apache.uima.ruta.type.ANY";
    public static final String RUTA_WORD_TYPE_NAME = "org.apache.uima.ruta.type.W";
    public static final String RUTA_BREAK_TYPE_NAME = "org.apache.uima.ruta.type.BREAK";
    public static final String RUTA_SPACE_TYPE_NAME = "org.apache.uima.ruta.type.SPACE";
    public static final String RUTA_NUM_TYPE_NAME = "org.apache.uima.ruta.type.NUM";
    public static final String RUTA_MARKUP_TYPE_NAME = "org.apache.uima.ruta.type.MARKUP";
    public static final String RUTA_SPECIAL_TYPE_NAME = "org.apache.uima.ruta.type.SPECIAL";
    public static final String RUTA_NBSP_TYPE_NAME = "org.apache.uima.ruta.type.NBSP";
    public static final String LEFT_BOUNDARY_EXTENSION = "START";
    public static final String RIGHT_BOUNDARY_EXTENSION = "END";

    public static void log(String str) {
        System.out.println(str);
    }

    public static void logIfDebug(String str) {
    }

    public static void logIf(boolean condition, String str) {
        if (condition) {
            System.out.println(str);
        }
    }

    public static URL getResourceURL(String name) {
        return FileLocator.find((Bundle)TextRulerPlugin.getDefault().getBundle(), (IPath)new Path(name), null);
    }

    public static AnalysisEngineDescription getAnalysisEngineDescription(String descFile) {
        AnalysisEngineDescription result = null;
        try {
            XMLInputSource in = new XMLInputSource(descFile);
            result = (AnalysisEngineDescription)UIMAFramework.getXMLParser().parseResourceSpecifier(in);
        }
        catch (Exception e) {
            TextRulerPlugin.error(e);
            result = null;
        }
        return result;
    }

    public static AnalysisEngineDescription getAnalysisEngineDescription(URL fileURL) {
        AnalysisEngineDescription result = null;
        try {
            XMLInputSource in = new XMLInputSource(fileURL);
            result = (AnalysisEngineDescription)UIMAFramework.getXMLParser().parseResourceSpecifier(in);
        }
        catch (Exception e) {
            TextRulerPlugin.error(e);
            result = null;
        }
        return result;
    }

    public static AnalysisEngine loadAnalysisEngine(AnalysisEngineDescription desc) {
        AnalysisEngine result = null;
        try {
            result = UIMAFramework.produceAnalysisEngine((ResourceSpecifier)desc);
        }
        catch (Exception e) {
            TextRulerPlugin.error(e);
            result = null;
        }
        return result;
    }

    public static void addBoundaryTypes(AnalysisEngineDescription description, String[] slotNames) {
        ArrayList<String> list = new ArrayList<String>();
        for (String eachSlot : slotNames) {
            list.add(eachSlot + LEFT_BOUNDARY_EXTENSION);
            list.add(eachSlot + RIGHT_BOUNDARY_EXTENSION);
        }
        TypeSystemDescription typeSystem = description.getAnalysisEngineMetaData().getTypeSystem();
        for (String string : list) {
            TypeDescription type = typeSystem.getType(string);
            if (type != null) continue;
            typeSystem.addType(string, "", "uima.tcas.Annotation");
        }
    }

    public static CAS readCASfromXMIFile(String filename, AnalysisEngine ae, CAS reuseCAS) {
        return TextRulerToolkit.readCASfromXMIFile(new File(filename), ae, reuseCAS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CAS readCASfromXMIFile(File file, AnalysisEngine ae, CAS reuseCAS) {
        FileInputStream inputStream = null;
        try {
            CAS resultCas;
            inputStream = new FileInputStream(file);
            if (reuseCAS != null) {
                reuseCAS.reset();
                resultCas = reuseCAS;
            } else {
                resultCas = GlobalCASSource.allocCAS(ae);
            }
            XmiCasDeserializer.deserialize((InputStream)inputStream, (CAS)resultCas, (boolean)true);
            CAS cAS = resultCas;
            return cAS;
        }
        catch (Exception e) {
            TextRulerPlugin.error(e);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception e) {
                TextRulerPlugin.error(e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeCAStoXMIFile(CAS aCas, String filename) {
        File newFile = new File(filename);
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(newFile);
            XmiCasSerializer ser = new XmiCasSerializer(aCas.getTypeSystem());
            XMLSerializer xmlSer = new XMLSerializer((OutputStream)out, false);
            ser.serialize(aCas, xmlSer.getContentHandler());
        }
        catch (Exception e) {
            TextRulerPlugin.error(e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e) {
                    TextRulerPlugin.error(e);
                }
            }
        }
    }

    public static List<AnnotationFS> extractAnnotationsForSlotName(CAS aCas, String slotName) {
        ArrayList<AnnotationFS> result = new ArrayList<AnnotationFS>();
        TypeSystem ts = aCas.getTypeSystem();
        Type slotType = ts.getType(slotName);
        FSIterator it = aCas.getAnnotationIndex(slotType).iterator(true);
        if (!it.isValid()) {
            // empty if block
        }
        while (it.isValid()) {
            AnnotationFS previous;
            AnnotationFS fs = (AnnotationFS)it.get();
            AnnotationFS annotationFS = previous = result.size() > 0 ? (AnnotationFS)result.get(result.size() - 1) : null;
            if (previous == null || previous.getBegin() != fs.getBegin() || previous.getEnd() != fs.getEnd()) {
                result.add(fs);
            } else {
                TextRulerToolkit.logIfDebug("******** QUANTIFIER BUG ?? Multiple annotation: " + fs.getType().getName());
            }
            it.moveToNext();
        }
        return result;
    }

    private static List<AnnotationFS> getAnnotationWithinBounds(CAS aCas, int posStart, int posEnd, Set<String> filterSet, Type rootType) {
        ArrayList<AnnotationFS> result = new ArrayList<AnnotationFS>();
        TypeSystem ts = aCas.getTypeSystem();
        try {
            AnnotationFS boundaryAnnotation = aCas.createAnnotation(ts.getType("uima.tcas.Annotation"), posStart > 0 ? posStart - 1 : 0, posEnd);
            FSIterator it = aCas.getAnnotationIndex().subiterator(boundaryAnnotation, true, true);
            while (it.isValid()) {
                AnnotationFS fs = (AnnotationFS)it.get();
                if (fs.getBegin() < posStart || fs.getEnd() > posEnd) {
                    it.moveToNext();
                    continue;
                }
                if (rootType != null && !ts.subsumes(rootType, fs.getType())) {
                    it.moveToNext();
                    continue;
                }
                if (filterSet == null || !filterSet.contains(fs.getType().getName())) {
                    result.add(fs);
                }
                it.moveToNext();
            }
        }
        catch (Exception e) {
            TextRulerPlugin.error(e);
        }
        return result;
    }

    public static List<AnnotationFS> getAnnotationsBeforePosition(CAS aCas, int position, int maxCount, Set<String> filterSet, Type rootType) {
        List<AnnotationFS> result = TextRulerToolkit.getAnnotationWithinBounds(aCas, 0, position, filterSet, rootType);
        if (maxCount > 0) {
            while (result.size() > maxCount) {
                result.remove(0);
            }
        }
        return result;
    }

    public static List<AnnotationFS> getAnnotationsAfterPosition(CAS aCas, int position, int maxCount, Set<String> filterSet, Type rootType) {
        int maxPos = aCas.getDocumentText().length() - 1;
        List<AnnotationFS> result = TextRulerToolkit.getAnnotationWithinBounds(aCas, position, maxPos, filterSet, rootType);
        if (maxCount > 0) {
            while (result.size() > maxCount) {
                result.remove(result.size() - 1);
            }
        }
        return result;
    }

    public static List<AnnotationFS> getAnnotationsWithinBounds(CAS aCas, int start, int end, Set<String> filterSet, Type rootType) {
        return TextRulerToolkit.getAnnotationWithinBounds(aCas, start, end, filterSet, rootType);
    }

    public static List<AnnotationFS> getOtherAnnotationsOverToken(CAS aCas, AnnotationFS tokenAnnotation, Set<String> filterSet) {
        AnnotationFS fs;
        ArrayList<AnnotationFS> result = new ArrayList<AnnotationFS>();
        FSIterator it = aCas.getAnnotationIndex().iterator();
        Type tokenType = tokenAnnotation.getType();
        FSIterator leftIt = null;
        FSIterator rightIt = null;
        TypeSystem ts = aCas.getTypeSystem();
        Type rootType = ts.getType(RUTA_ALL_TYPE_NAME);
        HashSet<String> allFilters = new HashSet<String>();
        allFilters.add("uima.tcas.DocumentAnnotation");
        allFilters.add("org.apache.uima.ruta.type.RutaBasic");
        if (filterSet != null) {
            allFilters.addAll(filterSet);
        }
        while (it.isValid()) {
            fs = (AnnotationFS)it.get();
            if (fs.getBegin() == tokenAnnotation.getBegin() && fs.getEnd() == tokenAnnotation.getEnd() && fs.getType().equals(tokenType)) {
                leftIt = it;
                rightIt = it.copy();
                break;
            }
            it.moveToNext();
        }
        if (leftIt == null) {
            return null;
        }
        if (leftIt.isValid()) {
            leftIt.moveToPrevious();
        }
        while (leftIt.isValid() && (fs = (AnnotationFS)leftIt.get()).getEnd() > tokenAnnotation.getBegin()) {
            if (fs.getBegin() <= tokenAnnotation.getBegin() && fs.getEnd() >= tokenAnnotation.getEnd() && !allFilters.contains(fs.getType().getName()) && !ts.subsumes(rootType, fs.getType())) {
                result.add(fs);
            }
            leftIt.moveToPrevious();
        }
        if (rightIt.isValid()) {
            rightIt.moveToNext();
        }
        while (rightIt.isValid() && (fs = (AnnotationFS)rightIt.get()).getBegin() < tokenAnnotation.getEnd()) {
            if (fs.getBegin() <= tokenAnnotation.getBegin() && fs.getEnd() >= tokenAnnotation.getEnd() && !allFilters.contains(fs.getType().getName()) && !ts.subsumes(rootType, fs.getType())) {
                result.add(fs);
            }
            rightIt.moveToNext();
        }
        return result;
    }

    public static synchronized Set<String> getFilterSetWithSlotNames(String[] slotNames, Set<String> otherFilters) {
        HashSet<String> result = new HashSet<String>(otherFilters);
        result.add("org.apache.uima.ruta.type.RutaBasic");
        if (slotNames != null) {
            for (String s : slotNames) {
                result.add(s);
            }
        }
        return result;
    }

    public static synchronized Set<String> getFilterSetWithSlotName(String slotName, Set<String> otherFilters) {
        String[] sn = new String[]{slotName};
        return TextRulerToolkit.getFilterSetWithSlotNames(sn, otherFilters);
    }

    public static synchronized String getStandardFilterSetString() {
        String str = "";
        for (String s : TextRulerToolkit.getStandardFilterSet(null)) {
            if (str.length() == 0) {
                str = str + s;
                continue;
            }
            str = str + ", " + s;
        }
        return str;
    }

    public static synchronized Set<String> getStandardFilterSet(String[] slotNames) {
        HashSet<String> filterSet = new HashSet<String>();
        if (slotNames != null) {
            for (String s : slotNames) {
                filterSet.add(s);
            }
        }
        filterSet.add(RUTA_SPACE_TYPE_NAME);
        filterSet.add(RUTA_BREAK_TYPE_NAME);
        filterSet.add(RUTA_MARKUP_TYPE_NAME);
        filterSet.add(RUTA_NBSP_TYPE_NAME);
        return filterSet;
    }

    public static synchronized Set<String> getStandardFeatureFilterSet() {
        HashSet<String> filterSet = new HashSet<String>();
        filterSet.add("uima.cas.AnnotationBase:sofa");
        filterSet.add("uima.tcas.Annotation:begin");
        filterSet.add("uima.tcas.Annotation:end");
        filterSet.add("org.apache.uima.ruta.type.RutaBasic:Replacement");
        return filterSet;
    }

    public static synchronized TextRulerExample exampleListContainsAnnotation(List<TextRulerExample> list, TextRulerAnnotation ann) {
        TextRulerExample needle = new TextRulerExample(null, ann, true, null);
        int index = Collections.binarySearch(list, needle, new Comparator<TextRulerExample>(){

            @Override
            public int compare(TextRulerExample o1, TextRulerExample o2) {
                TextRulerAnnotation afs1 = o1.getAnnotation();
                TextRulerAnnotation afs2 = o2.getAnnotation();
                if (afs1.getBegin() < afs2.getBegin()) {
                    return -1;
                }
                if (afs1.getBegin() > afs2.getBegin()) {
                    return 1;
                }
                if (afs1.getEnd() > afs2.getEnd()) {
                    return -1;
                }
                if (afs1.getEnd() < afs2.getEnd()) {
                    return 1;
                }
                return 0;
            }
        });
        if (index >= 0) {
            return list.get(index);
        }
        return null;
    }

    public static synchronized String addTrailingSlashToPath(String path) {
        if (!path.endsWith("/") && !path.endsWith("\\")) {
            path = path + System.getProperty("file.separator");
        }
        return path;
    }

    public static synchronized String createTemporaryDirectory() throws IOException {
        File temp = File.createTempFile("temp", Long.toString(System.nanoTime()));
        if (!temp.delete()) {
            return null;
        }
        if (!temp.mkdir()) {
            return null;
        }
        temp.deleteOnExit();
        return TextRulerToolkit.addTrailingSlashToPath(temp.getPath());
    }

    public static synchronized String getTypeShortName(String typeName) {
        if (typeName.indexOf(".") >= 0) {
            String[] components = typeName.split("\\.");
            return components[components.length - 1];
        }
        return typeName;
    }

    public static synchronized String escapeForRegExp(String aRegexFragment) {
        StringBuilder result = new StringBuilder();
        StringCharacterIterator iterator = new StringCharacterIterator(aRegexFragment);
        char character = iterator.current();
        while (character != '\uffff') {
            if (character == '.') {
                result.append("\\.");
            } else if (character == '\\') {
                result.append("\\\\");
            } else if (character == '?') {
                result.append("\\?");
            } else if (character == '*') {
                result.append("\\*");
            } else if (character == '+') {
                result.append("\\+");
            } else if (character == '&') {
                result.append("\\&");
            } else if (character == ':') {
                result.append("\\:");
            } else if (character == '{') {
                result.append("\\{");
            } else if (character == '}') {
                result.append("\\}");
            } else if (character == '[') {
                result.append("\\[");
            } else if (character == ']') {
                result.append("\\]");
            } else if (character == '(') {
                result.append("\\(");
            } else if (character == ')') {
                result.append("\\)");
            } else if (character == '^') {
                result.append("\\^");
            } else if (character == '$') {
                result.append("\\$");
            } else {
                result.append(character);
            }
            character = iterator.next();
        }
        return result.toString();
    }

    public static synchronized String escapeForStringParameter(String stringFragment) {
        StringBuilder result = new StringBuilder();
        StringCharacterIterator iterator = new StringCharacterIterator(stringFragment);
        char character = iterator.current();
        while (character != '\uffff') {
            if (character == '\"') {
                result.append("\\\"");
            } else if (character == '\\') {
                result.append("\\\\");
            } else {
                result.append(character);
            }
            character = iterator.next();
        }
        return result.toString();
    }

    public static synchronized void appendStringToFile(String fileName, String str) {
        try {
            File f = new File(fileName);
            BufferedWriter output = !f.exists() ? new BufferedWriter(new FileWriter(fileName)) : new BufferedWriter(new FileWriter(fileName, true));
            output.append(str);
            output.close();
        }
        catch (IOException e) {
            TextRulerPlugin.error(e);
        }
    }

    public static synchronized TextRulerAnnotation convertToTargetAnnotation(AnnotationFS fs, TextRulerExampleDocument doc, TextRulerTarget target, TypeSystem ts) {
        AnnotationFS theAnnotation = target.type == TextRulerTarget.MLTargetType.SINGLE_LEFT_BOUNDARY ? fs.getCAS().createAnnotation(ts.getType(target.getSingleSlotTypeName()), fs.getBegin(), fs.getBegin()) : (target.type == TextRulerTarget.MLTargetType.SINGLE_RIGHT_BOUNDARY ? fs.getCAS().createAnnotation(ts.getType(target.getSingleSlotTypeName()), fs.getEnd(), fs.getEnd()) : fs);
        return new TextRulerAnnotation(theAnnotation, doc);
    }

    public static synchronized List<Feature> getFilteredAnnotationFeatures(AnnotationFS afs) {
        ArrayList<Feature> result = new ArrayList<Feature>();
        List theFeatures = afs.getType().getFeatures();
        Set<String> filters = TextRulerToolkit.getStandardFeatureFilterSet();
        for (Feature f : theFeatures) {
            if (filters.contains(f.getName())) continue;
            result.add(f);
        }
        return result;
    }
}

