/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.orchestrator;

import java.util.Collection;
import java.util.List;
import org.apache.uima.ducc.common.internationalization.Messages;
import org.apache.uima.ducc.common.node.metrics.ProcessGarbageCollectionStats;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.TimeStamp;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.orchestrator.OrUtil;
import org.apache.uima.ducc.orchestrator.OrchestratorCommonArea;
import org.apache.uima.ducc.orchestrator.ProcessToJobMap;
import org.apache.uima.ducc.orchestrator.StateJobAccounting;
import org.apache.uima.ducc.orchestrator.WorkMapHelper;
import org.apache.uima.ducc.orchestrator.user.UserLogging;
import org.apache.uima.ducc.orchestrator.utilities.TrackSync;
import org.apache.uima.ducc.transport.event.common.DuccWorkJob;
import org.apache.uima.ducc.transport.event.common.DuccWorkMap;
import org.apache.uima.ducc.transport.event.common.DuccWorkPopDriver;
import org.apache.uima.ducc.transport.event.common.IDuccProcess;
import org.apache.uima.ducc.transport.event.common.IDuccProcessMap;
import org.apache.uima.ducc.transport.event.common.IDuccSchedulingInfo;
import org.apache.uima.ducc.transport.event.common.IDuccState;
import org.apache.uima.ducc.transport.event.common.IDuccWork;
import org.apache.uima.ducc.transport.event.common.IDuccWorkExecutable;
import org.apache.uima.ducc.transport.event.common.IDuccWorkJob;
import org.apache.uima.ducc.transport.event.common.IProcessState;
import org.apache.uima.ducc.transport.event.common.IResourceState;
import org.apache.uima.ducc.transport.event.common.ITimeWindow;
import org.apache.uima.ducc.transport.event.common.TimeWindow;
import org.apache.uima.ducc.transport.event.jd.IDriverStatusReport;

public class ProcessAccounting {
    private static final DuccLogger logger = DuccLogger.getLogger(ProcessAccounting.class);
    private OrchestratorCommonArea orchestratorCommonArea = OrchestratorCommonArea.getInstance();
    private Messages messages = this.orchestratorCommonArea.getSystemMessages();
    private ProcessToJobMap processToJobMap = ProcessToJobMap.getInstance();
    private StateJobAccounting stateJobAccounting = StateJobAccounting.getInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DuccId getJobId(DuccId processId) {
        DuccId retVal;
        String methodName = "getJobId";
        DuccWorkMap workMap = this.orchestratorCommonArea.getWorkMap();
        TrackSync ts = TrackSync.await(workMap, this.getClass(), methodName);
        DuccWorkMap duccWorkMap = workMap;
        synchronized (duccWorkMap) {
            ts.using();
            retVal = this.processToJobMap.get(processId);
        }
        ts.ended();
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int processCount() {
        int retVal;
        String methodName = "processCount";
        DuccWorkMap workMap = this.orchestratorCommonArea.getWorkMap();
        TrackSync ts = TrackSync.await(workMap, this.getClass(), methodName);
        DuccWorkMap duccWorkMap = workMap;
        synchronized (duccWorkMap) {
            ts.using();
            retVal = this.processToJobMap.size();
        }
        ts.ended();
        return retVal;
    }

    public boolean addProcess(DuccId processId, DuccId jobId) {
        String methodName = "addProcess";
        logger.trace(methodName, null, new Object[]{this.messages.fetch("enter")});
        boolean retVal = false;
        DuccWorkMap workMap = this.orchestratorCommonArea.getWorkMap();
        TrackSync ts = TrackSync.await(workMap, this.getClass(), methodName);
        ts.using();
        DuccId key = this.processToJobMap.put(processId, jobId);
        if (key == null) {
            retVal = true;
            logger.info(methodName, jobId, processId, new Object[]{this.messages.fetch("added")});
        } else {
            logger.warn(methodName, jobId, processId, new Object[]{this.messages.fetch("exists")});
        }
        ts.ended();
        logger.trace(methodName, null, new Object[]{this.messages.fetch("exit")});
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeProcess(DuccId processId) {
        String methodName = "removeProcess";
        logger.trace(methodName, null, new Object[]{this.messages.fetch("enter")});
        boolean retVal = false;
        DuccWorkMap workMap = this.orchestratorCommonArea.getWorkMap();
        TrackSync ts = TrackSync.await(workMap, this.getClass(), methodName);
        DuccWorkMap duccWorkMap = workMap;
        synchronized (duccWorkMap) {
            ts.using();
            if (this.processToJobMap.containsKey(processId)) {
                DuccId jobId = this.processToJobMap.remove(processId);
                retVal = true;
                logger.info(methodName, jobId, processId, new Object[]{this.messages.fetch("removed")});
            } else {
                logger.warn(methodName, null, processId, new Object[]{this.messages.fetch("not found")});
            }
        }
        ts.ended();
        logger.trace(methodName, null, new Object[]{this.messages.fetch("exit")});
        return retVal;
    }

    private boolean compare(String a, String b) {
        boolean retVal = false;
        if (a == null) {
            if (b == null) {
                retVal = true;
            }
        } else {
            return a.equals(b);
        }
        return retVal;
    }

    private boolean compare(ITimeWindow a, ITimeWindow b) {
        boolean retVal = false;
        if (a == null && b == null) {
            retVal = true;
        } else if (a != null && b != null) {
            retVal = this.compare(a.getStart(), b.getStart()) && this.compare(a.getEnd(), b.getEnd());
        }
        return retVal;
    }

    private void copyInventoryPID(IDuccWork dw, IDuccProcess inventoryProcess, IDuccProcess process) {
        String methodName = "copyInventoryPID";
        logger.trace(methodName, null, new Object[]{this.messages.fetch("enter")});
        String newValue = inventoryProcess.getPID();
        String oldValue = process.getPID();
        logger.debug(methodName, dw.getDuccId(), inventoryProcess.getDuccId(), new Object[]{"" + newValue});
        if (newValue == null) {
            if (oldValue != null) {
                logger.warn(methodName, dw.getDuccId(), inventoryProcess.getDuccId(), new Object[]{"PID old:" + oldValue + " new:" + newValue + " keeping old"});
            }
        } else if (oldValue == null) {
            process.setPID(newValue);
        } else if (!oldValue.equals(newValue)) {
            logger.warn(methodName, dw.getDuccId(), inventoryProcess.getDuccId(), new Object[]{"PID old:" + oldValue + " new:" + newValue + " replacing old"});
            process.setPID(newValue);
        }
        logger.trace(methodName, null, new Object[]{this.messages.fetch("exit")});
    }

    private void copyInventorySwapUsage(IDuccWork dw, IDuccProcess inventoryProcess, IDuccProcess process) {
        String methodName = "copyInventorySwapUsage";
        logger.trace(methodName, null, new Object[]{this.messages.fetch("enter")});
        long value = inventoryProcess.getSwapUsage();
        logger.trace(methodName, dw.getDuccId(), inventoryProcess.getDuccId(), new Object[]{"PID:" + process.getPID() + " swap:" + value});
        process.setSwapUsage(value);
        if (process.getSwapUsageMax() < process.getSwapUsage()) {
            process.setSwapUsageMax(process.getSwapUsage());
        }
        logger.trace(methodName, null, new Object[]{this.messages.fetch("exit")});
    }

    private void copyInventoryMajorFaults(IDuccWork dw, IDuccProcess inventoryProcess, IDuccProcess process) {
        String methodName = "copyInventoryMajorFaults";
        logger.trace(methodName, null, new Object[]{this.messages.fetch("enter")});
        process.setMajorFaults(inventoryProcess.getMajorFaults());
        DuccId jobid = dw.getDuccId();
        DuccId processId = process.getDuccId();
        logger.trace(methodName, jobid, processId, new Object[]{"MajofFaults:" + process.getMajorFaults()});
        logger.trace(methodName, null, new Object[]{this.messages.fetch("exit")});
    }

    private void copyInventoryRss(IDuccWork dw, IDuccProcess inventoryProcess, IDuccProcess process) {
        String methodName = "copyInventoryRss";
        logger.trace(methodName, null, new Object[]{this.messages.fetch("enter")});
        process.setResidentMemory(inventoryProcess.getResidentMemory());
        DuccId jobid = dw.getDuccId();
        DuccId processId = process.getDuccId();
        logger.trace(methodName, jobid, processId, new Object[]{"Rss:" + process.getResidentMemory()});
        logger.trace(methodName, null, new Object[]{this.messages.fetch("exit")});
    }

    private boolean validateGCStats(DuccId jobid, DuccId processId, ProcessGarbageCollectionStats newGCS, ProcessGarbageCollectionStats oldGCS) {
        String location = "validateGCStats";
        boolean retVal = true;
        if (oldGCS != null) {
            if (newGCS == null) {
                logger.warn(location, jobid, processId, new Object[]{"ProcessGarbageCollectionStats missing?"});
                retVal = false;
            } else {
                long oldCT;
                long newCT;
                long oldCC;
                long newCC = newGCS.getCollectionCount();
                if (newCC < (oldCC = oldGCS.getCollectionCount())) {
                    logger.warn(location, jobid, processId, new Object[]{"CollectionCount " + newCC + " < " + oldCC});
                    retVal = false;
                }
                if ((newCT = newGCS.getCollectionTime()) < (oldCT = oldGCS.getCollectionTime())) {
                    logger.warn(location, jobid, processId, new Object[]{"CollectionTime " + newCT + " < " + oldCT});
                    retVal = false;
                }
            }
        }
        return retVal;
    }

    private void copyInventoryGCStats(IDuccWork dw, IDuccProcess inventoryProcess, IDuccProcess process) {
        String methodName = "copyInventoryGCStats";
        logger.trace(methodName, null, new Object[]{this.messages.fetch("enter")});
        DuccId jobId = dw.getDuccId();
        DuccId processId = process.getDuccId();
        ProcessGarbageCollectionStats newGCS = inventoryProcess.getGarbageCollectionStats();
        ProcessGarbageCollectionStats oldGCS = process.getGarbageCollectionStats();
        if (this.validateGCStats(jobId, processId, newGCS, oldGCS)) {
            process.setGarbageCollectionStats(newGCS);
            ProcessGarbageCollectionStats gcs = process.getGarbageCollectionStats();
            if (gcs != null) {
                logger.trace(methodName, jobId, processId, new Object[]{"GC Stats Count:" + gcs.getCollectionCount()});
                logger.trace(methodName, jobId, processId, new Object[]{"GC Stats Time:" + gcs.getCollectionTime()});
            }
        }
        logger.trace(methodName, null, new Object[]{this.messages.fetch("exit")});
    }

    private void copyInventoryCpuTime(IDuccWork dw, IDuccProcess inventoryProcess, IDuccProcess process) {
        String methodName = "copyInventoryCpuTime";
        logger.trace(methodName, null, new Object[]{this.messages.fetch("enter")});
        process.setCpuTime(inventoryProcess.getCpuTime());
        process.setCurrentCPU(inventoryProcess.getCurrentCPU());
        logger.trace(methodName, dw.getDuccId(), process.getDuccId(), new Object[]{"Cpu Time (overall):" + process.getCpuTime()});
        logger.trace(methodName, dw.getDuccId(), process.getDuccId(), new Object[]{"Cpu Time (current):" + process.getCurrentCPU()});
        logger.trace(methodName, null, new Object[]{this.messages.fetch("exit")});
    }

    private void copyTimeInit(IDuccProcess inventoryProcess, IDuccProcess process) {
        String methodName = "copyTimeInit";
        logger.trace(methodName, null, new Object[]{this.messages.fetch("enter")});
        DuccId processId = inventoryProcess.getDuccId();
        DuccId jobId = this.getJobId(processId);
        ITimeWindow twInit = inventoryProcess.getTimeWindowInit();
        if (twInit != null && !this.compare(twInit, process.getTimeWindowInit())) {
            String ts;
            process.setTimeWindowInit(twInit);
            String millis = process.getTimeWindowInit().getStart();
            if (millis != null) {
                ts = TimeStamp.simpleFormat((String)millis);
                logger.trace(methodName, jobId, processId, new Object[]{this.messages.fetchLabel("initialization start") + ts});
            }
            if ((millis = process.getTimeWindowInit().getEnd()) != null) {
                ts = TimeStamp.simpleFormat((String)millis);
                logger.trace(methodName, jobId, processId, new Object[]{this.messages.fetchLabel("initialization end") + ts});
            }
        }
        logger.trace(methodName, null, new Object[]{this.messages.fetch("exit")});
    }

    private void copyTimeRun(IDuccProcess inventoryProcess, IDuccProcess process) {
        String methodName = "copyTimeRun";
        logger.trace(methodName, null, new Object[]{this.messages.fetch("enter")});
        DuccId processId = inventoryProcess.getDuccId();
        DuccId jobId = this.getJobId(processId);
        ITimeWindow twRun = inventoryProcess.getTimeWindowRun();
        if (twRun != null) {
            ITimeWindow tw;
            if (!this.compare(twRun, process.getTimeWindowRun())) {
                String ts;
                process.setTimeWindowRun(twRun);
                String millis = process.getTimeWindowRun().getStart();
                if (millis != null) {
                    ts = TimeStamp.simpleFormat((String)millis);
                    logger.trace(methodName, jobId, processId, new Object[]{this.messages.fetchLabel("run start") + ts});
                }
                if ((millis = process.getTimeWindowRun().getEnd()) != null) {
                    ts = TimeStamp.simpleFormat((String)millis);
                    logger.trace(methodName, jobId, processId, new Object[]{this.messages.fetchLabel("run end") + ts});
                }
            }
            if ((tw = process.getTimeWindowRun()) != null) {
                logger.trace(methodName, jobId, processId, new Object[]{"start:" + tw.getStart() + " end:" + tw.getEnd()});
            }
        }
        logger.trace(methodName, null, new Object[]{this.messages.fetch("exit")});
    }

    private void setResourceStateAndReason(IDuccWorkJob job, IDuccProcess inventoryProcess, IDuccProcess process) {
        String methodName = "setResourceStateAndReason";
        logger.trace(methodName, job.getDuccId(), new Object[]{this.messages.fetch("enter")});
        block0 : switch (inventoryProcess.getProcessState()) {
            case Stopped: 
            case LaunchFailed: 
            case Failed: 
            case Killed: 
            case FailedInitialization: 
            case InitializationTimeout: {
                block3 : switch (process.getResourceState()) {
                    case Allocated: {
                        OrUtil.setResourceState(job, process, IResourceState.ResourceState.Deallocated);
                        String reason = inventoryProcess.getReasonForStoppingProcess();
                        String extendedReason = inventoryProcess.getExtendedReasonForStoppingProcess();
                        StringBuffer message = new StringBuffer();
                        message.append(this.messages.fetchLabel("process state") + inventoryProcess.getProcessState());
                        message.append(" => " + this.messages.fetchLabel("resource state") + process.getResourceState());
                        message.append(" : " + this.messages.fetchLabel("reason") + reason);
                        if (extendedReason != null) {
                            message.append(", " + extendedReason);
                        }
                        logger.info(methodName, job.getDuccId(), process.getDuccId(), new Object[]{message.toString()});
                        switch (inventoryProcess.getProcessState()) {
                            case Stopped: {
                                if (reason != null) {
                                    process.setReasonForStoppingProcess(reason);
                                    process.setExtendedReasonForStoppingProcess(extendedReason);
                                    message = new StringBuffer();
                                    message.append(this.messages.fetchLabel("process state") + inventoryProcess.getProcessState());
                                    message.append(" => " + this.messages.fetchLabel("resource state") + process.getResourceState());
                                    message.append(" : " + this.messages.fetchLabel("reason") + reason);
                                    if (extendedReason != null) {
                                        message.append(", " + extendedReason);
                                    }
                                    logger.debug(methodName, job.getDuccId(), process.getDuccId(), new Object[]{message.toString()});
                                }
                                process.setProcessDeallocationType(IResourceState.ProcessDeallocationType.AutonomousStop);
                                break block3;
                            }
                            case LaunchFailed: 
                            case Failed: {
                                if (reason != null) {
                                    process.setReasonForStoppingProcess(reason);
                                    process.setExtendedReasonForStoppingProcess(extendedReason);
                                    message = new StringBuffer();
                                    message.append(this.messages.fetchLabel("process state") + inventoryProcess.getProcessState());
                                    message.append(" => " + this.messages.fetchLabel("resource state") + process.getResourceState());
                                    message.append(" : " + this.messages.fetchLabel("reason") + reason);
                                    if (extendedReason != null) {
                                        message.append(", " + extendedReason);
                                    }
                                    logger.debug(methodName, job.getDuccId(), process.getDuccId(), new Object[]{message.toString()});
                                }
                                process.setProcessDeallocationType(IResourceState.ProcessDeallocationType.Failed);
                                break block3;
                            }
                            case Killed: {
                                if (reason != null) {
                                    process.setReasonForStoppingProcess(reason);
                                    process.setExtendedReasonForStoppingProcess(extendedReason);
                                    message = new StringBuffer();
                                    message.append(this.messages.fetchLabel("process state") + inventoryProcess.getProcessState());
                                    message.append(" => " + this.messages.fetchLabel("resource state") + process.getResourceState());
                                    message.append(" : " + this.messages.fetchLabel("reason") + reason);
                                    if (extendedReason != null) {
                                        message.append(", " + extendedReason);
                                    }
                                    logger.debug(methodName, job.getDuccId(), process.getDuccId(), new Object[]{message.toString()});
                                }
                                process.setProcessDeallocationType(IResourceState.ProcessDeallocationType.Killed);
                                break block3;
                            }
                        }
                        break;
                    }
                    default: {
                        logger.debug(methodName, job.getDuccId(), process.getDuccId(), new Object[]{this.messages.fetchLabel("process state") + inventoryProcess.getProcessState() + " => " + this.messages.fetchLabel("resource state") + process.getResourceState()});
                    }
                }
                switch (job.getDuccType()) {
                    case Service: {
                        UserLogging.error(job, "reason for stopping service instance[" + job.getDuccId().getFriendly() + "]: " + process.getReasonForStoppingProcess());
                        break block0;
                    }
                }
                break;
            }
            default: {
                logger.debug(methodName, job.getDuccId(), process.getDuccId(), new Object[]{this.messages.fetchLabel("process state") + inventoryProcess.getProcessState() + " => " + this.messages.fetchLabel("resource state") + process.getResourceState()});
            }
        }
        logger.trace(methodName, job.getDuccId(), new Object[]{this.messages.fetch("exit")});
    }

    private void copyInventoryProcessState(IDuccWorkJob job, IDuccProcess inventoryProcess, IDuccProcess process) {
        String methodName = "copyInventoryProcessState";
        logger.trace(methodName, job.getDuccId(), new Object[]{this.messages.fetch("enter")});
        if (!this.compare(inventoryProcess.getProcessState().toString(), process.getProcessState().toString())) {
            switch ((IDuccState.JobState)job.getStateObject()) {
                default: 
            }
            process.advanceProcessState(inventoryProcess.getProcessState());
            if (inventoryProcess.getProcessJmxUrl() != null && process.getProcessJmxUrl() == null) {
                process.setProcessJmxUrl(inventoryProcess.getProcessJmxUrl());
            }
        }
        logger.trace(methodName, job.getDuccId(), process.getDuccId(), new Object[]{this.messages.fetchLabel("process state") + process.getProcessState()});
        logger.trace(methodName, job.getDuccId(), new Object[]{this.messages.fetch("exit")});
    }

    private boolean changed(String s1, String s2) {
        boolean retVal = false;
        if (s1 != null || s2 != null) {
            if (s1 == null && s2 != null) {
                retVal = true;
            } else if (s1 != null && s2 == null) {
                retVal = true;
            } else if (!s1.equals(s2)) {
                retVal = true;
            }
        }
        return retVal;
    }

    private void copyReasonForStoppingProcess(IDuccWorkJob job, IDuccProcess inventoryProcess, IDuccProcess process) {
        String methodName = "copyReasonForStoppingProcess";
        logger.trace(methodName, job.getDuccId(), new Object[]{this.messages.fetch("enter")});
        switch (inventoryProcess.getProcessState()) {
            case Stopped: 
            case LaunchFailed: 
            case Failed: 
            case Killed: 
            case FailedInitialization: 
            case InitializationTimeout: {
                String reasonNew = inventoryProcess.getReasonForStoppingProcess();
                String reasonOld = process.getReasonForStoppingProcess();
                if (this.changed(reasonOld, reasonNew)) {
                    process.setReasonForStoppingProcess(reasonNew);
                    logger.info(methodName, job.getDuccId(), process.getDuccId(), new Object[]{this.messages.fetchLabel("process reason code") + reasonOld + "->" + reasonNew});
                }
                String extendedReasonNew = inventoryProcess.getExtendedReasonForStoppingProcess();
                String extendedReasonOld = process.getExtendedReasonForStoppingProcess();
                if (!this.changed(extendedReasonOld, extendedReasonNew)) break;
                process.setExtendedReasonForStoppingProcess(extendedReasonNew);
                logger.info(methodName, job.getDuccId(), process.getDuccId(), new Object[]{this.messages.fetchLabel("process extended reason code") + extendedReasonOld + "->" + extendedReasonNew});
                break;
            }
        }
        logger.trace(methodName, job.getDuccId(), new Object[]{this.messages.fetch("exit")});
    }

    private void copyProcessExitCode(IDuccWorkJob job, IDuccProcess inventoryProcess, IDuccProcess process) {
        String methodName = "copyProcessExitCode";
        logger.trace(methodName, job.getDuccId(), new Object[]{this.messages.fetch("enter")});
        switch (inventoryProcess.getProcessState()) {
            case Stopped: 
            case LaunchFailed: 
            case Failed: 
            case Killed: 
            case FailedInitialization: 
            case InitializationTimeout: {
                int codeNew = inventoryProcess.getProcessExitCode();
                int codeOld = process.getProcessExitCode();
                if (codeNew == codeOld) break;
                process.setProcessExitCode(codeNew);
                logger.info(methodName, job.getDuccId(), process.getDuccId(), new Object[]{this.messages.fetchLabel("process exit code") + process.getProcessExitCode()});
                break;
            }
        }
        logger.trace(methodName, job.getDuccId(), new Object[]{this.messages.fetch("exit")});
    }

    private void copyUimaPipelineComponentsState(IDuccWorkJob job, IDuccProcess inventoryProcess, IDuccProcess process) {
        String methodName = "copyUimaPipelineComponentsState";
        logger.trace(methodName, job.getDuccId(), new Object[]{this.messages.fetch("enter")});
        List list = inventoryProcess.getUimaPipelineComponents();
        if (list != null) {
            logger.trace(methodName, job.getDuccId(), new Object[]{"size: " + list.size()});
            process.setUimaPipelineComponents(list);
        } else {
            logger.trace(methodName, job.getDuccId(), new Object[]{"size: null"});
        }
        logger.trace(methodName, job.getDuccId(), new Object[]{this.messages.fetch("exit")});
    }

    private void updateProcessInitilization(IDuccWorkJob job, IDuccProcess inventoryProcess, IDuccProcess process) {
        block0 : switch (inventoryProcess.getProcessState()) {
            case Started: 
            case Running: {
                process.setInitialized();
                if (job == null) break;
                switch (job.getDuccType()) {
                    case Service: {
                        switch (job.getJobState()) {
                            case Initializing: {
                                this.stateJobAccounting.stateChange(job, IDuccState.JobState.Running);
                                break block0;
                            }
                        }
                        break block0;
                    }
                }
            }
        }
    }

    private boolean isInitializing(IProcessState.ProcessState ps) {
        boolean retVal = false;
        if (ps != null) {
            switch (ps) {
                case Started: 
                case Starting: 
                case Initializing: {
                    retVal = true;
                    break;
                }
            }
        }
        return retVal;
    }

    private boolean isRunning(IProcessState.ProcessState ps) {
        boolean retVal = false;
        if (ps != null) {
            switch (ps) {
                case Running: {
                    retVal = true;
                    break;
                }
            }
        }
        return retVal;
    }

    private boolean isCompleted(IProcessState.ProcessState ps) {
        boolean retVal = false;
        if (ps != null) {
            switch (ps) {
                case Stopped: 
                case LaunchFailed: 
                case Failed: 
                case Killed: 
                case FailedInitialization: 
                case InitializationTimeout: {
                    retVal = true;
                    break;
                }
            }
        }
        return retVal;
    }

    private void adjustProcessTime(IDuccWorkJob job, IDuccProcess inventoryProcess, IDuccProcess process) {
        ITimeWindow twi;
        IProcessState.ProcessState ips;
        String methodName = "adjustProcessTime";
        logger.trace(methodName, job.getDuccId(), new Object[]{this.messages.fetch("enter")});
        long ts = System.currentTimeMillis();
        DuccId jobId = job.getDuccId();
        DuccId prcId = process.getDuccId();
        IProcessState.ProcessState ops = process.getProcessState();
        if (ops == null) {
            ops = IProcessState.ProcessState.Undefined;
            process.setProcessState(ops);
        }
        if ((ips = inventoryProcess.getProcessState()) == null) {
            ips = IProcessState.ProcessState.Undefined;
            inventoryProcess.setProcessState(ips);
        }
        if ((twi = inventoryProcess.getTimeWindowInit()) == null) {
            twi = new TimeWindow();
            inventoryProcess.setTimeWindowInit(twi);
        }
        long twis = twi.getStartLong();
        long twie = twi.getEndLong();
        ITimeWindow twr = inventoryProcess.getTimeWindowRun();
        if (twr == null) {
            twr = new TimeWindow();
            inventoryProcess.setTimeWindowRun(twr);
        }
        long twrs = twr.getStartLong();
        long twre = twr.getEndLong();
        logger.debug(methodName, jobId, prcId, new Object[]{"raw", ips, ops, twis, twie, twrs, twre});
        if (!this.isInitializing(ips)) {
            if (this.isRunning(ips)) {
                if (twrs < 0L) {
                    twr.setStartLong(twie);
                    twrs = twr.getStartLong();
                }
            } else if (this.isCompleted(ips)) {
                if (twrs < 0L) {
                    twr.setStartLong(twie);
                    twrs = twr.getStartLong();
                }
                if (this.isCompleted(ops)) {
                    ITimeWindow tw = process.getTimeWindowRun();
                    twre = tw.getEndLong();
                    twr.setEndLong(twre);
                } else if (twre < 0L) {
                    twr.setEndLong(ts);
                    twre = twr.getEndLong();
                }
            }
        }
        logger.debug(methodName, jobId, prcId, new Object[]{"adj", ips, ops, twis, twie, twrs, twre});
        logger.trace(methodName, job.getDuccId(), new Object[]{this.messages.fetch("exit")});
    }

    private void updateProcessTime(IDuccWorkJob job, IDuccProcess inventoryProcess, IDuccProcess process) {
        String methodName = "updateProcessTime";
        logger.trace(methodName, job.getDuccId(), new Object[]{this.messages.fetch("enter")});
        this.adjustProcessTime(job, inventoryProcess, process);
        switch (inventoryProcess.getProcessState()) {
            case Started: 
            case Starting: 
            case Initializing: {
                this.copyTimeInit(inventoryProcess, process);
                break;
            }
            case Running: {
                this.copyTimeInit(inventoryProcess, process);
                this.copyTimeRun(inventoryProcess, process);
                break;
            }
            case Stopped: 
            case LaunchFailed: 
            case Failed: 
            case Killed: 
            case FailedInitialization: 
            case InitializationTimeout: {
                this.copyTimeInit(inventoryProcess, process);
                this.copyTimeRun(inventoryProcess, process);
                break;
            }
            case Undefined: {
                break;
            }
        }
        logger.trace(methodName, job.getDuccId(), new Object[]{this.messages.fetch("exit")});
    }

    private IDuccProcess getProcess(IDuccWorkExecutable dw, DuccId processId) {
        IDuccProcess process = null;
        if (dw != null && processId != null) {
            IDuccWorkJob job;
            DuccWorkPopDriver driver;
            IDuccProcessMap map = null;
            map = dw.getProcessMap();
            if (map != null && (process = (IDuccProcess)map.get((Object)processId)) == null && dw instanceof IDuccWorkJob && (driver = (job = (IDuccWorkJob)dw).getDriver()) != null && (map = driver.getProcessMap()) != null) {
                process = (IDuccProcess)map.get((Object)processId);
            }
        }
        return process;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatus(IDuccProcess inventoryProcess) {
        String methodName = "setStatus";
        logger.trace(methodName, null, new Object[]{this.messages.fetch("enter")});
        DuccWorkMap workMap = this.orchestratorCommonArea.getWorkMap();
        try {
            DuccId processId = inventoryProcess.getDuccId();
            logger.debug(methodName, null, processId, new Object[]{this.messages.fetchLabel("node") + inventoryProcess.getNodeIdentity().getCanonicalName() + " " + this.messages.fetchLabel("PID") + inventoryProcess.getPID()});
            TrackSync ts = TrackSync.await(workMap, this.getClass(), methodName);
            DuccWorkMap duccWorkMap = workMap;
            synchronized (duccWorkMap) {
                ts.using();
                if (this.processToJobMap.containsKey(processId)) {
                    logger.trace(methodName, null, processId, new Object[]{"key found"});
                    DuccId jobId = this.getJobId(processId);
                    logger.trace(methodName, jobId, processId, new Object[]{"jobId from process map"});
                    IDuccWork dw = WorkMapHelper.findDuccWork(workMap, jobId, (Object)this, methodName);
                    if (dw != null) {
                        logger.trace(methodName, dw.getDuccId(), processId, new Object[]{"entity found in work map"});
                        if (dw instanceof IDuccWorkExecutable) {
                            IDuccWorkJob job = null;
                            if (dw instanceof IDuccWorkJob) {
                                job = (IDuccWorkJob)dw;
                                IDuccProcess process = this.getProcess((IDuccWorkExecutable)job, processId);
                                if (process != null) {
                                    logger.trace(methodName, job.getDuccId(), processId, new Object[]{"process found"});
                                    if (process.isComplete()) {
                                        logger.trace(methodName, jobId, process.getDuccId(), new Object[]{"finalized"});
                                    } else {
                                        logger.trace(methodName, jobId, process.getDuccId(), new Object[]{"active"});
                                        this.updateProcessTime(job, inventoryProcess, process);
                                        this.copyInventoryPID((IDuccWork)job, inventoryProcess, process);
                                        this.setResourceStateAndReason(job, inventoryProcess, process);
                                        this.copyInventoryProcessState(job, inventoryProcess, process);
                                        this.copyReasonForStoppingProcess(job, inventoryProcess, process);
                                        this.copyProcessExitCode(job, inventoryProcess, process);
                                        this.updateProcessInitilization(job, inventoryProcess, process);
                                        this.copyUimaPipelineComponentsState(job, inventoryProcess, process);
                                        this.copyInventorySwapUsage((IDuccWork)job, inventoryProcess, process);
                                        this.copyInventoryMajorFaults((IDuccWork)job, inventoryProcess, process);
                                        this.copyInventoryRss((IDuccWork)job, inventoryProcess, process);
                                        this.copyInventoryGCStats((IDuccWork)job, inventoryProcess, process);
                                        this.copyInventoryCpuTime((IDuccWork)job, inventoryProcess, process);
                                    }
                                } else {
                                    logger.warn(methodName, dw.getDuccId(), processId, new Object[]{this.messages.fetch("process not found in job's process table")});
                                }
                            } else {
                                logger.warn(methodName, dw.getDuccId(), processId, new Object[]{"entity is not job"});
                            }
                        } else {
                            logger.warn(methodName, jobId, processId, new Object[]{this.messages.fetch("not executable")});
                        }
                    } else {
                        logger.warn(methodName, jobId, processId, new Object[]{this.messages.fetch("ID not found")});
                    }
                } else {
                    logger.warn(methodName, null, processId, new Object[]{this.messages.fetch("ID not found in process map")});
                }
            }
            ts.ended();
        }
        catch (Throwable t) {
            logger.error(methodName, null, t, new Object[0]);
        }
        logger.trace(methodName, null, new Object[]{this.messages.fetch("exit")});
    }

    public boolean setStatus(IDriverStatusReport jdStatusReport, DuccWorkJob duccWorkJob) {
        String jdPreemptWorkItems;
        String jdRetryWorkItems;
        String jdErrorWorkItems;
        String jdDispatchedWorkItems;
        String jdCompletedWorkItems;
        String methodName = "setStatus";
        logger.trace(methodName, null, new Object[]{this.messages.fetch("enter")});
        boolean retVal = false;
        String jdTotalWorkItems = "" + jdStatusReport.getWorkItemsTotal();
        if (!this.compare(jdTotalWorkItems, duccWorkJob.getSchedulingInfo().getWorkItemsTotal())) {
            duccWorkJob.getSchedulingInfo().setWorkItemsTotal(jdTotalWorkItems);
            long total_work = jdStatusReport.getWorkItemsTotal();
            int tps = duccWorkJob.getSchedulingInfo().getIntThreadsPerProcess();
            if (total_work > 0L && tps > 0) {
                long max_usable = (total_work + (long)tps - 1L) / (long)tps;
                long max_processes = duccWorkJob.getSchedulingInfo().getLongProcessesMax();
                if (max_processes > max_usable) {
                    duccWorkJob.getSchedulingInfo().setLongProcessesMax(max_usable);
                    logger.info(methodName, duccWorkJob.getDuccId(), new Object[]{"reduced max-processes", max_processes, "to max-usable", max_usable});
                }
            }
        }
        if (!this.compare(jdCompletedWorkItems = "" + jdStatusReport.getWorkItemsProcessingCompleted(), duccWorkJob.getSchedulingInfo().getWorkItemsCompleted())) {
            duccWorkJob.getSchedulingInfo().setWorkItemsCompleted(jdCompletedWorkItems);
        }
        if (!this.compare(jdDispatchedWorkItems = "" + jdStatusReport.getWorkItemsDispatched(), duccWorkJob.getSchedulingInfo().getWorkItemsDispatched())) {
            duccWorkJob.getSchedulingInfo().setWorkItemsDispatched(jdDispatchedWorkItems);
        }
        if (!this.compare(jdErrorWorkItems = "" + jdStatusReport.getWorkItemsProcessingError(), duccWorkJob.getSchedulingInfo().getWorkItemsError())) {
            duccWorkJob.getSchedulingInfo().setWorkItemsError(jdErrorWorkItems);
        }
        if (!this.compare(jdRetryWorkItems = "" + jdStatusReport.getWorkItemsRetry(), duccWorkJob.getSchedulingInfo().getWorkItemsRetry())) {
            duccWorkJob.getSchedulingInfo().setWorkItemsRetry(jdRetryWorkItems);
        }
        if (!this.compare(jdPreemptWorkItems = "" + jdStatusReport.getWorkItemsPreempted(), duccWorkJob.getSchedulingInfo().getWorkItemsPreempt())) {
            duccWorkJob.getSchedulingInfo().setWorkItemsPreempt(jdPreemptWorkItems);
        }
        IDuccSchedulingInfo si = duccWorkJob.getSchedulingInfo();
        si.setMostRecentWorkItemStart(jdStatusReport.getMostRecentStart());
        si.setPerWorkItemStatistics(jdStatusReport.getPerWorkItemStatistics());
        double avgTimeForWorkItemsSkewedByActive = jdStatusReport.getAvgTimeForWorkItemsSkewedByActive();
        si.setAvgTimeForWorkItemsSkewedByActive(avgTimeForWorkItemsSkewedByActive);
        logger.trace(methodName, null, new Object[]{this.messages.fetch("exit")});
        return retVal;
    }

    private void deallocate(IDuccWorkJob job, IResourceState.ProcessDeallocationType processDeallocationType, IProcessState.ProcessState processState, IDuccProcessMap processMap, String type) {
        String methodName = "deallocate";
        logger.trace(methodName, job.getDuccId(), new Object[]{this.messages.fetch("enter")});
        if (processMap != null) {
            Collection processCollection = processMap.values();
            for (IDuccProcess process : processCollection) {
                switch (process.getResourceState()) {
                    case Allocated: {
                        OrUtil.setResourceState(job, process, IResourceState.ResourceState.Deallocated);
                        process.setProcessDeallocationType(processDeallocationType);
                        logger.info(methodName, job.getDuccId(), process.getDuccId(), new Object[]{type});
                        if (processState == null) break;
                        logger.debug(methodName, job.getDuccId(), new Object[]{process.getProcessState() + " -> " + processState});
                        process.advanceProcessState(processState);
                        break;
                    }
                    case Deallocated: {
                        if (processState == null) break;
                        logger.debug(methodName, job.getDuccId(), new Object[]{process.getProcessState() + " -> " + processState});
                        process.advanceProcessState(processState);
                        break;
                    }
                }
            }
        }
        logger.trace(methodName, job.getDuccId(), new Object[]{this.messages.fetch("exit")});
    }

    private void deallocate(IDuccWorkJob job, IResourceState.ProcessDeallocationType processDeallocationType, IProcessState.ProcessState processState) {
        String methodName = "deallocate";
        logger.trace(methodName, job.getDuccId(), new Object[]{this.messages.fetch("enter")});
        this.deallocate(job, processDeallocationType, processState, job.getProcessMap(), "worker");
        switch (job.getDuccType()) {
            case Job: {
                this.deallocate(job, processDeallocationType, processState, job.getDriver().getProcessMap(), "driver");
                break;
            }
            case Service: {
                break;
            }
        }
        logger.trace(methodName, job.getDuccId(), new Object[]{this.messages.fetch("exit")});
    }

    public void deallocate(IDuccWorkJob job, IResourceState.ProcessDeallocationType processDeallocationType) {
        this.deallocate(job, processDeallocationType, null);
    }

    public void deallocateAndStop(IDuccWorkJob job, IResourceState.ProcessDeallocationType processDeallocationType) {
        this.deallocate(job, processDeallocationType, IProcessState.ProcessState.Stopped);
    }
}

