/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.orchestrator.state;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.uima.ducc.common.NodeIdentity;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.orchestrator.OrchestratorCommonArea;
import org.apache.uima.ducc.orchestrator.state.IOrchestratorState;
import org.apache.uima.ducc.orchestrator.state.OrchestratorStateJson;

public class OrchestratorStateFile
implements IOrchestratorState {
    private static DuccLogger logger = DuccLogger.getLogger(OrchestratorStateFile.class);
    private static DuccId jobid = null;
    private static OrchestratorCommonArea orchestratorCommonArea = OrchestratorCommonArea.getInstance();
    private static String jsonFileName = orchestratorCommonArea.getStateDirectory() + File.separator + "orchestrator-state.json";
    private static String propertiesFileName = orchestratorCommonArea.getStateDirectory() + File.separator + "orchestrator.properties";
    private static Gson gson = new Gson();
    private static OrchestratorStateFile instance = null;
    private AtomicLong seqNoPublication = new AtomicLong(-1L);
    private static final String constSeqNo = "seqno";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IOrchestratorState getInstance() {
        String location = "getInstance";
        Class<OrchestratorStateFile> clazz = OrchestratorStateFile.class;
        synchronized (OrchestratorStateFile.class) {
            logger.debug(location, jobid, new Object[]{"" + instance});
            if (instance == null) {
                instance = new OrchestratorStateFile();
                instance.initialize();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    private void initialize() {
        String location = "initialize";
        logger.debug(location, jobid, new Object[]{"" + instance});
        this.jsonImportState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getNextSequenceNumberState() {
        String location = "getNextSequenceNumberState";
        OrchestratorStateFile orchestratorStateFile = this;
        synchronized (orchestratorStateFile) {
            long value = this.seqNoPublication.incrementAndGet();
            this.jsonExportState();
            logger.debug(location, jobid, new Object[]{"" + this.seqNoPublication});
            return value;
        }
    }

    @Override
    public long getNextPublicationSequenceNumber() {
        return this.getNextSequenceNumberState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setNextSequenceNumberState(long value) {
        String location = "setNextSequenceNumberState";
        OrchestratorStateFile orchestratorStateFile = this;
        synchronized (orchestratorStateFile) {
            this.seqNoPublication.set(value);
            this.jsonExportState();
            logger.debug(location, jobid, new Object[]{"" + value});
        }
    }

    @Override
    public void setNextPublicationSequenceNumber(long seqNo) {
        this.setNextSequenceNumberState(seqNo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setNextSequenceNumberStateIfGreater(NodeIdentity nodeIdentity, long value) {
        String location = "setNextSequenceNumberStateIfGreater";
        OrchestratorStateFile orchestratorStateFile = this;
        synchronized (orchestratorStateFile) {
            long currentValue;
            String node = "?";
            if (nodeIdentity != null) {
                node = nodeIdentity.getCanonicalName();
            }
            if (value > (currentValue = this.seqNoPublication.get())) {
                this.setNextSequenceNumberState(value);
                logger.warn(location, jobid, new Object[]{"agent:" + node + " value:" + value + " or:" + currentValue});
            } else {
                logger.trace(location, jobid, new Object[]{"agent:" + node + " value:" + value + " or:" + currentValue});
            }
        }
    }

    @Override
    public void setNextPublicationSequenceNumberIfGreater(long value, NodeIdentity nodeIdentity) {
        this.setNextSequenceNumberStateIfGreater(nodeIdentity, value);
    }

    private void jsonCopy(OrchestratorStateJson importedState) {
        String location = "jsonCopy";
        if (importedState != null) {
            this.setNextSequenceNumberState(importedState.getSequenceNumberState());
        } else {
            logger.warn(location, jobid, new Object[]{"no previous state found"});
        }
    }

    private void jsonImportState() {
        String location = "jsonImportState";
        try {
            this.jsonImporter();
        }
        catch (Exception e) {
            logger.warn(location, jobid, (Throwable)e, new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jsonImporter() throws IOException {
        String location = "jsonImporter";
        InputStreamReader fr = null;
        BufferedReader br = null;
        try {
            logger.debug(location, jobid, new Object[]{jsonFileName});
            fr = new FileReader(jsonFileName);
            br = new BufferedReader(fr);
            Type typeOfMap = new TypeToken<OrchestratorStateJson>(){}.getType();
            OrchestratorStateJson importedState = (OrchestratorStateJson)gson.fromJson((Reader)br, typeOfMap);
            br.close();
            fr.close();
            this.jsonCopy(importedState);
        }
        finally {
            if (br != null) {
                br.close();
            }
            if (fr != null) {
                fr.close();
            }
        }
    }

    private void jsonExportState() {
        String location = "jsonExportState";
        try {
            this.jsonExporter();
        }
        catch (Exception e) {
            logger.error(location, jobid, (Throwable)e, new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jsonExporter() throws IOException {
        String location = "jsonExporter";
        try (OutputStreamWriter fw = null;){
            logger.debug(location, jobid, new Object[]{jsonFileName});
            OrchestratorStateJson orchestratorStateJson = new OrchestratorStateJson(this.seqNoPublication.get());
            String json = gson.toJson((Object)orchestratorStateJson);
            fw = new FileWriter(jsonFileName);
            fw.write(json);
            fw.close();
        }
    }

    @Override
    public long getDuccWorkSequenceNumber() {
        String location = "getDuccWorkSequenceNumber";
        long retVal = 0L;
        try {
            Properties properties = this.propertiesLoad();
            String key = constSeqNo;
            String value = properties.getProperty(key);
            retVal = Long.parseLong(value);
            logger.debug(location, jobid, new Object[]{key, value});
        }
        catch (Exception e) {
            logger.error(location, jobid, (Throwable)e, new Object[0]);
        }
        return retVal;
    }

    @Override
    public void setDuccWorkSequenceNumber(long seqNo) {
        String location = "setDuccWorkSequenceNumber";
        try {
            Properties properties = this.propertiesLoad();
            String key = constSeqNo;
            String value = "" + seqNo;
            properties.setProperty(key, value);
            this.propertiesStore(properties);
            logger.debug(location, jobid, new Object[]{key, value});
        }
        catch (Exception e) {
            logger.error(location, jobid, (Throwable)e, new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNextDuccWorkSequenceNumber() {
        String location = "getNextDuccWorkSequenceNumber";
        long retVal = 0L;
        OrchestratorStateFile orchestratorStateFile = this;
        synchronized (orchestratorStateFile) {
            try {
                long prev = this.getDuccWorkSequenceNumber();
                long next = prev + 1L;
                this.setDuccWorkSequenceNumber(next);
                retVal = next;
                logger.debug(location, jobid, new Object[]{retVal});
            }
            catch (Exception e) {
                logger.error(location, jobid, (Throwable)e, new Object[0]);
            }
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDuccWorkSequenceNumberIfGreater(long seqNo) {
        String location = "setDuccWorkSequenceNumberIfGreaterr";
        OrchestratorStateFile orchestratorStateFile = this;
        synchronized (orchestratorStateFile) {
            try {
                long prev = this.getDuccWorkSequenceNumber();
                if (seqNo > prev) {
                    this.setDuccWorkSequenceNumber(seqNo);
                    logger.debug(location, jobid, new Object[]{seqNo});
                }
            }
            catch (Exception e) {
                logger.error(location, jobid, (Throwable)e, new Object[0]);
            }
        }
    }

    private Properties propertiesLoad() {
        String location = "propertiesLoad";
        Properties properties = new Properties();
        try {
            FileInputStream fis = new FileInputStream(propertiesFileName);
            properties.load(fis);
            fis.close();
        }
        catch (Exception e) {
            logger.warn(location, jobid, (Throwable)e, new Object[0]);
        }
        return properties;
    }

    private void propertiesStore(Properties properties) {
        String location = "propertiesStore";
        try {
            FileOutputStream fos = new FileOutputStream(propertiesFileName);
            properties.store(fos, null);
            fos.close();
        }
        catch (Exception e) {
            logger.warn(location, jobid, (Throwable)e, new Object[0]);
        }
    }
}

