/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.orchestrator.system.events.log;

import java.util.List;
import java.util.Properties;
import org.apache.uima.ducc.common.admin.event.DuccAdminEvent;
import org.apache.uima.ducc.common.admin.event.RmAdminReply;
import org.apache.uima.ducc.common.utils.IDuccLoggerComponents;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.orchestrator.system.events.log.DuccLogger;
import org.apache.uima.ducc.transport.event.AServiceRequest;
import org.apache.uima.ducc.transport.event.AgentProcessLifecycleReportDuccEvent;
import org.apache.uima.ducc.transport.event.CancelJobDuccEvent;
import org.apache.uima.ducc.transport.event.CancelJobReplyDuccEvent;
import org.apache.uima.ducc.transport.event.CancelReservationDuccEvent;
import org.apache.uima.ducc.transport.event.CancelReservationReplyDuccEvent;
import org.apache.uima.ducc.transport.event.CancelServiceDuccEvent;
import org.apache.uima.ducc.transport.event.CancelServiceReplyDuccEvent;
import org.apache.uima.ducc.transport.event.DaemonDuccEvent;
import org.apache.uima.ducc.transport.event.DuccEvent;
import org.apache.uima.ducc.transport.event.IDuccContext;
import org.apache.uima.ducc.transport.event.ServiceReplyEvent;
import org.apache.uima.ducc.transport.event.SubmitJobDuccEvent;
import org.apache.uima.ducc.transport.event.SubmitJobReplyDuccEvent;
import org.apache.uima.ducc.transport.event.SubmitReservationDuccEvent;
import org.apache.uima.ducc.transport.event.SubmitReservationReplyDuccEvent;
import org.apache.uima.ducc.transport.event.SubmitServiceDuccEvent;
import org.apache.uima.ducc.transport.event.SubmitServiceReplyDuccEvent;
import org.apache.uima.ducc.transport.event.cli.JobReplyProperties;
import org.apache.uima.ducc.transport.event.cli.JobRequestProperties;
import org.apache.uima.ducc.transport.event.cli.ReservationReplyProperties;
import org.apache.uima.ducc.transport.event.cli.ReservationRequestProperties;
import org.apache.uima.ducc.transport.event.cli.ServiceReplyProperties;
import org.apache.uima.ducc.transport.event.cli.ServiceRequestProperties;
import org.apache.uima.ducc.transport.event.cli.SpecificationProperties;
import org.apache.uima.ducc.transport.event.common.IDuccProcess;
import org.apache.uima.ducc.transport.event.common.IDuccProcessType;
import org.apache.uima.ducc.transport.event.common.IDuccTypes;
import org.apache.uima.ducc.transport.event.common.IDuccWork;
import org.apache.uima.ducc.transport.event.common.IDuccWorkJob;
import org.apache.uima.ducc.transport.event.common.IDuccWorkReservation;
import org.apache.uima.ducc.transport.event.common.IDuccWorkService;
import org.apache.uima.ducc.transport.event.common.IRationale;

public class SystemEventsLogger {
    private static DuccLogger duccLogger = SystemEventsLogger.getEventLogger(SystemEventsLogger.class.getName());
    private static DuccId jobid = null;

    public static DuccLogger makeLogger(String claz, String componentId) {
        return DuccLogger.getLogger(claz, componentId);
    }

    public static DuccLogger getEventLogger(String claz) {
        return SystemEventsLogger.makeLogger("org.apache.uima.ducc.system.events.log", "event");
    }

    public static void warn(String daemon, String state, String text) {
        String user = System.getProperty("user.name");
        String type = state;
        Object[] event = new Object[]{};
        duccLogger.event_warn(daemon, user, type, event);
    }

    private static String getProperty(Properties properties, String key, String defaultValue) {
        String retVal = defaultValue;
        if (properties != null && key != null && properties.containsKey(key)) {
            retVal = properties.getProperty(key);
        }
        return retVal;
    }

    private static String getProperty(Properties properties, String key) {
        return SystemEventsLogger.getProperty(properties, key, "N/A");
    }

    private static boolean isTypeManagedReservation(String type) {
        boolean retVal = false;
        if (type != null) {
            if (type.equals(DuccEvent.EventType.SUBMIT_MANAGED_RESERVATION.toString())) {
                retVal = true;
            } else if (type.equals(DuccEvent.EventType.END_OF_MANAGED_RESERVATION.toString())) {
                retVal = true;
            } else if (type.equals(DuccEvent.EventType.CANCEL_MANAGED_RESERVATION.toString())) {
                retVal = true;
            }
        }
        return retVal;
    }

    private static String getType(String state, IDuccWorkJob job) {
        String type = state;
        if (type != null && type.equals("Completed")) {
            type = DuccEvent.EventType.END_OF_JOB.toString();
        }
        return type;
    }

    private static String getType(String state, IDuccWorkReservation reservation) {
        String type = state;
        if (type != null && type.equals("Completed")) {
            type = DuccEvent.EventType.END_OF_RESERVATION.toString();
        }
        return type;
    }

    private static String getType(String state, IDuccWorkService service) {
        IDuccWorkService.ServiceDeploymentType sdt;
        String type = state;
        if (type != null && type.equals("Completed") && (sdt = service.getServiceDeploymentType()) != null) {
            switch (sdt) {
                case other: {
                    type = DuccEvent.EventType.END_OF_MANAGED_RESERVATION.toString();
                    break;
                }
                default: {
                    type = DuccEvent.EventType.END_OF_SERVICE.toString();
                }
            }
        }
        return type;
    }

    private static String getType(SubmitServiceDuccEvent request) {
        String location = "getType.SubmitServiceDuccEvent";
        String type = request.getEventType().name();
        duccLogger.debug(location, jobid, (Object)((Object)Labels.TYPE) + type);
        IDuccContext.DuccContext context = request.getContext();
        if (context != null) {
            duccLogger.debug(location, jobid, (Object)((Object)Labels.CONTEXT) + "" + context);
            switch (context) {
                case ManagedReservation: {
                    type = DuccEvent.EventType.SUBMIT_MANAGED_RESERVATION.toString();
                    break;
                }
            }
        }
        return type;
    }

    private static String getType(CancelServiceDuccEvent request) {
        String type = request.getEventType().name();
        IDuccContext.DuccContext context = request.getContext();
        if (context != null) {
            switch (context) {
                case ManagedReservation: {
                    type = DuccEvent.EventType.CANCEL_MANAGED_RESERVATION.toString();
                    break;
                }
            }
        }
        return type;
    }

    public static void info(String daemon, String state, IDuccWork dw) {
        IDuccTypes.DuccType type = dw.getDuccType();
        if (type != null) {
            switch (type) {
                case Job: {
                    IDuccWorkJob job = (IDuccWorkJob)dw;
                    SystemEventsLogger.info(daemon, state, job);
                    break;
                }
                case Service: {
                    IDuccWorkService service = (IDuccWorkService)dw;
                    SystemEventsLogger.info(daemon, state, service);
                    break;
                }
                case Pop: {
                    IDuccWorkJob pop = (IDuccWorkJob)dw;
                    SystemEventsLogger.info(daemon, state, pop);
                    break;
                }
                case Reservation: {
                    IDuccWorkReservation reservation = (IDuccWorkReservation)dw;
                    SystemEventsLogger.info(daemon, state, reservation);
                    break;
                }
                case Undefined: {
                    IDuccWorkJob undefined = (IDuccWorkJob)dw;
                    SystemEventsLogger.info(daemon, state, undefined);
                    break;
                }
            }
        } else {
            IDuccWorkJob job = (IDuccWorkJob)dw;
            SystemEventsLogger.info(daemon, state, job);
        }
    }

    public static void info(String daemon, SubmitJobDuccEvent request, SubmitJobReplyDuccEvent response) {
        Properties qprops = request.getProperties();
        String submitter = SystemEventsLogger.getProperty(qprops, JobRequestProperties.key_submitter_pid_at_host);
        String user = SystemEventsLogger.getProperty(qprops, JobRequestProperties.key_user);
        String type = request.getEventType().name();
        String id = SystemEventsLogger.getProperty(qprops, JobRequestProperties.key_id);
        String sclass = SystemEventsLogger.getProperty(qprops, JobRequestProperties.key_scheduling_class);
        String size = SystemEventsLogger.getProperty(qprops, JobRequestProperties.key_process_memory_size);
        Properties rprops = response.getProperties();
        String message = SystemEventsLogger.getProperty(rprops, JobReplyProperties.key_message, "");
        Object[] event = new Object[]{(Object)((Object)Labels.JOB_ID) + id, (Object)((Object)Labels.CLASS) + sclass, (Object)((Object)Labels.SIZE) + size, (Object)((Object)Labels.SUBMITTER) + submitter, message};
        duccLogger.event_info(daemon, user, type, event);
        String key = SpecificationProperties.key_submit_errors;
        List value_submit_errors = (List)qprops.get(key);
        if (value_submit_errors != null && value_submit_errors.size() > 0) {
            message = (String)value_submit_errors.get(0);
            Object[] event_error = new Object[]{(Object)((Object)Labels.JOB_ID) + id, (Object)((Object)Labels.CLASS) + sclass, (Object)((Object)Labels.SIZE) + size, (Object)((Object)Labels.SUBMITTER) + submitter, message};
            duccLogger.event_info(daemon, user, type, event_error);
        }
    }

    public static void info(String daemon, CancelJobDuccEvent request, CancelJobReplyDuccEvent response) {
        Properties qprops = request.getProperties();
        String user = SystemEventsLogger.getProperty(qprops, JobRequestProperties.key_user);
        String submitter = SystemEventsLogger.getProperty(qprops, JobRequestProperties.key_submitter_pid_at_host);
        String type = request.getEventType().name();
        String id = SystemEventsLogger.getProperty(qprops, JobRequestProperties.key_id);
        Properties rprops = response.getProperties();
        String message = SystemEventsLogger.getProperty(rprops, JobReplyProperties.key_message);
        Object[] event = new Object[]{(Object)((Object)Labels.JOB_ID) + id, (Object)((Object)Labels.SUBMITTER) + submitter, message};
        duccLogger.event_info(daemon, user, type, event);
        String key = SpecificationProperties.key_submit_errors;
        List value_submit_errors = (List)qprops.get(key);
        if (value_submit_errors != null && value_submit_errors.size() > 0) {
            message = (String)value_submit_errors.get(0);
            Object[] event_error = new Object[]{(Object)((Object)Labels.JOB_ID) + id, (Object)((Object)Labels.SUBMITTER) + submitter, message};
            duccLogger.event_info(daemon, user, type, event_error);
        }
    }

    private static void info(String daemon, String state, IDuccWorkJob job) {
        String user = job.getStandardInfo().getUser();
        String type = SystemEventsLogger.getType(state, job);
        String id = job.getId();
        String reason = job.isCompleted() ? job.getCompletionType().name() : "";
        String rationale = "";
        IRationale completionRationale = job.getCompletionRationale();
        if (completionRationale != null) {
            rationale = completionRationale.getText();
        }
        Object[] event = new Object[]{(Object)((Object)Labels.JOB_ID) + id, reason, rationale};
        duccLogger.event_info(daemon, user, type, event);
    }

    public static void info(String daemon, SubmitReservationDuccEvent request, SubmitReservationReplyDuccEvent response) {
        Properties qprops = request.getProperties();
        String user = SystemEventsLogger.getProperty(qprops, ReservationRequestProperties.key_user);
        String submitter = SystemEventsLogger.getProperty(qprops, JobRequestProperties.key_submitter_pid_at_host);
        String type = request.getEventType().name();
        String id = SystemEventsLogger.getProperty(qprops, ReservationRequestProperties.key_id);
        String sclass = SystemEventsLogger.getProperty(qprops, ReservationRequestProperties.key_scheduling_class);
        String size = SystemEventsLogger.getProperty(qprops, ReservationRequestProperties.key_memory_size);
        Properties rprops = response.getProperties();
        String message = SystemEventsLogger.getProperty(rprops, ReservationReplyProperties.key_message, "");
        Object[] event = new Object[]{(Object)((Object)Labels.RESERVATION_ID) + id, (Object)((Object)Labels.CLASS) + sclass, (Object)((Object)Labels.SIZE) + size, (Object)((Object)Labels.SUBMITTER) + submitter, message};
        duccLogger.event_info(daemon, user, type, event);
        String key = SpecificationProperties.key_submit_errors;
        List value_submit_errors = (List)qprops.get(key);
        if (value_submit_errors != null && value_submit_errors.size() > 0) {
            message = (String)value_submit_errors.get(0);
            Object[] event_error = new Object[]{(Object)((Object)Labels.RESERVATION_ID) + id, (Object)((Object)Labels.CLASS) + sclass, (Object)((Object)Labels.SIZE) + size, (Object)((Object)Labels.SUBMITTER) + submitter, message};
            duccLogger.event_info(daemon, user, type, event_error);
        }
    }

    public static void info(String daemon, CancelReservationDuccEvent request, CancelReservationReplyDuccEvent response) {
        Properties qprops = request.getProperties();
        String user = SystemEventsLogger.getProperty(qprops, ReservationRequestProperties.key_user);
        String submitter = SystemEventsLogger.getProperty(qprops, JobRequestProperties.key_submitter_pid_at_host);
        String type = request.getEventType().name();
        String id = SystemEventsLogger.getProperty(qprops, ReservationRequestProperties.key_id);
        Properties rprops = response.getProperties();
        String message = SystemEventsLogger.getProperty(rprops, ReservationReplyProperties.key_message);
        Object[] event = new Object[]{(Object)((Object)Labels.RESERVATION_ID) + id, (Object)((Object)Labels.SUBMITTER) + submitter, message};
        duccLogger.event_info(daemon, user, type, event);
        String key = SpecificationProperties.key_submit_errors;
        List value_submit_errors = (List)qprops.get(key);
        if (value_submit_errors != null && value_submit_errors.size() > 0) {
            message = (String)value_submit_errors.get(0);
            Object[] event_error = new Object[]{(Object)((Object)Labels.RESERVATION_ID) + id, (Object)((Object)Labels.SUBMITTER) + submitter, message};
            duccLogger.event_info(daemon, user, type, event_error);
        }
    }

    private static void info(String daemon, String state, IDuccWorkReservation reservation) {
        String user = reservation.getStandardInfo().getUser();
        String type = SystemEventsLogger.getType(state, reservation);
        String id = reservation.getId();
        String reason = reservation.isCompleted() ? reservation.getCompletionType().name() : "";
        String rationale = "";
        IRationale completionRationale = reservation.getCompletionRationale();
        if (completionRationale != null) {
            rationale = completionRationale.getText();
        }
        Object[] event = new Object[]{(Object)((Object)Labels.RESERVATION_ID) + id, reason, rationale};
        duccLogger.event_info(daemon, user, type, event);
    }

    public static void info(String daemon, SubmitServiceDuccEvent request, SubmitServiceReplyDuccEvent response) {
        Properties properties = request.getProperties();
        String sclass = SystemEventsLogger.getProperty(properties, ServiceRequestProperties.key_scheduling_class);
        String size = SystemEventsLogger.getProperty(properties, ServiceRequestProperties.key_process_memory_size);
        Properties rprops = response.getProperties();
        String message = SystemEventsLogger.getProperty(rprops, ServiceReplyProperties.key_message, "");
        String user = SystemEventsLogger.getProperty(properties, ServiceRequestProperties.key_user);
        String submitter = SystemEventsLogger.getProperty(properties, JobRequestProperties.key_submitter_pid_at_host);
        String type = SystemEventsLogger.getType(request);
        if (SystemEventsLogger.isTypeManagedReservation(type)) {
            String id = SystemEventsLogger.getProperty(properties, ServiceRequestProperties.key_id);
            Object[] event = new Object[]{(Object)((Object)Labels.MANAGED_RESERVATION_ID) + id, (Object)((Object)Labels.CLASS) + sclass, (Object)((Object)Labels.SIZE) + size, (Object)((Object)Labels.SUBMITTER) + submitter, message};
            duccLogger.event_info(daemon, user, type, event);
            String key = SpecificationProperties.key_submit_errors;
            List value_submit_errors = (List)properties.get(key);
            if (value_submit_errors != null && value_submit_errors.size() > 0) {
                message = (String)value_submit_errors.get(0);
                Object[] event_error = new Object[]{(Object)((Object)Labels.MANAGED_RESERVATION_ID) + id, (Object)((Object)Labels.CLASS) + sclass, (Object)((Object)Labels.SIZE) + size, (Object)((Object)Labels.SUBMITTER) + submitter, message};
                duccLogger.event_info(daemon, user, type, event_error);
            }
        } else {
            String id = SystemEventsLogger.getProperty(properties, ServiceRequestProperties.key_service_id);
            String instance = SystemEventsLogger.getProperty(properties, ServiceRequestProperties.key_id);
            String name = SystemEventsLogger.getProperty(properties, ServiceRequestProperties.key_service_request_endpoint);
            Object[] event = new Object[]{(Object)((Object)Labels.SERVICE_ID) + id, (Object)((Object)Labels.INSTANCE_ID) + instance, (Object)((Object)Labels.NAME) + name, (Object)((Object)Labels.CLASS) + sclass, (Object)((Object)Labels.SIZE) + size, (Object)((Object)Labels.SUBMITTER) + submitter, message};
            duccLogger.event_info(daemon, user, type, event);
            String key = SpecificationProperties.key_submit_errors;
            List value_submit_errors = (List)properties.get(key);
            if (value_submit_errors != null && value_submit_errors.size() > 0) {
                message = (String)value_submit_errors.get(0);
                Object[] event_error = new Object[]{(Object)((Object)Labels.SERVICE_ID) + id, (Object)((Object)Labels.INSTANCE_ID) + instance, (Object)((Object)Labels.NAME) + name, (Object)((Object)Labels.CLASS) + sclass, (Object)((Object)Labels.SIZE) + size, (Object)((Object)Labels.SUBMITTER) + submitter, message};
                duccLogger.event_info(daemon, user, type, event_error);
            }
        }
    }

    public static void info(String daemon, CancelServiceDuccEvent request, CancelServiceReplyDuccEvent response) {
        Properties properties = request.getProperties();
        Properties rprops = response.getProperties();
        String message = SystemEventsLogger.getProperty(rprops, ReservationReplyProperties.key_message);
        String user = properties.getProperty(ServiceRequestProperties.key_user);
        String submitter = SystemEventsLogger.getProperty(properties, JobRequestProperties.key_submitter_pid_at_host);
        String type = SystemEventsLogger.getType(request);
        if (SystemEventsLogger.isTypeManagedReservation(type)) {
            String id = properties.getProperty(ServiceRequestProperties.key_id);
            Object[] event = new Object[]{(Object)((Object)Labels.MANAGED_RESERVATION_ID) + id, (Object)((Object)Labels.SUBMITTER) + submitter, message};
            duccLogger.event_info(daemon, user, type, event);
            String key = SpecificationProperties.key_submit_errors;
            List value_submit_errors = (List)properties.get(key);
            if (value_submit_errors != null && value_submit_errors.size() > 0) {
                message = (String)value_submit_errors.get(0);
                Object[] event_error = new Object[]{(Object)((Object)Labels.MANAGED_RESERVATION_ID) + id, (Object)((Object)Labels.SUBMITTER) + submitter, message};
                duccLogger.event_info(daemon, user, type, event_error);
            }
        } else {
            String id = SystemEventsLogger.getProperty(properties, ServiceRequestProperties.key_service_id);
            String instance = properties.getProperty(ServiceRequestProperties.key_id);
            String name = SystemEventsLogger.getProperty(properties, ServiceRequestProperties.key_service_request_endpoint);
            Object[] event = new Object[]{(Object)((Object)Labels.SERVICE_ID) + id, (Object)((Object)Labels.INSTANCE_ID) + instance, (Object)((Object)Labels.NAME) + name, (Object)((Object)Labels.SUBMITTER) + submitter, message};
            duccLogger.event_info(daemon, user, type, event);
            String key = SpecificationProperties.key_submit_errors;
            List value_submit_errors = (List)properties.get(key);
            if (value_submit_errors != null && value_submit_errors.size() > 0) {
                message = (String)value_submit_errors.get(0);
                Object[] event_error = new Object[]{(Object)((Object)Labels.SERVICE_ID) + id, (Object)((Object)Labels.INSTANCE_ID) + instance, (Object)((Object)Labels.NAME) + name, (Object)((Object)Labels.SUBMITTER) + submitter, message};
                duccLogger.event_info(daemon, user, type, event_error);
            }
        }
    }

    private static void info(String daemon, String state, IDuccWorkService service) {
        String user = service.getStandardInfo().getUser();
        String type = SystemEventsLogger.getType(state, service);
        if (SystemEventsLogger.isTypeManagedReservation(type)) {
            String id = service.getId();
            String reason = "";
            String rationale = "";
            Object[] event = new Object[]{(Object)((Object)Labels.MANAGED_RESERVATION_ID) + id, reason, rationale};
            duccLogger.event_info(daemon, user, type, event);
        } else {
            String id = service.getServiceId();
            String instance = service.getId();
            String name = service.getServiceEndpoint();
            String reason = "";
            String rationale = "";
            Object[] event = new Object[]{(Object)((Object)Labels.SERVICE_ID) + id, (Object)((Object)Labels.INSTANCE_ID) + instance, (Object)((Object)Labels.NAME) + name, reason, rationale};
            duccLogger.event_info(daemon, user, type, event);
        }
    }

    public static void info(String daemon, AServiceRequest request) {
        String user = request.getUser();
        String type = request.getEventType().name();
        String message = "request";
        Object[] event = new Object[]{message};
        duccLogger.event_info(daemon, user, type, event);
    }

    public static void info(String daemon, AServiceRequest request, ServiceReplyEvent response) {
        String user = request.getUser();
        String type = request.getEventType().name();
        String id = "" + response.getId();
        boolean rc = response.getReturnCode();
        String message = response.getMessage();
        Object[] event = new Object[]{(Object)((Object)Labels.SERVICE_ID) + id, (Object)((Object)Labels.RC) + "" + rc, message};
        duccLogger.event_info(daemon, user, type, event);
    }

    public static void info(String daemon, DuccAdminEvent request) {
        String user = request.getUser();
        String type = request.getClass().getSimpleName();
        String message = "request";
        Object[] event = new Object[]{message};
        duccLogger.event_info(daemon, user, type, event);
    }

    public static void info(String daemon, DuccAdminEvent request, RmAdminReply response) {
        String user = request.getUser();
        String type = request.getClass().getSimpleName();
        String message = SystemEventsLogger.normalize(response.getMessage());
        Object[] event = new Object[]{(Object)((Object)Labels.RESPONSE) + message};
        duccLogger.event_info(daemon, user, type, event);
    }

    private static String normalize(String message) {
        String text = "";
        if (message != null) {
            text = message.trim();
        }
        return text;
    }

    public static void info(DaemonDuccEvent dde) {
        String daemon = dde.getDaemon().getAbbrev();
        String user = System.getProperty("user.name");
        String type = dde.getEventType().name();
        Object[] event = new Object[]{(Object)((Object)Labels.NODE) + dde.getNodeIdentity().getCanonicalName(), (Object)((Object)Labels.TOD) + "" + dde.getTod()};
        duccLogger.event_info(daemon, user, type, event);
    }

    public static void warn(DaemonDuccEvent dde) {
        String daemon = dde.getDaemon().getAbbrev();
        String user = System.getProperty("user.name");
        String type = dde.getEventType().name();
        Object[] event = new Object[]{(Object)((Object)Labels.NODE) + dde.getNodeIdentity().getCanonicalName(), (Object)((Object)Labels.TOD) + "" + dde.getTod()};
        duccLogger.event_warn(daemon, user, type, event);
    }

    private static DerivedType getDerivedType(IDuccTypes.DuccType dwType, IDuccProcessType.ProcessType processType) {
        DerivedType dt = DerivedType.Undefined;
        if (dwType != null && processType != null) {
            block0 : switch (dwType) {
                case Job: {
                    switch (processType) {
                        case Pop: {
                            dt = DerivedType.JobDriver;
                            break block0;
                        }
                    }
                    dt = DerivedType.JobWorker;
                    break;
                }
                case Service: {
                    switch (processType) {
                        case Pop: {
                            dt = DerivedType.SingletonWorker;
                            break block0;
                        }
                    }
                    dt = DerivedType.ServiceWorker;
                    break;
                }
            }
        }
        return dt;
    }

    public static void info(IDuccWork dw, IDuccProcess process, String node, AgentProcessLifecycleReportDuccEvent.LifecycleEvent lifecycleEvent, IDuccProcessType.ProcessType processType) {
        String daemon = IDuccLoggerComponents.Daemon.Agent.getAbbrev();
        String user = dw.getStandardInfo().getUser();
        IDuccTypes.DuccType dwType = dw.getDuccType();
        DerivedType dt = SystemEventsLogger.getDerivedType(dwType, processType);
        String type = dt.getAlias();
        String dwid = dw.getDuccId().toString();
        String id = process.getDuccId().toString();
        switch (dt) {
            case JobDriver: 
            case JobWorker: {
                Object[] eventA = new Object[]{(Object)((Object)Labels.JOB_ID) + dwid, (Object)((Object)Labels.INSTANCE_ID) + id, (Object)((Object)Labels.NODE) + node, (Object)((Object)Labels.EVENT) + lifecycleEvent.toString()};
                duccLogger.event_info(daemon, user, type, eventA);
                break;
            }
            case SingletonWorker: {
                Object[] eventB = new Object[]{(Object)((Object)Labels.MANAGED_RESERVATION_ID) + dwid, (Object)((Object)Labels.INSTANCE_ID) + id, (Object)((Object)Labels.NODE) + node, (Object)((Object)Labels.EVENT) + lifecycleEvent.toString()};
                duccLogger.event_info(daemon, user, type, eventB);
                break;
            }
            case ServiceWorker: {
                IDuccWorkService service = (IDuccWorkService)dw;
                id = service.getServiceId();
                String instance = service.getId();
                String name = service.getServiceEndpoint();
                Object[] eventC = new Object[]{(Object)((Object)Labels.SERVICE_ID) + id, (Object)((Object)Labels.INSTANCE_ID) + instance, (Object)((Object)Labels.NAME) + name, (Object)((Object)Labels.NODE) + node, (Object)((Object)Labels.EVENT) + lifecycleEvent.toString()};
                duccLogger.event_info(daemon, user, type, eventC);
                break;
            }
            default: {
                Object[] eventD = new Object[]{(Object)((Object)Labels.OTHER_ID) + dwid, (Object)((Object)Labels.INSTANCE_ID) + id, (Object)((Object)Labels.NODE) + node, (Object)((Object)Labels.EVENT) + lifecycleEvent.toString()};
                duccLogger.event_info(daemon, user, type, eventD);
            }
        }
    }

    public static enum DerivedType {
        JobDriver("JobDriver"),
        JobWorker("JobProcess"),
        ServiceWorker("ServiceInstance"),
        SingletonWorker("ManagedReservation"),
        Undefined("Undefined");

        private String alias = null;

        private DerivedType(String alias) {
            this.setAlias(alias);
        }

        private void setAlias(String value) {
            this.alias = value;
        }

        public String getAlias() {
            return this.alias;
        }
    }

    private static enum Labels {
        JOB_ID("jid"),
        RESERVATION_ID("rid"),
        SERVICE_ID("sid"),
        INSTANCE_ID("iid"),
        MANAGED_RESERVATION_ID("mid"),
        OTHER_ID("oid"),
        CLASS("class"),
        CONTEXT("context"),
        EVENT("event"),
        NAME("name"),
        NODE("node"),
        RC("rc"),
        RESPONSE("response"),
        SIZE("size"),
        SUBMITTER("submitter"),
        TOD("tod"),
        TYPE("type");

        public String abbrv = null;

        private Labels(String abbreviation) {
            this.abbrv = abbreviation + ": ";
        }

        public String toString() {
            return this.abbrv;
        }
    }
}

