/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ws.db;

import java.util.HashMap;
import java.util.Map;
import org.apache.uima.ducc.common.db.DbHelper;
import org.apache.uima.ducc.common.persistence.rm.IRmPersistence;
import org.apache.uima.ducc.common.persistence.rm.RmPersistenceFactory;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.IDuccLoggerComponents;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.database.DbOrchestratorProperties;
import org.apache.uima.ducc.ws.db.DbMachine;
import org.apache.uima.ducc.ws.db.IDbMachine;

public class DbQuery {
    private static DuccLogger logger = DuccLogger.getLogger(DbQuery.class);
    private static DuccId jobid = null;
    private static DbQuery instance = null;
    private static boolean enabled = true;
    private static String component = IDuccLoggerComponents.abbrv_webServer;
    private IRmPersistence persistence = null;
    private DbOrchestratorProperties orProperties = null;

    private DbQuery() {
        this.init();
    }

    private void init() {
        String location = "init";
        try {
            enabled = DbHelper.isDbEnabled();
            this.persistence = RmPersistenceFactory.getInstance((String)this.getClass().getName(), (String)component);
            this.orProperties = new DbOrchestratorProperties(logger);
        }
        catch (Exception e) {
            logger.error(location, jobid, (Throwable)e, new Object[0]);
        }
    }

    public static DbQuery getInstance() {
        return instance;
    }

    public boolean isEnabled() {
        return enabled;
    }

    private boolean isAccessible() {
        String location = "isAccessible";
        boolean retVal = false;
        try {
            String seqno = this.orProperties.fetch(DbOrchestratorProperties.keys.publication_seqno.name());
            if (seqno != null) {
                retVal = true;
            }
        }
        catch (Exception e) {
            logger.debug(location, jobid, (Throwable)e, new Object[0]);
        }
        return retVal;
    }

    public boolean isUp() {
        return this.isAccessible();
    }

    public static void dumpMap(Map<String, IDbMachine> dbMachineMap) {
        String location = "dumpMap";
        if (dbMachineMap != null) {
            if (!dbMachineMap.isEmpty()) {
                for (Map.Entry<String, IDbMachine> entry : dbMachineMap.entrySet()) {
                    String key = entry.getKey();
                    String value = entry.getValue().getIp();
                    logger.debug(location, jobid, new Object[]{"host=" + key + " ip=" + value});
                }
            } else {
                logger.debug(location, jobid, new Object[]{"map is empty"});
            }
        } else {
            logger.debug(location, jobid, new Object[]{"map is null"});
        }
    }

    public Map<String, IDbMachine> getMapMachines() {
        HashMap<String, IDbMachine> retVal;
        block6: {
            String location = "getMapMachines";
            retVal = new HashMap<String, IDbMachine>();
            if (this.isEnabled()) {
                try {
                    Map state = this.persistence.getAllMachines();
                    if (!state.isEmpty()) {
                        for (String key : state.keySet()) {
                            Map entry = (Map)state.get(key);
                            DbMachine value = new DbMachine(entry);
                            retVal.put(key, value);
                        }
                        break block6;
                    }
                    logger.info(location, jobid, new Object[]{"map is empty"});
                }
                catch (Exception e) {
                    logger.error(location, jobid, (Throwable)e, new Object[0]);
                }
            } else {
                logger.info(location, jobid, new Object[]{"enabled=" + enabled});
            }
        }
        DbQuery.dumpMap(retVal);
        return retVal;
    }

    public void close() {
        if (this.persistence != null) {
            this.persistence.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Class<DbQuery> clazz = DbQuery.class;
        synchronized (DbQuery.class) {
            if (instance == null) {
                instance = new DbQuery();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }
}

