/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter;

import java.util.Collection;
import java.util.Iterator;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.util.ObjectHelper;

@Converter
public final class ObjectConverter {
    private ObjectConverter() {
    }

    public static boolean isCollection(Object value) {
        return value instanceof Collection || value != null && value.getClass().isArray();
    }

    @Converter
    public static boolean toBool(Object value) {
        Boolean answer = ObjectConverter.toBoolean(value);
        return answer != null && answer != false;
    }

    @Converter
    public static Boolean toBoolean(Object value) {
        return ObjectHelper.toBoolean(value);
    }

    @Converter
    public static Iterator<?> iterator(Object value) {
        return ObjectHelper.createIterator(value);
    }

    @Converter
    public static Iterable<?> iterable(Object value) {
        return ObjectHelper.createIterable(value);
    }

    @Converter
    public static Byte toByte(Object value) {
        if (value instanceof Byte) {
            return (Byte)value;
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return number.byteValue();
        }
        if (value instanceof String) {
            return Byte.valueOf((String)value);
        }
        return null;
    }

    @Converter
    public static char[] toCharArray(String value) {
        return value.toCharArray();
    }

    @Converter
    public static Character toCharacter(String value) {
        return Character.valueOf(ObjectConverter.toChar(value));
    }

    @Converter
    public static char toChar(String value) {
        if (value.length() != 1) {
            throw new IllegalArgumentException("String must have exactly a length of 1: " + value);
        }
        return value.charAt(0);
    }

    @Converter
    public static String fromCharArray(char[] value) {
        return new String(value);
    }

    @Converter
    public static Class<?> toClass(Object value, Exchange exchange) {
        if (value instanceof Class) {
            return (Class)value;
        }
        if (value instanceof String) {
            if (exchange != null) {
                return exchange.getContext().getClassResolver().resolveClass((String)value);
            }
            return ObjectHelper.loadClass((String)value);
        }
        return null;
    }

    @Converter
    public static Short toShort(Object value) {
        if (value instanceof Short) {
            return (Short)value;
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return number.shortValue();
        }
        if (value instanceof String) {
            return Short.valueOf((String)value);
        }
        return null;
    }

    @Converter
    public static Integer toInteger(Object value) {
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return number.intValue();
        }
        if (value instanceof String) {
            return Integer.valueOf((String)value);
        }
        return null;
    }

    @Converter
    public static Long toLong(Object value) {
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return number.longValue();
        }
        if (value instanceof String) {
            return Long.valueOf((String)value);
        }
        return null;
    }

    @Converter
    public static Float toFloat(Object value) {
        if (value instanceof Float) {
            return (Float)value;
        }
        if (value instanceof Number) {
            if (ObjectHelper.isNaN(value)) {
                return Float.valueOf(Float.NaN);
            }
            Number number = (Number)value;
            return Float.valueOf(number.floatValue());
        }
        if (value instanceof String) {
            return Float.valueOf((String)value);
        }
        return null;
    }

    @Converter
    public static Double toDouble(Object value) {
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Number) {
            if (ObjectHelper.isNaN(value)) {
                return Double.NaN;
            }
            Number number = (Number)value;
            return number.doubleValue();
        }
        if (value instanceof String) {
            return Double.valueOf((String)value);
        }
        return null;
    }

    @Converter
    public static String toString(Integer value) {
        return value.toString();
    }

    @Converter
    public static String toString(Long value) {
        return value.toString();
    }

    @Converter
    public static String toString(Boolean value) {
        return value.toString();
    }

    @Converter
    public static String toString(StringBuffer value) {
        return value.toString();
    }

    @Converter
    public static String toString(StringBuilder value) {
        return value.toString();
    }

    @Converter
    public static Integer toInteger(String value) {
        return Integer.valueOf(value);
    }

    @Converter
    public static Long toLong(String value) {
        return Long.valueOf(value);
    }

    @Converter
    public static Float toFloat(String value) {
        return Float.valueOf(value);
    }

    @Converter
    public static Double toDouble(String value) {
        return Double.valueOf(value);
    }

    @Converter
    public static Boolean toBoolean(String value) {
        return Boolean.parseBoolean(value);
    }
}

