/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.analysis_engine.metadata.AnalysisEngineMetaData;
import org.apache.uima.analysis_engine.metadata.FixedFlow;
import org.apache.uima.analysis_engine.metadata.FlowConstraints;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.flow.CasFlowController_ImplBase;
import org.apache.uima.flow.CasFlow_ImplBase;
import org.apache.uima.flow.FinalStep;
import org.apache.uima.flow.Flow;
import org.apache.uima.flow.FlowControllerContext;
import org.apache.uima.flow.SimpleStep;
import org.apache.uima.flow.Step;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.metadata.OperationalProperties;

public class FlowController
extends CasFlowController_ImplBase {
    private List<String> mSequence;
    private boolean mStartsWithCasMultiplier = false;
    private Type mWorkitemType;
    private Feature mSendToAllFeature;
    private Feature mSendToLastFeature;

    public void initialize(FlowControllerContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
        FlowConstraints flowConstraints = aContext.getAggregateMetadata().getFlowConstraints();
        this.mSequence = new ArrayList<String>();
        if (!(flowConstraints instanceof FixedFlow)) {
            throw new ResourceInitializationException("flow_controller_requires_flow_constraints", new Object[]{((Object)((Object)this)).getClass().getName(), "fixedFlow", aContext.getAggregateMetadata().getSourceUrlString()});
        }
        String[] sequence = ((FixedFlow)flowConstraints).getFixedFlow();
        this.mSequence.addAll(Arrays.asList(sequence));
        for (Map.Entry entry : this.getContext().getAnalysisEngineMetaDataMap().entrySet()) {
            AnalysisEngineMetaData md = (AnalysisEngineMetaData)entry.getValue();
            OperationalProperties op = md.getOperationalProperties();
            if (!op.getOutputsNewCASes() || !this.mSequence.get(0).equals(entry.getKey())) continue;
            this.mStartsWithCasMultiplier = true;
        }
    }

    public void typeSystemInit(TypeSystem aTypeSystem) throws AnalysisEngineProcessException {
        this.mWorkitemType = aTypeSystem.getType("org.apache.uima.ducc.Workitem");
        if (this.mWorkitemType == null) {
            throw new AnalysisEngineProcessException("annotator_ex_type_not_found", new Object[]{((Object)((Object)this)).getClass().getName(), "org.apache.uima.ducc.Workitem"});
        }
        this.mSendToAllFeature = this.mWorkitemType.getFeatureByBaseName("sendToAll");
        if (this.mSendToAllFeature == null) {
            throw new AnalysisEngineProcessException("annotator_ex_feature_not_found", new Object[]{((Object)((Object)this)).getClass().getName(), "org.apache.uima.ducc.Workitem:sendToAll"});
        }
        this.mSendToLastFeature = this.mWorkitemType.getFeatureByBaseName("sendToLast");
        if (this.mSendToLastFeature == null) {
            throw new AnalysisEngineProcessException("annotator_ex_feature_not_found", new Object[]{((Object)((Object)this)).getClass().getName(), "org.apache.uima.ducc.Workitem:sendToLast"});
        }
    }

    public Flow computeFlow(CAS aCAS) throws AnalysisEngineProcessException {
        return new FixedFlowObject(0);
    }

    class FixedFlowObject
    extends CasFlow_ImplBase {
        private int currentStep;
        private boolean internallyCreatedCas = false;

        private FixedFlowObject(int startStep) {
            this(startStep, false);
        }

        private FixedFlowObject(int startStep, boolean internallyCreatedCas) {
            this.currentStep = startStep;
            this.internallyCreatedCas = internallyCreatedCas;
        }

        public Step next() throws AnalysisEngineProcessException {
            if (FlowController.this.mStartsWithCasMultiplier && !this.internallyCreatedCas && this.currentStep == 1) {
                FSIterator it = this.getCas().getIndexRepository().getAllIndexedFS(FlowController.this.mWorkitemType);
                if (it.isValid()) {
                    FeatureStructure wi = it.get();
                    it.moveToNext();
                    if (it.isValid()) {
                        throw new IllegalStateException("More than one instance of Workitem type");
                    }
                    if (!wi.getBooleanValue(FlowController.this.mSendToAllFeature) && wi.getBooleanValue(FlowController.this.mSendToLastFeature)) {
                        this.currentStep = FlowController.this.mSequence.size() - 1;
                    }
                } else {
                    return new FinalStep();
                }
            }
            if (this.currentStep >= FlowController.this.mSequence.size()) {
                return new FinalStep();
            }
            return new SimpleStep((String)FlowController.this.mSequence.get(this.currentStep++));
        }

        public Flow newCasProduced(CAS newCas, String producedBy) throws AnalysisEngineProcessException {
            int i = 0;
            while (!((String)FlowController.this.mSequence.get(i)).equals(producedBy)) {
                ++i;
            }
            return new FixedFlowObject(i + 1, true);
        }
    }
}

