/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.transport.event;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.uima.ducc.common.Node;
import org.apache.uima.ducc.common.NodeIdentity;
import org.apache.uima.ducc.common.agent.metrics.memory.NodeMemory;
import org.apache.uima.ducc.common.node.metrics.NodeUsersInfo;
import org.apache.uima.ducc.transport.event.AbstractDuccEvent;
import org.apache.uima.ducc.transport.event.DuccEvent;
import org.apache.uima.ducc.transport.event.ProcessInfo;

public class NodeMetricsUpdateDuccEvent
extends AbstractDuccEvent {
    private static final long serialVersionUID = -1066240477810440223L;
    private Node node;
    private int processCount = 0;

    public NodeMetricsUpdateDuccEvent(Node node, int processCount) {
        super(DuccEvent.EventType.NODE_METRICS);
        this.node = node;
        this.processCount = processCount;
    }

    public Node getNode() {
        return this.node;
    }

    public NodeIdentity getNodeIdentity() {
        return this.node.getNodeIdentity();
    }

    public NodeMemory getNodeMemory() {
        return this.node.getNodeMetrics().getNodeMemory();
    }

    public TreeMap<String, NodeUsersInfo> getNodeUsersMap() {
        return this.node.getNodeMetrics().getNodeUsersMap();
    }

    public List<ProcessInfo> getRogueProcessInfoList() {
        ArrayList<ProcessInfo> retVal = new ArrayList<ProcessInfo>();
        TreeMap<String, NodeUsersInfo> nodeUsersMap = this.getNodeUsersMap();
        if (nodeUsersMap != null) {
            for (Map.Entry<String, NodeUsersInfo> entry : nodeUsersMap.entrySet()) {
                NodeUsersInfo nodeUsersInfo = entry.getValue();
                String uid = nodeUsersInfo.getUid();
                List rogueList = nodeUsersInfo.getRogueProcesses();
                for (NodeUsersInfo.NodeProcess rogue : rogueList) {
                    ProcessInfo processInfo = new ProcessInfo(uid, rogue.getPid(), rogue.isJava());
                    retVal.add(processInfo);
                }
            }
        }
        return retVal;
    }

    public int getProcessCount() {
        return this.processCount;
    }

    public boolean getCgroups() {
        return this.node.isCgroupEnabled();
    }

    public boolean getCgroupsCpuReportingEnabled() {
        return this.node.getNodeMetrics().isCpuReportingEnabled();
    }
}

