/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.transport.event.common.history;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import org.apache.uima.ducc.common.main.DuccService;
import org.apache.uima.ducc.common.utils.DuccLogger;

public class DeserializerObjectInputStream
extends ObjectInputStream {
    private DuccLogger logger = DuccService.getDuccLogger((String)DeserializerObjectInputStream.class.getName());

    protected DeserializerObjectInputStream(InputStream is) throws IOException, SecurityException {
        super(is);
    }

    @Override
    protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
        Class<?> localClass;
        String location = "readClassDescriptor";
        ObjectStreamClass resultClassDescriptor = super.readClassDescriptor();
        try {
            localClass = Class.forName(resultClassDescriptor.getName());
        }
        catch (ClassNotFoundException e) {
            String text = "No local class for " + resultClassDescriptor.getName();
            this.logger.error(location, null, new Object[]{text, e});
            return resultClassDescriptor;
        }
        ObjectStreamClass localClassDescriptor = ObjectStreamClass.lookup(localClass);
        if (localClassDescriptor != null) {
            long localSUID = localClassDescriptor.getSerialVersionUID();
            long streamSUID = resultClassDescriptor.getSerialVersionUID();
            if (streamSUID != localSUID) {
                StringBuffer sb = new StringBuffer("Overriding serialized class version mismatch: ");
                sb.append("local serialVersionUID = ").append(localSUID);
                sb.append(" stream serialVersionUID = ").append(streamSUID);
                this.logger.trace(location, null, new Object[]{sb});
                resultClassDescriptor = localClassDescriptor;
            }
        }
        return resultClassDescriptor;
    }
}

