/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ps.service.protocol.builtin;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.uima.UIMAFramework;
import org.apache.uima.ducc.ps.service.protocol.INoTaskAvailableStrategy;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;

public class WaitWithLockWhenNoTaskAvailable
implements INoTaskAvailableStrategy {
    private int waitTime;
    private final ReentrantLock lock = new ReentrantLock();
    Logger logger = UIMAFramework.getLogger(WaitWithLockWhenNoTaskAvailable.class);

    public WaitWithLockWhenNoTaskAvailable(int waitTimeInMillis) {
        this.waitTime = waitTimeInMillis;
        this.logger.log(Level.INFO, ">>>>>>>> Service Wait Time For Task:" + waitTimeInMillis + " ms");
    }

    @Override
    public void interrupt() {
        this.lock.unlock();
    }

    @Override
    public void handleNoTaskSupplied() {
        Condition waitAwhileCondition = this.lock.newCondition();
        try {
            this.lock.lock();
            if (this.waitTime > 0) {
                try {
                    waitAwhileCondition.await(this.waitTime, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    System.out.println("DefaultNoTaskAvailableStrategy.handleNoTaskSupplied() - Waiting interrupted  Thread:" + Thread.currentThread().getId());
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public long getWaitTimeInMillis() {
        return this.waitTime;
    }
}

