/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ps.service.transport.http;

import java.io.IOException;
import java.io.InvalidClassException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.NoRouteToHostException;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.NoHttpResponseException;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;
import org.apache.uima.UIMAFramework;
import org.apache.uima.ducc.ps.net.iface.IMetaTaskTransaction;
import org.apache.uima.ducc.ps.service.errors.ServiceException;
import org.apache.uima.ducc.ps.service.errors.ServiceInitializationException;
import org.apache.uima.ducc.ps.service.registry.IRegistryClient;
import org.apache.uima.ducc.ps.service.transport.IServiceTransport;
import org.apache.uima.ducc.ps.service.transport.ITargetURI;
import org.apache.uima.ducc.ps.service.transport.TransportException;
import org.apache.uima.ducc.ps.service.transport.TransportStats;
import org.apache.uima.ducc.ps.service.transport.XStreamUtils;
import org.apache.uima.ducc.ps.service.transport.target.NoOpTargetURI;
import org.apache.uima.ducc.ps.service.transport.target.TargetURIFactory;
import org.apache.uima.ducc.ps.service.utils.Utils;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;

public class HttpServiceTransport
implements IServiceTransport {
    private Logger logger = UIMAFramework.getLogger(HttpServiceTransport.class);
    private HttpClient httpClient = null;
    private PoolingHttpClientConnectionManager cMgr = null;
    private int clientMaxConnections = 1;
    private int clientMaxConnectionsPerRoute = 1;
    private int clientMaxConnectionsPerHostPort = 0;
    private ReentrantLock registryLookupLock = new ReentrantLock();
    private long threadSleepTime = 1000L;
    private final String nodeIP;
    private final String nodeName;
    private final String pid;
    private ITargetURI currentTargetUrl = new NoOpTargetURI();
    private static final String NA = "N/A";
    private TransportStats stats = new TransportStats();
    private IRegistryClient registryClient;
    private Map<Long, HttpPost> httpPostMap = new HashMap<Long, HttpPost>();
    private volatile boolean stopping = false;
    private volatile boolean running = false;
    private volatile boolean log = true;

    public HttpServiceTransport(IRegistryClient registryClient, int scaleout) throws ServiceException {
        this.registryClient = registryClient;
        this.clientMaxConnections = scaleout;
        if (Objects.isNull(System.getenv("DUCC_IP")) || Objects.isNull(System.getenv("DUCC_NODENAME"))) {
            try {
                this.nodeIP = InetAddress.getLocalHost().getHostAddress();
                this.nodeName = InetAddress.getLocalHost().getCanonicalHostName();
            }
            catch (UnknownHostException e) {
                throw new RuntimeException(new TransportException("HttpServiceTransport.ctor - Unable to determine Host Name and IP", e));
            }
        } else {
            this.nodeIP = System.getenv("DUCC_IP");
            this.nodeName = System.getenv("DUCC_NODENAME");
        }
        this.pid = this.getProcessIP(NA);
    }

    private HttpPost getPostMethodForCurrentThread() {
        HttpPost postMethod;
        if (!this.httpPostMap.containsKey(Thread.currentThread().getId())) {
            postMethod = new HttpPost(this.currentTargetUrl.asString());
            this.httpPostMap.put(Thread.currentThread().getId(), postMethod);
        } else {
            postMethod = this.httpPostMap.get(Thread.currentThread().getId());
        }
        return postMethod;
    }

    private String getProcessIP(String fallback) {
        String name = ManagementFactory.getRuntimeMXBean().getName();
        int pos = name.indexOf(64);
        if (pos < 1) {
            return fallback;
        }
        try {
            return Long.toString(Long.parseLong(name.substring(0, pos)));
        }
        catch (NumberFormatException numberFormatException) {
            return fallback;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lookupNewTarget() {
        this.registryLookupLock.lock();
        while (!this.stopping) {
            try {
                String newTarget = this.registryClient.lookUp(this.currentTargetUrl.asString());
                this.currentTargetUrl = TargetURIFactory.newTarget(newTarget);
                break;
            }
            catch (Exception e) {
                HttpClient httpClient = this.httpClient;
                synchronized (httpClient) {
                    try {
                        this.httpClient.wait(this.threadSleepTime);
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                        break;
                    }
                }
            }
        }
        if (this.registryLookupLock.isHeldByCurrentThread()) {
            this.registryLookupLock.unlock();
        }
    }

    @Override
    public void addRequestorInfo(IMetaTaskTransaction transaction) {
        transaction.setRequesterAddress(this.nodeIP);
        transaction.setRequesterNodeName(this.nodeName);
        transaction.setRequesterProcessId(Integer.valueOf(this.pid));
        transaction.setRequesterThreadId((int)Thread.currentThread().getId());
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "ip:" + transaction.getRequesterAddress());
            this.logger.log(Level.FINE, "nodeName:" + transaction.getRequesterNodeName());
            this.logger.log(Level.FINE, "processName:" + transaction.getRequesterProcessName());
            this.logger.log(Level.FINE, "processId:" + transaction.getRequesterProcessId());
            this.logger.log(Level.FINE, "threadId:" + transaction.getRequesterThreadId());
        }
    }

    @Override
    public void initialize() throws ServiceInitializationException {
        this.lookupNewTarget();
        this.cMgr = new PoolingHttpClientConnectionManager();
        if (this.clientMaxConnections > 0) {
            this.cMgr.setMaxTotal(this.clientMaxConnections);
        }
        if (this.clientMaxConnectionsPerRoute > 0) {
            this.cMgr.setDefaultMaxPerRoute(this.clientMaxConnectionsPerRoute);
        }
        HttpHost httpHost = new HttpHost(this.currentTargetUrl.asString(), Integer.valueOf(this.currentTargetUrl.getPort()).intValue(), this.currentTargetUrl.getContext());
        if (this.clientMaxConnectionsPerHostPort > 0) {
            this.cMgr.setMaxPerRoute(new HttpRoute(httpHost), this.clientMaxConnectionsPerHostPort);
        }
        this.httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)this.cMgr).build();
        this.running = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCommonHeaders(HttpPost method) {
        Class<HttpServiceTransport> clazz = HttpServiceTransport.class;
        synchronized (HttpServiceTransport.class) {
            method.setHeader("IP", this.nodeIP);
            method.setHeader("Hostname", this.nodeName);
            method.setHeader("ThreadID", String.valueOf(Thread.currentThread().getId()));
            method.setHeader("PID", this.pid);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private HttpEntity wrapRequest(String serializedRequest) {
        return new StringEntity(serializedRequest, ContentType.APPLICATION_XML);
    }

    private boolean isRunning() {
        return this.running;
    }

    private IMetaTaskTransaction retryUntilSuccessfull(String request, HttpPost postMethod) {
        IMetaTaskTransaction response = null;
        while (this.isRunning()) {
            try {
                response = this.doPost(postMethod);
                break;
            }
            catch (IOException | URISyntaxException | TransportException exx) {
                try {
                    Thread.sleep(this.threadSleepTime);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                this.lookupNewTarget();
            }
        }
        return response;
    }

    private IMetaTaskTransaction doPost(HttpPost postMethod) throws URISyntaxException, IOException, TransportException {
        postMethod.setURI(new URI(this.currentTargetUrl.asString()));
        IMetaTaskTransaction metaTransaction = null;
        HttpResponse response = this.httpClient.execute((HttpUriRequest)postMethod);
        HttpEntity entity = response.getEntity();
        String serializedResponse = EntityUtils.toString((HttpEntity)entity);
        Object transaction = null;
        try {
            transaction = XStreamUtils.unmarshall(serializedResponse);
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "Process Thread:" + Thread.currentThread().getId() + " Error while deserializing response with XStream", (Throwable)e);
            throw new TransportException(e);
        }
        if (Objects.isNull(transaction)) {
            throw new InvalidClassException("Expected IMetaTaskTransaction - Instead Received NULL");
        }
        if (!(transaction instanceof IMetaTaskTransaction)) {
            throw new InvalidClassException("Expected IMetaTaskTransaction - Instead Received " + transaction.getClass().getName());
        }
        metaTransaction = (IMetaTaskTransaction)transaction;
        StatusLine statusLine = response.getStatusLine();
        if (statusLine.getStatusCode() != 200) {
            throw new IOException("Unexpected HttpClient response status:" + statusLine + " Content causing error:" + serializedResponse);
        }
        this.stats.incrementSuccessCount();
        return metaTransaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized IMetaTaskTransaction dispatch(String serializedRequest) throws TransportException {
        IMetaTaskTransaction transaction = null;
        HttpEntity e = this.wrapRequest(serializedRequest);
        HttpPost postMethod = this.getPostMethodForCurrentThread();
        this.addCommonHeaders(postMethod);
        postMethod.setEntity(e);
        try {
            String simulatedException = System.getProperty("MockHttpPostError");
            if (simulatedException != null) {
                HttpClientExceptionGenerator mockExceptionGenerator = new HttpClientExceptionGenerator(simulatedException);
                mockExceptionGenerator.throwSimulatedException();
            } else {
                transaction = this.doPost(postMethod);
            }
        }
        catch (IOException | URISyntaxException ex) {
            if (this.stopping) {
                this.logger.log(Level.INFO, "Process Thread:" + Thread.currentThread().getId() + " - Process is already stopping - Caught Exception while calling doPost() \n" + ex);
                throw new TransportException(ex);
            }
            if (this.log) {
                this.log = false;
                this.stats.incrementErrorCount();
                this.logger.log(Level.WARNING, this.getClass().getName() + ".dispatch() >>>>>>>>>> Handling Exception \n" + ex);
                this.logger.log(Level.INFO, ">>>>>>>>>> Unable to communicate with target:" + this.currentTargetUrl.asString() + " - retrying until successfull - with " + this.threadSleepTime / 1000L + " seconds wait between retries  ");
            }
            transaction = this.retryUntilSuccessfull(serializedRequest, postMethod);
            this.log = true;
            this.logger.log(Level.INFO, "Established connection to target:" + this.currentTargetUrl.asString());
        }
        finally {
            postMethod.releaseConnection();
        }
        return transaction;
    }

    @Override
    public void stop(boolean quiesce) {
        this.stopping = true;
        this.running = false;
        System.out.println(Utils.getTimestamp() + ">>>>>>> " + Utils.getShortClassname(this.getClass()) + " stop() called - mode:" + (quiesce ? "quiesce" : "stop"));
        this.logger.log(Level.INFO, this.getClass().getName() + " stop() called");
        if (!quiesce && this.cMgr != null) {
            this.cMgr.shutdown();
            System.out.println(Utils.getTimestamp() + ">>>>>>> " + Utils.getShortClassname(this.getClass()) + " stopped connection mgr");
            this.logger.log(Level.INFO, this.getClass().getName() + " stopped connection mgr");
        }
    }

    public static void main(String[] args) {
    }

    public static class HttpClientExceptionGenerator {
        Exception exceptionClass = null;

        public HttpClientExceptionGenerator(String exc) {
            for (ERROR e : ERROR.values()) {
                if (exc == null || !e.name().equals(exc)) continue;
                switch (e) {
                    case IOException: {
                        this.exceptionClass = new IOException("Simulated IOException");
                        break;
                    }
                    case URISyntaxException: {
                        this.exceptionClass = new URISyntaxException("", "Simulated URISyntaxException");
                        break;
                    }
                    case NoRouteToHostException: {
                        this.exceptionClass = new NoRouteToHostException("Simulated NoRouteToHostException");
                        break;
                    }
                    case NoHttpResponseException: {
                        this.exceptionClass = new NoHttpResponseException("Simulated NoHttpResponseException");
                        break;
                    }
                    case SocketException: {
                        this.exceptionClass = new SocketException("Simulated SocketException");
                        break;
                    }
                    case UnknownHostException: {
                        this.exceptionClass = new UnknownHostException("Simulated UnknownHostException");
                        break;
                    }
                }
                if (this.exceptionClass != null) break;
            }
        }

        public void throwSimulatedException() throws IOException, URISyntaxException {
            if (this.exceptionClass != null) {
                if (this.exceptionClass instanceof IOException) {
                    throw (IOException)this.exceptionClass;
                }
                if (this.exceptionClass instanceof URISyntaxException) {
                    throw (URISyntaxException)this.exceptionClass;
                }
            }
        }

        public static enum ERROR {
            IOException,
            SocketException,
            UnknownHostException,
            NoRouteToHostException,
            NoHttpResponseException,
            HttpHostConnectException,
            URISyntaxException;

        }
    }
}

