/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.test.service;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import org.apache.uima.ducc.test.service.ServiceRegistry;

public class FileServiceRegistry
implements ServiceRegistry {
    String serviceName;
    Map<String, Map<String, String>> serviceNameMap = new HashMap<String, Map<String, String>>();
    Map<String, String> serviceMap;
    private File registryDir;
    private File serviceDir;
    static String[] badChars = new String[]{"%", "%25", "/", "%2F"};

    public static ServiceRegistry getInstance(String registryUrl) {
        if (registryUrl.startsWith("file://")) {
            return new FileServiceRegistry(registryUrl.substring(7));
        }
        System.err.println("EROR: Unsopprted registry URL: " + registryUrl);
        return null;
    }

    private FileServiceRegistry(String registerDirectory) {
        this.registryDir = new File(registerDirectory);
    }

    @Override
    public void setName(String serviceName) {
        this.serviceName = serviceName;
        this.serviceDir = new File(this.registryDir, this.encode(serviceName));
        if (!this.registryDir.exists()) {
            this.registryDir.mkdir();
        }
    }

    @Override
    public String register(String serviceAddress, String instanceId) {
        Throwable throwable;
        File instanceFile;
        String prevId = null;
        if (!this.serviceDir.exists()) {
            this.serviceDir.mkdir();
        }
        if ((instanceFile = new File(this.serviceDir, this.encode(serviceAddress))).exists()) {
            try {
                throwable = null;
                try (BufferedReader reader = new BufferedReader(new FileReader(instanceFile));){
                    prevId = reader.readLine();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (IOException e) {
                System.err.println("ERROR: Failed to read instanceId when updating registry file: " + instanceFile.getAbsolutePath() + " - " + e);
            }
        }
        try {
            throwable = null;
            try (PrintWriter writer = new PrintWriter(instanceFile);){
                writer.println(instanceId);
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("ERROR: Failed to create registry file: " + instanceFile.getAbsolutePath() + " - " + e);
        }
        return prevId;
    }

    @Override
    public String[] query() {
        if (!this.serviceDir.exists()) {
            return new String[0];
        }
        File[] files = this.serviceDir.listFiles();
        String[] addrs = new String[files.length];
        for (int i = 0; i < addrs.length; ++i) {
            addrs[i] = this.decode(files[i].getName());
        }
        return addrs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String unregister(String serviceAddress) {
        String instanceId = null;
        File instanceFile = new File(this.serviceDir, this.encode(serviceAddress));
        if (instanceFile.exists()) {
            try (BufferedReader reader = new BufferedReader(new FileReader(instanceFile));){
                instanceId = reader.readLine();
            }
            catch (IOException e) {
                System.err.println("ERROR: Failed to read instanceId from registry file: " + instanceFile.getAbsolutePath() + " - " + e);
            }
            finally {
                instanceFile.delete();
            }
            if (this.serviceDir.list().length == 0) {
                this.serviceDir.delete();
            }
        }
        return instanceId;
    }

    private String encode(String name) {
        for (int i = 0; i < badChars.length; i += 2) {
            name = name.replaceAll(badChars[i], badChars[i + 1]);
        }
        return name;
    }

    private String decode(String name) {
        for (int i = 0; i < badChars.length; i += 2) {
            name = name.replaceAll(badChars[i + 1], badChars[i]);
        }
        return name;
    }

    public static void main(String[] args) {
        int i;
        if (args.length != 3) {
            System.out.println("Usage: service-name address-prefix num");
            return;
        }
        FileServiceRegistry reg = new FileServiceRegistry("/users/burn/REGISTRY");
        reg.setName(args[0]);
        String[] addrs = reg.query();
        System.out.println("Service " + args[0] + " has " + addrs.length + " instances");
        int num = Integer.valueOf(args[2]);
        for (i = 0; i < num; ++i) {
            reg.register(args[1] + i, "100" + i);
            addrs = reg.query();
            System.out.println("Service " + args[0] + " has " + addrs.length + " instances");
            for (String addr : addrs) {
                System.out.println("   instance: " + addr);
            }
        }
        for (i = 0; i < num - 1; ++i) {
            String addr = args[1] + i;
            String prev = reg.unregister(addr);
            System.out.println("Unregistered " + addr + " was " + prev);
        }
    }
}

