/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import net.sf.saxon.Configuration;
import net.sf.saxon.Platform;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.sort.AtomicComparer;
import net.sf.saxon.sort.CalendarValueComparer;
import net.sf.saxon.sort.CodepointCollatingComparer;
import net.sf.saxon.sort.CodepointCollator;
import net.sf.saxon.sort.CollatingAtomicComparer;
import net.sf.saxon.sort.ComparisonKey;
import net.sf.saxon.sort.DecimalSortComparer;
import net.sf.saxon.sort.DoubleSortComparer;
import net.sf.saxon.sort.StringCollator;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.CalendarValue;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;

public class AtomicSortComparer
implements AtomicComparer {
    private StringCollator collator;
    private XPathContext conversionContext;
    private int itemType;
    public static StringValue COLLATION_KEY_NaN = new StringValue("NaN");

    public static AtomicComparer makeSortComparer(StringCollator stringCollator, int n, XPathContext xPathContext) {
        switch (n) {
            case 513: 
            case 529: 
            case 631: {
                if (stringCollator instanceof CodepointCollator) {
                    return CodepointCollatingComparer.getInstance();
                }
                return new CollatingAtomicComparer(stringCollator, Configuration.getPlatform());
            }
            case 515: 
            case 532: {
                return DecimalSortComparer.getInstance();
            }
            case 516: 
            case 517: 
            case 635: {
                return DoubleSortComparer.getInstance();
            }
            case 519: 
            case 520: 
            case 521: {
                return new CalendarValueComparer(xPathContext.getConfiguration());
            }
        }
        return new AtomicSortComparer(stringCollator, n, xPathContext);
    }

    private AtomicSortComparer(StringCollator stringCollator, int n, XPathContext xPathContext) {
        this.collator = stringCollator;
        if (stringCollator == null) {
            this.collator = CodepointCollator.getInstance();
        }
        this.conversionContext = xPathContext;
        this.itemType = n;
    }

    public StringCollator getStringCollator() {
        return this.collator;
    }

    public int getItemType() {
        return this.itemType;
    }

    public int compareAtomicValues(AtomicValue atomicValue, AtomicValue atomicValue2) {
        if (atomicValue == null) {
            if (atomicValue2 == null) {
                return 0;
            }
            return -1;
        }
        if (atomicValue2 == null) {
            return 1;
        }
        if (atomicValue instanceof UntypedAtomicValue) {
            return ((UntypedAtomicValue)atomicValue).compareTo(atomicValue2, this.collator, this.conversionContext);
        }
        if (atomicValue2 instanceof UntypedAtomicValue) {
            return -((UntypedAtomicValue)atomicValue2).compareTo(atomicValue, this.collator, this.conversionContext);
        }
        if (atomicValue instanceof NumericValue && ((NumericValue)atomicValue).isNaN()) {
            if (atomicValue2 instanceof NumericValue && ((NumericValue)atomicValue2).isNaN()) {
                return 0;
            }
            return -1;
        }
        if (atomicValue2 instanceof NumericValue && ((NumericValue)atomicValue2).isNaN()) {
            return 1;
        }
        if (atomicValue instanceof CalendarValue && atomicValue2 instanceof CalendarValue) {
            return ((CalendarValue)atomicValue).compareTo((CalendarValue)atomicValue2, this.conversionContext.getConfiguration());
        }
        if (atomicValue instanceof StringValue && atomicValue2 instanceof StringValue) {
            if (this.collator instanceof CodepointCollator) {
                return ((CodepointCollator)this.collator).compareCS(((StringValue)atomicValue).getStringValueCS(), ((StringValue)atomicValue2).getStringValueCS());
            }
            return this.collator.compareStrings(((StringValue)atomicValue).getStringValue(), ((StringValue)atomicValue2).getStringValue());
        }
        if (atomicValue instanceof StringValue || atomicValue2 instanceof StringValue) {
            if (atomicValue instanceof AtomicValue && atomicValue2 instanceof AtomicValue) {
                throw new ClassCastException("Values are not comparable (" + Type.displayTypeName(atomicValue) + ", " + Type.displayTypeName(atomicValue2) + ')');
            }
            throw new ClassCastException("Values are not comparable (" + atomicValue.getClass() + ", " + atomicValue2.getClass() + ')');
        }
        Comparable comparable = atomicValue.getXPathComparable();
        Comparable comparable2 = atomicValue2.getXPathComparable();
        if (comparable == null || comparable2 == null) {
            if (atomicValue instanceof AtomicValue && atomicValue2 instanceof AtomicValue) {
                throw new ClassCastException("Values are not comparable (" + Type.displayTypeName(atomicValue) + ", " + Type.displayTypeName(atomicValue2) + ')');
            }
            throw new ClassCastException("Values are not comparable (" + atomicValue.getClass() + ", " + atomicValue2.getClass() + ')');
        }
        return comparable.compareTo(comparable2);
    }

    public boolean comparesEqual(AtomicValue atomicValue, AtomicValue atomicValue2) {
        return this.compareAtomicValues(atomicValue, atomicValue2) == 0;
    }

    public ComparisonKey getComparisonKey(AtomicValue atomicValue) {
        AtomicValue atomicValue2 = atomicValue;
        Configuration configuration = this.conversionContext.getConfiguration();
        TypeHierarchy typeHierarchy = configuration.getTypeHierarchy();
        if (atomicValue2 instanceof NumericValue) {
            if (((NumericValue)atomicValue2).isNaN()) {
                return new ComparisonKey(635, COLLATION_KEY_NaN);
            }
            return new ComparisonKey(635, atomicValue2);
        }
        if (atomicValue2 instanceof StringValue) {
            Platform platform = Configuration.getPlatform();
            if (platform.canReturnCollationKeys(this.collator)) {
                return new ComparisonKey(513, this.collator.getCollationKey(((StringValue)atomicValue2).getStringValue(), platform));
            }
            return new ComparisonKey(513, atomicValue2);
        }
        if (atomicValue2 instanceof CalendarValue) {
            CalendarValue calendarValue = (CalendarValue)atomicValue2;
            if (calendarValue.hasTimezone()) {
                return new ComparisonKey(atomicValue2.getTypeLabel().getPrimitiveType(), atomicValue2);
            }
            calendarValue = (CalendarValue)calendarValue.copy(calendarValue.getTypeLabel());
            calendarValue.setTimezoneInMinutes(configuration.getImplicitTimezone());
            return new ComparisonKey(calendarValue.getTypeLabel().getPrimitiveType(), calendarValue);
        }
        if (atomicValue2 instanceof DurationValue) {
            return new ComparisonKey(518, atomicValue2);
        }
        return new ComparisonKey(atomicValue2.getTypeLabel().getPrimitiveType(), atomicValue2);
    }
}

