/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.fit.testing.junit;

import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.uima.UIMAException;
import org.apache.uima.fit.factory.JCasFactory;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;

public final class ManagedJCas
extends TestWatcher {
    private final ThreadLocal<JCas> casHolder;
    private static final Set<JCas> managedCases = Collections.synchronizedSet(Collections.newSetFromMap(new WeakHashMap()));

    public ManagedJCas() {
        this.casHolder = ThreadLocal.withInitial(() -> {
            try {
                JCas cas = JCasFactory.createJCas();
                managedCases.add(cas);
                return cas;
            }
            catch (UIMAException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public ManagedJCas(TypeSystemDescription aTypeSystemDescription) {
        this.casHolder = ThreadLocal.withInitial(() -> {
            try {
                JCas cas = JCasFactory.createJCas((TypeSystemDescription)aTypeSystemDescription);
                managedCases.add(cas);
                return cas;
            }
            catch (UIMAException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public JCas get() {
        return this.casHolder.get();
    }

    protected void starting(Description description) {
        managedCases.forEach(cas -> cas.reset());
    }
}

