/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast;

import com.strobel.core.VerifyArgument;
import com.strobel.decompiler.languages.java.ast.AstNode;
import com.strobel.decompiler.languages.java.ast.AstNodeCollection;
import com.strobel.decompiler.languages.java.ast.AstType;
import com.strobel.decompiler.languages.java.ast.BlockStatement;
import com.strobel.decompiler.languages.java.ast.IAstVisitor;
import com.strobel.decompiler.languages.java.ast.Identifier;
import com.strobel.decompiler.languages.java.ast.JavaTokenNode;
import com.strobel.decompiler.languages.java.ast.NodeType;
import com.strobel.decompiler.languages.java.ast.Roles;
import com.strobel.decompiler.languages.java.ast.TokenRole;
import com.strobel.decompiler.patterns.BacktrackingInfo;
import com.strobel.decompiler.patterns.INode;
import com.strobel.decompiler.patterns.Match;
import com.strobel.decompiler.patterns.Pattern;
import com.strobel.decompiler.patterns.Role;

public class CatchClause
extends AstNode {
    public static final TokenRole CATCH_KEYWORD_ROLE = new TokenRole("catch", 1);

    public CatchClause() {
    }

    public CatchClause(BlockStatement body) {
        this.setBody(body);
    }

    public final JavaTokenNode getCatchToken() {
        return this.getChildByRole(CATCH_KEYWORD_ROLE);
    }

    public final JavaTokenNode getLeftParenthesisToken() {
        return this.getChildByRole(Roles.LEFT_PARENTHESIS);
    }

    public final JavaTokenNode getRightParenthesisToken() {
        return this.getChildByRole(Roles.RIGHT_PARENTHESIS);
    }

    public final AstNodeCollection<AstType> getExceptionTypes() {
        return this.getChildrenByRole(Roles.TYPE);
    }

    public final String getVariableName() {
        return this.getChildByRole(Roles.IDENTIFIER).getName();
    }

    public final void setVariableName(String value) {
        this.setChildByRole(Roles.IDENTIFIER, Identifier.create(value));
    }

    public final Identifier getVariableNameToken() {
        return this.getChildByRole(Roles.IDENTIFIER);
    }

    public final void setVariableNameToken(Identifier value) {
        this.setChildByRole(Roles.IDENTIFIER, value);
    }

    public final BlockStatement getBody() {
        return this.getChildByRole(Roles.BODY);
    }

    public final void setBody(BlockStatement value) {
        this.setChildByRole(Roles.BODY, value);
    }

    @Override
    public <T, R> R acceptVisitor(IAstVisitor<? super T, ? extends R> visitor, T data) {
        return visitor.visitCatchClause(this, data);
    }

    public Role<? extends CatchClause> getRole() {
        return super.getRole();
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.UNKNOWN;
    }

    @Override
    public boolean matches(INode other, Match match) {
        if (other instanceof CatchClause) {
            CatchClause otherClause = (CatchClause)other;
            return !otherClause.isNull() && this.getExceptionTypes().matches(otherClause.getExceptionTypes(), match) && CatchClause.matchString(this.getVariableName(), otherClause.getVariableName()) && this.getBody().matches(otherClause.getBody(), match);
        }
        return false;
    }

    public static CatchClause forPattern(Pattern pattern) {
        return new PatternPlaceholder((Pattern)VerifyArgument.notNull((Object)pattern, (String)"pattern"));
    }

    private static final class PatternPlaceholder
    extends CatchClause {
        final Pattern child;

        PatternPlaceholder(Pattern child) {
            this.child = child;
        }

        @Override
        public NodeType getNodeType() {
            return NodeType.PATTERN;
        }

        @Override
        public <T, R> R acceptVisitor(IAstVisitor<? super T, ? extends R> visitor, T data) {
            return visitor.visitPatternPlaceholder(this, this.child, data);
        }

        @Override
        public boolean matchesCollection(Role role, INode position, Match match, BacktrackingInfo backtrackingInfo) {
            return this.child.matchesCollection(role, position, match, backtrackingInfo);
        }

        @Override
        public boolean matches(INode other, Match match) {
            return this.child.matches(other, match);
        }
    }
}

