/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.coordinator.web.resource;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import org.apache.hbase.thirdparty.javax.ws.rs.GET;
import org.apache.hbase.thirdparty.javax.ws.rs.Path;
import org.apache.hbase.thirdparty.javax.ws.rs.Produces;
import org.apache.hbase.thirdparty.javax.ws.rs.core.Context;
import org.apache.uniffle.common.config.RssBaseConf;
import org.apache.uniffle.common.util.RssUtils;
import org.apache.uniffle.coordinator.CoordinatorConf;
import org.apache.uniffle.coordinator.CoordinatorServer;
import org.apache.uniffle.coordinator.web.Response;
import org.apache.uniffle.coordinator.web.resource.BaseResource;
import org.apache.uniffle.coordinator.web.vo.CoordinatorConfVO;

@Produces(value={"application/json"})
public class CoordinatorServerResource
extends BaseResource {
    @Context
    protected ServletContext servletContext;

    @GET
    @Path(value="/conf")
    public Response<List<CoordinatorConfVO>> getCoordinatorConf() {
        return this.execute(() -> {
            CoordinatorConf coordinatorConf = this.getCoordinatorServer().getCoordinatorConf();
            Set allEntry = coordinatorConf.getAll();
            ArrayList<CoordinatorConfVO> coordinatorConfVOs = new ArrayList<CoordinatorConfVO>();
            for (Map.Entry stringObjectEntry : allEntry) {
                CoordinatorConfVO result = new CoordinatorConfVO((String)stringObjectEntry.getKey(), String.valueOf(stringObjectEntry.getValue()));
                coordinatorConfVOs.add(result);
            }
            return coordinatorConfVOs;
        });
    }

    @GET
    @Path(value="/info")
    public Response<Map<String, String>> getCoordinatorInfo() {
        return this.execute(() -> {
            CoordinatorConf coordinatorConf = this.getCoordinatorServer().getCoordinatorConf();
            HashMap<String, String> coordinatorServerInfo = new HashMap<String, String>();
            coordinatorServerInfo.put("coordinatorId", coordinatorConf.getString("coordinator.id", "none"));
            coordinatorServerInfo.put("serverIp", RssUtils.getHostIp());
            coordinatorServerInfo.put("serverPort", String.valueOf(coordinatorConf.getInteger("rss.rpc.server.port", 0)));
            coordinatorServerInfo.put("serverWebPort", String.valueOf(coordinatorConf.get(RssBaseConf.JETTY_HTTP_PORT)));
            return coordinatorServerInfo;
        });
    }

    private CoordinatorServer getCoordinatorServer() {
        return (CoordinatorServer)((Object)this.servletContext.getAttribute(CoordinatorServer.class.getCanonicalName()));
    }
}

