/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy.txn.xa;

import com.hazelcast.client.connection.nio.ClientConnection;
import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.proxy.txn.ClientTxnListProxy;
import com.hazelcast.client.proxy.txn.ClientTxnMapProxy;
import com.hazelcast.client.proxy.txn.ClientTxnMultiMapProxy;
import com.hazelcast.client.proxy.txn.ClientTxnProxy;
import com.hazelcast.client.proxy.txn.ClientTxnQueueProxy;
import com.hazelcast.client.proxy.txn.ClientTxnSetProxy;
import com.hazelcast.client.proxy.txn.xa.XATransactionProxy;
import com.hazelcast.client.spi.ClientTransactionContext;
import com.hazelcast.client.spi.impl.ClientTransactionManagerServiceImpl;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.TransactionalList;
import com.hazelcast.core.TransactionalMap;
import com.hazelcast.core.TransactionalMultiMap;
import com.hazelcast.core.TransactionalQueue;
import com.hazelcast.core.TransactionalSet;
import com.hazelcast.transaction.TransactionException;
import com.hazelcast.transaction.TransactionNotActiveException;
import com.hazelcast.transaction.TransactionalObject;
import com.hazelcast.transaction.impl.Transaction;
import com.hazelcast.transaction.impl.TransactionalObjectKey;
import java.util.HashMap;
import java.util.Map;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class XATransactionContextProxy
implements ClientTransactionContext {
    final ClientTransactionManagerServiceImpl transactionManager;
    final HazelcastClientInstanceImpl client;
    final XATransactionProxy transaction;
    final ClientConnection connection;
    private final Map<TransactionalObjectKey, TransactionalObject> txnObjectMap = new HashMap<TransactionalObjectKey, TransactionalObject>(2);

    public XATransactionContextProxy(ClientTransactionManagerServiceImpl transactionManager, Xid xid, int timeout) {
        this.transactionManager = transactionManager;
        this.client = transactionManager.getClient();
        try {
            this.connection = transactionManager.connect();
        }
        catch (Exception e) {
            throw new HazelcastException("Could not obtain Connection!", e);
        }
        this.transaction = new XATransactionProxy(this.client, this.connection, xid, timeout);
    }

    @Override
    public void beginTransaction() {
        throw new UnsupportedOperationException("XA Transaction cannot be started manually!");
    }

    @Override
    public void commitTransaction() throws TransactionException {
        throw new UnsupportedOperationException("XA Transaction cannot be committed manually!");
    }

    @Override
    public void rollbackTransaction() {
        throw new UnsupportedOperationException("XA Transaction cannot be rolled back manually!");
    }

    @Override
    public String getTxnId() {
        return this.transaction.getTxnId();
    }

    @Override
    public HazelcastClientInstanceImpl getClient() {
        return this.client;
    }

    @Override
    public ClientConnection getConnection() {
        return this.connection;
    }

    @Override
    public <K, V> TransactionalMap<K, V> getMap(String name) {
        return (TransactionalMap)this.getTransactionalObject("hz:impl:mapService", name);
    }

    @Override
    public <E> TransactionalQueue<E> getQueue(String name) {
        return (TransactionalQueue)this.getTransactionalObject("hz:impl:queueService", name);
    }

    @Override
    public <K, V> TransactionalMultiMap<K, V> getMultiMap(String name) {
        return (TransactionalMultiMap)this.getTransactionalObject("hz:impl:multiMapService", name);
    }

    @Override
    public <E> TransactionalList<E> getList(String name) {
        return (TransactionalList)this.getTransactionalObject("hz:impl:listService", name);
    }

    @Override
    public <E> TransactionalSet<E> getSet(String name) {
        return (TransactionalSet)this.getTransactionalObject("hz:impl:setService", name);
    }

    @Override
    public <T extends TransactionalObject> T getTransactionalObject(String serviceName, String name) {
        if (this.transaction.getState() != Transaction.State.ACTIVE) {
            throw new TransactionNotActiveException("No transaction is found while accessing transactional object -> " + serviceName + "[" + name + "]!");
        }
        TransactionalObjectKey key = new TransactionalObjectKey(serviceName, name);
        ClientTxnProxy obj = this.txnObjectMap.get(key);
        if (obj == null) {
            if (serviceName.equals("hz:impl:queueService")) {
                obj = new ClientTxnQueueProxy(name, this);
            } else if (serviceName.equals("hz:impl:mapService")) {
                obj = new ClientTxnMapProxy(name, this);
            } else if (serviceName.equals("hz:impl:multiMapService")) {
                obj = new ClientTxnMultiMapProxy(name, this);
            } else if (serviceName.equals("hz:impl:listService")) {
                obj = new ClientTxnListProxy(name, this);
            } else if (serviceName.equals("hz:impl:setService")) {
                obj = new ClientTxnSetProxy(name, this);
            }
            if (obj == null) {
                throw new IllegalArgumentException("Service[" + serviceName + "] is not transactional!");
            }
            this.txnObjectMap.put(key, obj);
        }
        return (T)obj;
    }

    public XATransactionProxy getTransaction() {
        return this.transaction;
    }

    @Override
    public XAResource getXaResource() {
        throw new UnsupportedOperationException("Use HazelcastInstance.getXAResource() instead!");
    }
}

