/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.internal.convert;

import java.io.InputStream;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.Comparator;
import java.util.Currency;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.money.CurrencyContextBuilder;
import javax.money.CurrencyUnit;
import javax.money.Monetary;
import javax.money.MonetaryException;
import javax.money.convert.ConversionContext;
import javax.money.convert.ConversionQuery;
import javax.money.convert.ExchangeRate;
import javax.money.convert.ProviderContext;
import org.javamoney.moneta.CurrencyUnitBuilder;
import org.javamoney.moneta.convert.ExchangeRateBuilder;
import org.javamoney.moneta.internal.convert.IMFRateProvider;
import org.javamoney.moneta.internal.convert.IMFRateReadingHandler;
import org.javamoney.moneta.spi.AbstractRateProvider;
import org.javamoney.moneta.spi.LoaderService;

abstract class IMFAbstractRateProvider
extends AbstractRateProvider
implements LoaderService.LoaderListener {
    private static final Logger LOG = Logger.getLogger(IMFAbstractRateProvider.class.getName());
    static final Comparator<ExchangeRate> COMPARATOR_EXCHANGE_BY_LOCAL_DATE = Comparator.comparing(c -> (LocalDate)c.getContext().get(LocalDate.class));
    protected static final Map<String, CurrencyUnit> CURRENCIES_BY_NAME = new HashMap<String, CurrencyUnit>();
    protected static final CurrencyUnit SDR = CurrencyUnitBuilder.of("SDR", CurrencyContextBuilder.of((String)IMFRateProvider.class.getSimpleName()).build()).setDefaultFractionDigits(3).build(true);
    protected Map<CurrencyUnit, List<ExchangeRate>> currencyToSdr = Collections.emptyMap();
    protected Map<CurrencyUnit, List<ExchangeRate>> sdrToCurrency = Collections.emptyMap();
    protected final IMFRateReadingHandler handler;
    private final ProviderContext context;

    public IMFAbstractRateProvider(ProviderContext providerContext) {
        super(providerContext);
        this.context = providerContext;
        this.handler = new IMFRateReadingHandler(CURRENCIES_BY_NAME, this.context);
    }

    @Override
    public void newDataLoaded(String resourceId, InputStream is) {
        try {
            IMFRateReadingHandler.RateIMFResult result = this.handler.read(is);
            this.sdrToCurrency = result.getSdrToCurrency();
            this.currencyToSdr = result.getCurrencyToSdr();
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Error", e);
        }
    }

    @Override
    public ExchangeRate getExchangeRate(ConversionQuery conversionQuery) {
        if (!this.isAvailable(conversionQuery)) {
            return null;
        }
        CurrencyUnit base = conversionQuery.getBaseCurrency();
        CurrencyUnit term = conversionQuery.getCurrency();
        LocalDate[] times = this.getQueryDates(conversionQuery);
        ExchangeRate rate1 = this.getExchangeRate(this.currencyToSdr.get(base), times);
        ExchangeRate rate2 = this.getExchangeRate(this.sdrToCurrency.get(term), times);
        if (base.equals(SDR)) {
            return rate2;
        }
        if (term.equals(SDR)) {
            return rate1;
        }
        if (Objects.isNull(rate1) || Objects.isNull(rate2)) {
            return null;
        }
        ConversionContext context = this.getExchangeContext("imf.digit.fraction");
        ExchangeRateBuilder builder = new ExchangeRateBuilder(context);
        builder.setBase(base);
        builder.setTerm(term);
        builder.setFactor(IMFAbstractRateProvider.multiply(rate1.getFactor(), rate2.getFactor()));
        builder.setRateChain(rate1, rate2);
        return builder.build();
    }

    private ExchangeRate getExchangeRate(List<ExchangeRate> rates, LocalDate[] dates) {
        if (Objects.isNull(rates)) {
            return null;
        }
        if (Objects.isNull(dates)) {
            return rates.stream().sorted(COMPARATOR_EXCHANGE_BY_LOCAL_DATE.reversed()).findFirst().orElseThrow(() -> new MonetaryException("There is not more recent exchange rate to  rate on IMFRateProvider."));
        }
        for (LocalDate localDate : dates) {
            Predicate<ExchangeRate> filter = rate -> ((LocalDate)rate.getContext().get(LocalDate.class)).equals(localDate);
            Optional<ExchangeRate> exchangeRateOptional = rates.stream().filter(filter).findFirst();
            if (!exchangeRateOptional.isPresent()) continue;
            return exchangeRateOptional.get();
        }
        String datesOnErros = Stream.of(dates).map(date -> date.format(DateTimeFormatter.ISO_LOCAL_DATE)).collect(Collectors.joining(","));
        throw new MonetaryException("There is not exchange on day " + datesOnErros + " to rate to  rate on IFMRateProvider.");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName()).append('{').append(" context: ").append(this.context).append('}');
        return sb.toString();
    }

    static {
        for (Currency currency : Currency.getAvailableCurrencies()) {
            CURRENCIES_BY_NAME.put(currency.getDisplayName(Locale.ENGLISH), Monetary.getCurrency((String)currency.getCurrencyCode(), (String[])new String[0]));
        }
        CURRENCIES_BY_NAME.put("U.K. Pound Sterling", Monetary.getCurrency((String)"GBP", (String[])new String[0]));
        CURRENCIES_BY_NAME.put("U.S. Dollar", Monetary.getCurrency((String)"USD", (String[])new String[0]));
        CURRENCIES_BY_NAME.put("Bahrain Dinar", Monetary.getCurrency((String)"BHD", (String[])new String[0]));
        CURRENCIES_BY_NAME.put("Botswana Pula", Monetary.getCurrency((String)"BWP", (String[])new String[0]));
        CURRENCIES_BY_NAME.put("Czech Koruna", Monetary.getCurrency((String)"CZK", (String[])new String[0]));
        CURRENCIES_BY_NAME.put("Icelandic Krona", Monetary.getCurrency((String)"ISK", (String[])new String[0]));
        CURRENCIES_BY_NAME.put("Korean Won", Monetary.getCurrency((String)"KRW", (String[])new String[0]));
        CURRENCIES_BY_NAME.put("Rial Omani", Monetary.getCurrency((String)"OMR", (String[])new String[0]));
        CURRENCIES_BY_NAME.put("Nuevo Sol", Monetary.getCurrency((String)"PEN", (String[])new String[0]));
        CURRENCIES_BY_NAME.put("Qatar Riyal", Monetary.getCurrency((String)"QAR", (String[])new String[0]));
        CURRENCIES_BY_NAME.put("Saudi Arabian Riyal", Monetary.getCurrency((String)"SAR", (String[])new String[0]));
        CURRENCIES_BY_NAME.put("Sri Lanka Rupee", Monetary.getCurrency((String)"LKR", (String[])new String[0]));
        CURRENCIES_BY_NAME.put("Trinidad And Tobago Dollar", Monetary.getCurrency((String)"TTD", (String[])new String[0]));
        CURRENCIES_BY_NAME.put("U.A.E. Dirham", Monetary.getCurrency((String)"AED", (String[])new String[0]));
        CURRENCIES_BY_NAME.put("Peso Uruguayo", Monetary.getCurrency((String)"UYU", (String[])new String[0]));
        CURRENCIES_BY_NAME.put("Bolivar Fuerte", Monetary.getCurrency((String)"VEF", (String[])new String[0]));
    }
}

