/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.cellar.bundle.shell;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.karaf.cellar.bundle.BundleState;
import org.apache.karaf.cellar.bundle.shell.BundleCommandSupport;
import org.apache.karaf.cellar.core.CellarSupport;
import org.apache.karaf.cellar.core.Group;
import org.apache.karaf.cellar.core.event.EventType;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.table.ShellTable;

@Command(scope="cluster", name="bundle-list", description="List the bundles in a cluster group")
@Service
public class ListBundleCommand
extends BundleCommandSupport {
    @Option(name="-s", aliases={}, description="Shows the symbolic name", required=false, multiValued=false)
    boolean showSymbolicName;
    @Option(name="-l", aliases={}, description="Shows the location", required=false, multiValued=false)
    boolean showLocation;
    @Option(name="--cluster", description="Shows only bundles on the cluster", required=false, multiValued=false)
    boolean onlyCluster;
    @Option(name="--local", description="Shows only bundles on the local node", required=false, multiValued=false)
    boolean onlyLocal;
    @Option(name="--blocked", description="Shows only blocked bundles", required=false, multiValued=false)
    boolean onlyBlocked;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object doExecute() throws Exception {
        Group group = this.groupManager.findGroupByName(this.groupName);
        if (group == null) {
            System.err.println("Cluster group " + this.groupName + " doesn't exist");
            return null;
        }
        CellarSupport support = new CellarSupport();
        support.setClusterManager(this.clusterManager);
        support.setGroupManager(this.groupManager);
        support.setConfigurationAdmin(this.configurationAdmin);
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        try {
            Map<String, BundleCommandSupport.ExtendedBundleState> allBundles = this.gatherBundles(false);
            if (allBundles != null && !allBundles.isEmpty()) {
                System.out.println(String.format("Bundles in cluster group " + this.groupName, new Object[0]));
                ShellTable table = new ShellTable();
                table.column("ID").alignRight();
                table.column("State");
                table.column("Lvl");
                table.column("Located");
                table.column("Blocked");
                table.column("Version");
                if (this.showLocation) {
                    table.column("Location");
                } else if (this.showSymbolicName) {
                    table.column("Symbolic Name");
                } else {
                    table.column("Name");
                }
                if (this.ids != null && !this.ids.isEmpty()) {
                    HashSet<String> matchingBundles = new HashSet<String>(this.selector(allBundles));
                    Iterator<String> bundles = allBundles.keySet().iterator();
                    while (bundles.hasNext()) {
                        if (matchingBundles.contains(bundles.next())) continue;
                        bundles.remove();
                    }
                }
                ArrayList<BundleCommandSupport.ExtendedBundleState> bundles = new ArrayList<BundleCommandSupport.ExtendedBundleState>(allBundles.values());
                Collections.sort(bundles, new BundleStateComparator());
                for (BundleCommandSupport.ExtendedBundleState bundle : bundles) {
                    String status;
                    switch (bundle.getStatus()) {
                        case 2: {
                            status = "Installed";
                            break;
                        }
                        case 4: {
                            status = "Resolved";
                            break;
                        }
                        case 32: {
                            status = "Active";
                            break;
                        }
                        case 8: {
                            status = "Starting";
                            break;
                        }
                        case 16: {
                            status = "Stopping";
                            break;
                        }
                        case 1: {
                            status = "Uninstalled";
                            break;
                        }
                        default: {
                            status = "";
                        }
                    }
                    String located = "";
                    boolean cluster = bundle.isCluster();
                    boolean local = bundle.isLocal();
                    if (cluster && local) {
                        located = "cluster/local";
                    }
                    if (cluster && !local) {
                        located = "cluster";
                        if (this.onlyLocal) continue;
                    }
                    if (local && !cluster) {
                        located = "local";
                        if (this.onlyCluster) continue;
                    }
                    String blocked = "";
                    boolean inbound = support.isAllowed(group, "bundle", bundle.getLocation(), EventType.INBOUND);
                    boolean outbound = support.isAllowed(group, "bundle", bundle.getLocation(), EventType.OUTBOUND);
                    if (inbound && outbound && this.onlyBlocked) continue;
                    if (!inbound && !outbound) {
                        blocked = "in/out";
                    }
                    if (!inbound && outbound) {
                        blocked = "in";
                    }
                    if (outbound && !inbound) {
                        blocked = "out";
                    }
                    if (this.showLocation) {
                        table.addRow().addContent(new Object[]{bundle.getId(), status, bundle.getStartLevel(), located, blocked, bundle.getVersion(), bundle.getLocation()});
                        continue;
                    }
                    if (this.showSymbolicName) {
                        table.addRow().addContent(new Object[]{bundle.getId(), status, bundle.getStartLevel(), located, blocked, bundle.getVersion(), bundle.getSymbolicName()});
                        continue;
                    }
                    table.addRow().addContent(new Object[]{bundle.getId(), status, bundle.getStartLevel(), located, blocked, bundle.getVersion(), bundle.getName()});
                }
                table.print(System.out);
            } else {
                System.err.println("No bundle found in cluster group " + this.groupName);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
        return null;
    }

    class BundleStateComparator
    implements Comparator<BundleState> {
        BundleStateComparator() {
        }

        @Override
        public int compare(BundleState b1, BundleState b2) {
            return (int)(b1.getId() - b2.getId());
        }
    }
}

