/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.connection.nio.ClientConnection;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.MapReduceCancelCodec;
import com.hazelcast.client.impl.protocol.codec.MapReduceForCustomCodec;
import com.hazelcast.client.impl.protocol.codec.MapReduceForListCodec;
import com.hazelcast.client.impl.protocol.codec.MapReduceForMapCodec;
import com.hazelcast.client.impl.protocol.codec.MapReduceForMultiMapCodec;
import com.hazelcast.client.impl.protocol.codec.MapReduceForSetCodec;
import com.hazelcast.client.impl.protocol.codec.MapReduceJobProcessInformationCodec;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.mapreduce.Collator;
import com.hazelcast.mapreduce.CombinerFactory;
import com.hazelcast.mapreduce.Job;
import com.hazelcast.mapreduce.JobCompletableFuture;
import com.hazelcast.mapreduce.JobPartitionState;
import com.hazelcast.mapreduce.JobProcessInformation;
import com.hazelcast.mapreduce.JobTracker;
import com.hazelcast.mapreduce.KeyPredicate;
import com.hazelcast.mapreduce.KeyValueSource;
import com.hazelcast.mapreduce.Mapper;
import com.hazelcast.mapreduce.ReducerFactory;
import com.hazelcast.mapreduce.TopologyChangedStrategy;
import com.hazelcast.mapreduce.TrackableJob;
import com.hazelcast.mapreduce.impl.AbstractJob;
import com.hazelcast.mapreduce.impl.ListKeyValueSource;
import com.hazelcast.mapreduce.impl.MapKeyValueSource;
import com.hazelcast.mapreduce.impl.MultiMapKeyValueSource;
import com.hazelcast.mapreduce.impl.SetKeyValueSource;
import com.hazelcast.mapreduce.impl.task.TransferableJobProcessInformation;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.impl.AbstractCompletableFuture;
import com.hazelcast.util.CollectionUtil;
import com.hazelcast.util.EmptyStatement;
import com.hazelcast.util.UuidUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;

public class ClientMapReduceProxy
extends ClientProxy
implements JobTracker {
    private final ConcurrentMap<String, ClientTrackableJob> trackableJobs = new ConcurrentHashMap<String, ClientTrackableJob>();

    public ClientMapReduceProxy(String serviceName, String objectName, ClientContext context) {
        super(serviceName, objectName, context);
    }

    @Override
    protected void onDestroy() {
        for (ClientTrackableJob trackableJob : this.trackableJobs.values()) {
            trackableJob.completableFuture.cancel(false);
        }
    }

    @Override
    public <K, V> Job<K, V> newJob(KeyValueSource<K, V> source) {
        return new ClientJob<K, V>(this.name, source);
    }

    @Override
    public <V> TrackableJob<V> getTrackableJob(String jobId) {
        return (TrackableJob)this.trackableJobs.get(jobId);
    }

    public String toString() {
        return "JobTracker{name='" + this.name + '\'' + '}';
    }

    private ClientMessage invoke(ClientMessage request, String jobId) throws Exception {
        ClientTrackableJob trackableJob = (ClientTrackableJob)this.trackableJobs.get(jobId);
        if (trackableJob != null) {
            ClientConnection sendConnection = trackableJob.clientInvocation.getSendConnectionOrWait();
            Address runningMember = sendConnection.getEndPoint();
            ClientInvocation clientInvocation = new ClientInvocation(this.getClient(), request, this.getName(), runningMember);
            ClientInvocationFuture future = clientInvocation.invoke();
            return (ClientMessage)future.get();
        }
        return null;
    }

    private Map toObjectMap(ClientMessage res) {
        List<Map.Entry<Data, Data>> entries = MapReduceForCustomCodec.decodeResponse((ClientMessage)res).response;
        HashMap hashMap = new HashMap();
        for (Map.Entry entry : entries) {
            Object key = this.toObject(entry.getKey());
            Object value = this.toObject(entry.getValue());
            hashMap.put(key, value);
        }
        return hashMap;
    }

    private ClientMessage getRequest(String name, String jobId, Collection keys, KeyPredicate predicate, Mapper mapper, CombinerFactory combinerFactory, ReducerFactory reducerFactory, KeyValueSource keyValueSource, int chunkSize, TopologyChangedStrategy topologyChangedStrategy) {
        Data predicateData = this.toData(predicate);
        Data mapperData = this.toData(mapper);
        Data combinerFactoryData = this.toData(combinerFactory);
        Data reducerFactoryData = this.toData(reducerFactory);
        Collection<Data> list = null;
        if (keys != null) {
            list = CollectionUtil.objectToDataCollection(keys, this.getSerializationService());
        }
        String topologyChangedStrategyName = null;
        if (topologyChangedStrategy != null) {
            topologyChangedStrategyName = topologyChangedStrategy.name();
        }
        if (keyValueSource instanceof MapKeyValueSource) {
            MapKeyValueSource source = (MapKeyValueSource)keyValueSource;
            return MapReduceForMapCodec.encodeRequest(name, jobId, predicateData, mapperData, combinerFactoryData, reducerFactoryData, source.getMapName(), chunkSize, list, topologyChangedStrategyName);
        }
        if (keyValueSource instanceof ListKeyValueSource) {
            ListKeyValueSource source = (ListKeyValueSource)keyValueSource;
            return MapReduceForListCodec.encodeRequest(name, jobId, predicateData, mapperData, combinerFactoryData, reducerFactoryData, source.getListName(), chunkSize, list, topologyChangedStrategyName);
        }
        if (keyValueSource instanceof SetKeyValueSource) {
            SetKeyValueSource source = (SetKeyValueSource)keyValueSource;
            return MapReduceForSetCodec.encodeRequest(name, jobId, predicateData, mapperData, combinerFactoryData, reducerFactoryData, source.getSetName(), chunkSize, list, topologyChangedStrategyName);
        }
        if (keyValueSource instanceof MultiMapKeyValueSource) {
            MultiMapKeyValueSource source = (MultiMapKeyValueSource)keyValueSource;
            return MapReduceForMultiMapCodec.encodeRequest(name, jobId, predicateData, mapperData, combinerFactoryData, reducerFactoryData, source.getMultiMapName(), chunkSize, list, topologyChangedStrategyName);
        }
        return MapReduceForCustomCodec.encodeRequest(name, jobId, predicateData, mapperData, combinerFactoryData, reducerFactoryData, this.toData(keyValueSource), chunkSize, list, topologyChangedStrategyName);
    }

    private final class ClientTrackableJob<V>
    implements TrackableJob<V> {
        private final String jobId;
        private final ClientInvocation clientInvocation;
        private final AbstractCompletableFuture<V> completableFuture;

        private ClientTrackableJob(String jobId, ClientInvocation clientInvocation, AbstractCompletableFuture<V> completableFuture) {
            this.jobId = jobId;
            this.clientInvocation = clientInvocation;
            this.completableFuture = completableFuture;
        }

        @Override
        public JobTracker getJobTracker() {
            return ClientMapReduceProxy.this;
        }

        @Override
        public String getName() {
            return ClientMapReduceProxy.this.name;
        }

        @Override
        public String getJobId() {
            return this.jobId;
        }

        @Override
        public ICompletableFuture<V> getCompletableFuture() {
            return this.completableFuture;
        }

        @Override
        public JobProcessInformation getJobProcessInformation() {
            try {
                ClientMessage request = MapReduceJobProcessInformationCodec.encodeRequest(ClientMapReduceProxy.this.name, this.jobId);
                MapReduceJobProcessInformationCodec.ResponseParameters responseParameters = MapReduceJobProcessInformationCodec.decodeResponse(ClientMapReduceProxy.this.invoke(request, this.jobId));
                JobPartitionState[] partitionStates = responseParameters.jobPartitionStates.toArray(new JobPartitionState[0]);
                return new TransferableJobProcessInformation(partitionStates, responseParameters.processRecords);
            }
            catch (Exception ignore) {
                EmptyStatement.ignore(ignore);
                return null;
            }
        }
    }

    private class ClientCompletableFuture<V>
    extends AbstractCompletableFuture<V>
    implements JobCompletableFuture<V> {
        private final String jobId;

        protected ClientCompletableFuture(String jobId) {
            super(ClientMapReduceProxy.this.getContext().getExecutionService().getUserExecutor(), ClientMapReduceProxy.this.getContext().getLoggingService().getLogger(ClientCompletableFuture.class));
            this.jobId = jobId;
        }

        @Override
        public String getJobId() {
            return this.jobId;
        }

        @Override
        protected boolean shouldCancel(boolean mayInterruptIfRunning) {
            boolean cancelled = false;
            try {
                ClientMessage request = MapReduceCancelCodec.encodeRequest(ClientMapReduceProxy.this.name, this.jobId);
                ClientMessage response = ClientMapReduceProxy.this.invoke(request, this.jobId);
                cancelled = MapReduceCancelCodec.decodeResponse((ClientMessage)response).response;
            }
            catch (Exception ignore) {
                EmptyStatement.ignore(ignore);
            }
            return cancelled;
        }

        @Override
        protected boolean setResult(Object result) {
            return super.setResult(result);
        }
    }

    private class ClientJob<KeyIn, ValueIn>
    extends AbstractJob<KeyIn, ValueIn> {
        public ClientJob(String name, KeyValueSource<KeyIn, ValueIn> keyValueSource) {
            super(name, ClientMapReduceProxy.this, keyValueSource);
        }

        @Override
        protected <T> JobCompletableFuture<T> invoke(final Collator collator) {
            try {
                final String jobId = UuidUtil.newUnsecureUuidString();
                ClientMessage request = ClientMapReduceProxy.this.getRequest(this.name, jobId, this.keys, this.predicate, this.mapper, this.combinerFactory, this.reducerFactory, this.keyValueSource, this.chunkSize, this.topologyChangedStrategy);
                final ClientCompletableFuture completableFuture = new ClientCompletableFuture(jobId);
                ClientInvocation clientInvocation = new ClientInvocation(ClientMapReduceProxy.this.getClient(), request, ClientMapReduceProxy.this.getName());
                ClientInvocationFuture future = clientInvocation.invoke();
                future.andThen(new ExecutionCallback<ClientMessage>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onResponse(ClientMessage res) {
                        Map map;
                        Map response = map = ClientMapReduceProxy.this.toObjectMap(res);
                        try {
                            if (collator != null) {
                                response = collator.collate(response.entrySet());
                            }
                        }
                        finally {
                            completableFuture.setResult(response);
                            ClientMapReduceProxy.this.trackableJobs.remove(jobId);
                        }
                    }

                    @Override
                    public void onFailure(Throwable throwable) {
                        Throwable t = throwable;
                        try {
                            if (t instanceof ExecutionException && t.getCause() instanceof CancellationException) {
                                t = t.getCause();
                            }
                            completableFuture.setResult(t);
                        }
                        finally {
                            ClientMapReduceProxy.this.trackableJobs.remove(jobId);
                        }
                    }
                });
                ClientMapReduceProxy.this.trackableJobs.putIfAbsent(jobId, new ClientTrackableJob(jobId, clientInvocation, completableFuture));
                return completableFuture;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

