/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.signatures;

import aQute.bnd.signatures.ClassResolver;
import aQute.bnd.signatures.ClassSignature;
import aQute.bnd.signatures.JavaTypeSignature;
import aQute.bnd.signatures.MethodSignature;
import aQute.bnd.signatures.ReferenceTypeSignature;
import aQute.bnd.signatures.Result;
import aQute.bnd.signatures.TypeVariableSignature;
import aQute.bnd.signatures.VoidDescriptor;
import java.util.Objects;

public class MethodResolver
extends ClassResolver {
    private final MethodSignature methodSig;

    public MethodResolver(ClassSignature classSig, MethodSignature methodSig) {
        super(classSig);
        this.methodSig = Objects.requireNonNull(methodSig);
    }

    public JavaTypeSignature resolveParameter(int index) {
        return this.resolveType(this.methodSig.parameterTypes[index]);
    }

    public Result resolveResult() {
        Result resultType = this.methodSig.resultType;
        if (resultType instanceof VoidDescriptor) {
            return resultType;
        }
        return this.resolveType((JavaTypeSignature)resultType);
    }

    @Override
    public ReferenceTypeSignature resolveType(TypeVariableSignature typeVariable) {
        ReferenceTypeSignature result = this.resolveType(this.methodSig.typeParameters, typeVariable);
        if (result != null) {
            return result;
        }
        return super.resolveType(typeVariable);
    }

    @Override
    public int hashCode() {
        int result = 31 + this.methodSig.hashCode();
        result = result * 31 + super.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MethodResolver)) {
            return false;
        }
        MethodResolver other = (MethodResolver)obj;
        return Objects.equals(this.methodSig, other.methodSig) && super.equals(other);
    }

    @Override
    public String toString() {
        return "MethodResolver: " + this.methodSig;
    }
}

