/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.osgi;

import aQute.bnd.annotation.headers.BundleCategory;
import aQute.bnd.annotation.headers.BundleContributors;
import aQute.bnd.annotation.headers.BundleCopyright;
import aQute.bnd.annotation.headers.BundleDevelopers;
import aQute.bnd.annotation.headers.BundleDocURL;
import aQute.bnd.annotation.headers.BundleLicense;
import aQute.bnd.annotation.headers.Category;
import aQute.bnd.annotation.headers.ProvideCapability;
import aQute.bnd.annotation.headers.RequireCapability;
import aQute.bnd.bundle.annotations.Capabilities;
import aQute.bnd.bundle.annotations.Capability;
import aQute.bnd.bundle.annotations.Header;
import aQute.bnd.bundle.annotations.Headers;
import aQute.bnd.bundle.annotations.Requirement;
import aQute.bnd.bundle.annotations.Requirements;
import aQute.bnd.header.Attrs;
import aQute.bnd.header.OSGiHeader;
import aQute.bnd.header.Parameters;
import aQute.bnd.osgi.Analyzer;
import aQute.bnd.osgi.Annotation;
import aQute.bnd.osgi.ClassDataCollector;
import aQute.bnd.osgi.Clazz;
import aQute.bnd.osgi.Descriptors;
import aQute.bnd.osgi.Instruction;
import aQute.bnd.osgi.Instructions;
import aQute.bnd.osgi.Macro;
import aQute.bnd.osgi.Processor;
import aQute.bnd.osgi.Verifier;
import aQute.bnd.stream.MapStream;
import aQute.bnd.version.Version;
import aQute.bnd.version.VersionRange;
import aQute.lib.collections.MultiMap;
import aQute.lib.converter.Converter;
import aQute.lib.exceptions.ConsumerWithException;
import aQute.lib.exceptions.Exceptions;
import aQute.lib.strings.Strings;
import aQute.lib.unmodifiable.Sets;
import java.io.Closeable;
import java.io.IOException;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AnnotationHeaders
extends ClassDataCollector
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(AnnotationHeaders.class);
    private static final Converter CONVERTER = new Converter();
    private static final Instruction ANNOTATION_INSTRUCTION;
    static final Pattern SIMPLE_PARAM_PATTERN;
    static final Set<String> DO_NOT_SCAN;
    final Analyzer analyzer;
    final MultiMap<String, String> headers = new MultiMap();
    static final String CARDINALITY = "aQute.bnd.annotation.Cardinality";
    static final String RESOLUTION = "aQute.bnd.annotation.Resolution";
    static final String BUNDLE_LICENSE = "aQute.bnd.annotation.headers.BundleLicense";
    static final String REQUIRE_CAPABILITY = "aQute.bnd.annotation.headers.RequireCapability";
    static final String PROVIDE_CAPABILITY = "aQute.bnd.annotation.headers.ProvideCapability";
    static final String BUNDLE_CATEGORY = "aQute.bnd.annotation.headers.BundleCategory";
    static final String BUNDLE_DOC_URL = "aQute.bnd.annotation.headers.BundleDocURL";
    static final String BUNDLE_DEVELOPERS = "aQute.bnd.annotation.headers.BundleDevelopers";
    static final String BUNDLE_CONTRIBUTORS = "aQute.bnd.annotation.headers.BundleContributors";
    static final String BUNDLE_COPYRIGHT = "aQute.bnd.annotation.headers.BundleCopyright";
    static final String STD_REQUIREMENT = "org.osgi.annotation.bundle.Requirement";
    static final String STD_REQUIREMENT_CARDINALITY = "org.osgi.annotation.bundle.Requirement$Cardinality";
    static final String STD_REQUIREMENT_RESOLUTION = "org.osgi.annotation.bundle.Requirement$Resolution";
    static final String STD_REQUIREMENTS = "org.osgi.annotation.bundle.Requirements";
    static final String STD_CAPABILITY = "org.osgi.annotation.bundle.Capability";
    static final String STD_CAPABILITIES = "org.osgi.annotation.bundle.Capabilities";
    static final String STD_HEADER = "org.osgi.annotation.bundle.Header";
    static final String STD_HEADERS = "org.osgi.annotation.bundle.Headers";
    static final String STD_ATTRIBUTE = "org.osgi.annotation.bundle.Attribute";
    static final String STD_DIRECTIVE = "org.osgi.annotation.bundle.Directive";
    Clazz current;
    final Set<String> loggedMissing = new HashSet<String>();
    final Instructions instructions;
    boolean finalizing;

    static String convert(Object value) {
        try {
            return CONVERTER.convert(String.class, value);
        }
        catch (Exception e) {
            throw Exceptions.duck(e);
        }
    }

    AnnotationHeaders(Analyzer analyzer) {
        this(analyzer, new Instructions("*"));
    }

    AnnotationHeaders(Analyzer analyzer, Instructions instructions) {
        this.analyzer = analyzer;
        this.instructions = instructions;
    }

    @Override
    public boolean classStart(Clazz c) {
        if (!c.isAnnotation() && !c.annotations().isEmpty()) {
            for (Instruction instruction : this.instructions.keySet()) {
                if (!instruction.matches(c.getFQN())) continue;
                if (instruction.isNegated()) {
                    this.current = null;
                    return false;
                }
                this.current = c;
                return true;
            }
        }
        this.current = null;
        return false;
    }

    @Override
    public void annotation(Annotation annotation) throws Exception {
        Descriptors.TypeRef name = annotation.getName();
        String fqn = name.getFQN();
        if (name.isJava() || DO_NOT_SCAN.contains(fqn)) {
            return;
        }
        switch (fqn) {
            case "aQute.bnd.annotation.headers.BundleCategory": {
                this.doBundleCategory(annotation, annotation.getAnnotation(BundleCategory.class));
                break;
            }
            case "aQute.bnd.annotation.headers.BundleContributors": {
                this.doBundleContributors(annotation, annotation.getAnnotation(BundleContributors.class));
                break;
            }
            case "aQute.bnd.annotation.headers.BundleCopyright": {
                this.doBundleCopyright(annotation, annotation.getAnnotation(BundleCopyright.class));
                break;
            }
            case "aQute.bnd.annotation.headers.BundleDevelopers": {
                this.doBundleDevelopers(annotation, annotation.getAnnotation(BundleDevelopers.class));
                break;
            }
            case "aQute.bnd.annotation.headers.BundleDocURL": {
                this.doBundleDocURL(annotation, annotation.getAnnotation(BundleDocURL.class));
                break;
            }
            case "aQute.bnd.annotation.headers.BundleLicense": {
                this.doLicense(annotation, annotation.getAnnotation(BundleLicense.class));
                break;
            }
            case "aQute.bnd.annotation.headers.ProvideCapability": {
                this.doProvideCapability(annotation, annotation.getAnnotation(ProvideCapability.class));
                break;
            }
            case "aQute.bnd.annotation.headers.RequireCapability": {
                this.doRequireCapability(annotation, annotation.getAnnotation(RequireCapability.class));
                break;
            }
            case "org.osgi.annotation.bundle.Capabilities": {
                Capability[] capabilities = annotation.getAnnotation(Capabilities.class).value();
                Object[] capAnnotations = (Object[])annotation.get("value");
                for (int i = 0; i < capabilities.length; ++i) {
                    this.doCapability((Annotation)capAnnotations[i], capabilities[i]);
                }
                break;
            }
            case "org.osgi.annotation.bundle.Capability": {
                this.doCapability(annotation, annotation.getAnnotation(Capability.class));
                break;
            }
            case "org.osgi.annotation.bundle.Header": {
                Header header = annotation.getAnnotation(Header.class);
                this.add(annotation, header.name(), header.value());
                break;
            }
            case "org.osgi.annotation.bundle.Headers": {
                Header[] headers = annotation.getAnnotation(Headers.class).value();
                Object[] headerAnnotations = (Object[])annotation.get("value");
                for (int i = 0; i < headers.length; ++i) {
                    this.add((Annotation)headerAnnotations[i], headers[i].name(), headers[i].value());
                }
                break;
            }
            case "org.osgi.annotation.bundle.Requirement": {
                this.doRequirement(annotation, annotation.getAnnotation(Requirement.class));
                break;
            }
            case "org.osgi.annotation.bundle.Requirements": {
                Requirement[] requirements = annotation.getAnnotation(Requirements.class).value();
                Object[] reqAnnotations = (Object[])annotation.get("value");
                for (int i = 0; i < requirements.length; ++i) {
                    this.doRequirement((Annotation)reqAnnotations[i], requirements[i]);
                }
                break;
            }
            default: {
                Object[] container;
                Object value = annotation.get("value");
                if (value instanceof Object[] && (container = (Object[])value).length > 0 && container[0] instanceof Annotation && Optional.ofNullable(this.analyzer.findClass(((Annotation)container[0]).getName())).flatMap(c -> c.annotations("java/lang/annotation/Repeatable").findFirst()).filter(a -> name.equals(a.get("value"))).isPresent()) {
                    for (Object a2 : container) {
                        Annotation repeatable = (Annotation)a2;
                        this.doAnnotatedAnnotation(repeatable, repeatable.getName(), Collections.emptySet(), new Attrs());
                    }
                }
                this.doAnnotatedAnnotation(annotation, name, Collections.emptySet(), new Attrs());
            }
        }
    }

    void doAnnotatedAnnotation(Annotation annotation, Descriptors.TypeRef name, Set<String> processed, Attrs baseAttrs) throws Exception {
        String fqn = name.getFQN();
        if (processed.contains(fqn)) {
            return;
        }
        if (name.isJava() || DO_NOT_SCAN.contains(fqn)) {
            return;
        }
        Clazz c = this.analyzer.findClass(name);
        if (c == null) {
            if (this.loggedMissing.add(fqn)) {
                if (this.analyzer.isPedantic()) {
                    this.analyzer.warning("Unable to determine whether the meta annotation %s applied to type %s provides bundle annotations as it is not on the project build path. If this annotation does provide bundle annotations then it must be present on the build path in order to be processed", fqn, this.current.getFQN());
                } else {
                    logger.debug("Unable to determine whether the meta annotation {} applied to type {} provides bundle annotations as it is not on the project build path. If this annotation does provide bundle annotations then it must be present on the build path in order to be processed", (Object)fqn, (Object)this.current.getFQN());
                }
            }
        } else if (!c.annotations().isEmpty()) {
            c.parseClassFileWithCollector(new MetaAnnotationCollector(c, annotation, processed, baseAttrs));
        }
    }

    @Override
    public void close() throws IOException {
    }

    private void doBundleDevelopers(Annotation a, BundleDevelopers annotation) throws IOException {
        StringBuilder sb = new StringBuilder(annotation.value());
        if (!"".equals(annotation.name())) {
            sb.append(";name='");
            this.escape(sb, annotation.name());
            sb.append("'");
        }
        if (annotation.roles().length > 0) {
            sb.append(";roles='");
            this.escape(sb, annotation.roles());
            sb.append("'");
        }
        if (!"".equals(annotation.organizationUrl())) {
            sb.append(";organizationUrl='");
            this.escape(sb, annotation.organizationUrl());
            sb.append("'");
        }
        if (!"".equals(annotation.organization())) {
            sb.append(";organization='");
            this.escape(sb, annotation.organization());
            sb.append("'");
        }
        if (annotation.timezone() != 0) {
            sb.append(";timezone=").append(annotation.timezone());
        }
        this.add(a, "Bundle-Developers", sb.toString());
    }

    private void doBundleContributors(Annotation a, BundleContributors annotation) throws IOException {
        StringBuilder sb = new StringBuilder(annotation.value());
        if (!"".equals(annotation.name())) {
            sb.append(";name='");
            this.escape(sb, annotation.name());
            sb.append("'");
        }
        if (annotation.roles().length > 0) {
            sb.append(";roles='");
            this.escape(sb, annotation.roles());
            sb.append("'");
        }
        if (!"".equals(annotation.organizationUrl())) {
            sb.append(";organizationUrl='");
            this.escape(sb, annotation.organizationUrl());
            sb.append("'");
        }
        if (!"".equals(annotation.organization())) {
            sb.append(";organization='");
            this.escape(sb, annotation.organization());
            sb.append("'");
        }
        if (annotation.timezone() != 0) {
            sb.append(";timezone=").append(annotation.timezone());
        }
        this.add(a, "Bundle-Contributors", sb.toString());
    }

    private void doBundleCopyright(Annotation a, BundleCopyright annotation) throws IOException {
        this.add(a, "Bundle-Copyright", annotation.value());
    }

    private void doBundleDocURL(Annotation a, BundleDocURL annotation) throws IOException {
        this.add(a, "Bundle-DocURL", annotation.value());
    }

    private void doBundleCategory(Annotation a, BundleCategory annotation) throws IOException {
        if (annotation.custom().length > 0) {
            for (String string : annotation.custom()) {
                this.add(a, "Bundle-Category", string);
            }
        }
        if (annotation.value() != null) {
            for (Category category : annotation.value()) {
                this.add(a, "Bundle-Category", category.toString());
            }
        }
    }

    private void doProvideCapability(Annotation a, ProvideCapability annotation) throws Exception {
        Parameters p = new Parameters();
        Attrs attrs = this.getAttributes(a, "ns");
        this.directivesAndVersion(attrs, "uses", "mandatory", "effective");
        p.put(annotation.ns(), attrs);
        String value = attrs.remove("name");
        if (value != null) {
            attrs.put(annotation.ns(), value);
        }
        value = attrs.remove("value");
        String s = p.toString();
        if (value != null) {
            s = s + ";" + annotation.value();
        }
        this.add(a, "Provide-Capability", s);
    }

    private void doRequireCapability(Annotation a, RequireCapability annotation) throws Exception {
        Parameters p = new Parameters();
        Attrs attrs = this.getAttributes(a, "ns");
        this.directivesAndVersion(attrs, "filter", "effective", "resolution");
        this.replaceParameters(attrs);
        if ("".equals(attrs.get("filter:"))) {
            attrs.remove("filter:");
        }
        p.put(annotation.ns(), attrs);
        String s = p.toString();
        String extra = annotation.extra();
        if (extra != null && (extra = extra.trim()).length() > 0) {
            s = s + ";" + extra;
        }
        this.add(a, "Require-Capability", s);
    }

    private void replaceParameters(Attrs attrs) throws IllegalArgumentException {
        for (Map.Entry<String, String> entry : attrs.entrySet()) {
            StringBuilder sb = new StringBuilder();
            String value = entry.getValue();
            Matcher matcher = SIMPLE_PARAM_PATTERN.matcher(value);
            int start = 0;
            while (matcher.find()) {
                String key = matcher.group(1);
                String replacement = attrs.get(key);
                if (replacement == null) {
                    replacement = matcher.group(0);
                } else if (SIMPLE_PARAM_PATTERN.matcher(replacement).find()) {
                    throw new IllegalArgumentException("nested substitutions not permitted");
                }
                sb.append(value, start, matcher.start()).append(replacement);
                start = matcher.end();
            }
            if (start == 0) continue;
            entry.setValue(sb.append(value, start, value.length()).toString());
        }
    }

    private void doLicense(Annotation a, BundleLicense annotation) throws Exception {
        Parameters p = new Parameters();
        p.put(annotation.name(), this.getAttributes(a, "name"));
        this.add(a, "Bundle-License", p.toString());
    }

    private void doRequirement(Annotation a, Requirement annotation) throws Exception {
        StringBuilder req = new StringBuilder();
        req.append(annotation.namespace());
        String filter = this.getFilter(a, annotation);
        if (!filter.isEmpty()) {
            try {
                Verifier.verifyFilter(filter, 0);
            }
            catch (Exception e) {
                this.analyzer.exception(e, "The Requirement annotation with namespace %s applied to class %s has invalid filter information.", annotation.namespace(), this.current.getFQN());
            }
            req.append(";filter:='").append(filter).append('\'');
        }
        if (a.containsKey("resolution")) {
            req.append(";resolution:=").append((Object)annotation.resolution());
        }
        if (a.containsKey("cardinality")) {
            req.append(";cardinality:=").append((Object)annotation.cardinality());
        }
        if (a.containsKey("effective")) {
            req.append(";effective:=");
            this.escape(req, annotation.effective());
        }
        for (String attr : annotation.attribute()) {
            req.append(';').append(attr);
        }
        this.add(a, "Require-Capability", req.toString());
    }

    private String getFilter(Annotation a, Requirement annotation) {
        StringBuilder filter = new StringBuilder();
        boolean addAnd = false;
        if (a.containsKey("filter")) {
            filter.append(annotation.filter());
            addAnd = true;
        }
        boolean andAdded = false;
        if (a.containsKey("name")) {
            filter.append('(').append(annotation.namespace()).append('=').append(annotation.name()).append(')');
            if (addAnd) {
                filter.insert(0, "(&").append(')');
                andAdded = true;
            }
            addAnd = true;
        }
        if (a.containsKey("version")) {
            if (annotation.version().indexOf(36) == -1) {
                Version floor;
                try {
                    floor = Version.parseVersion(annotation.version());
                }
                catch (Exception e) {
                    floor = null;
                    this.analyzer.exception(e, "The version declared by the Requirement annotation attached to type %s is invalid", this.current.getFQN());
                }
                if (floor != null) {
                    int current = filter.lastIndexOf(")");
                    VersionRange range = new VersionRange(floor, floor.bumpMajor());
                    String rangeFilter = range.toFilter();
                    filter.append(rangeFilter.substring(2, rangeFilter.length() - 1));
                    if (andAdded) {
                        filter.deleteCharAt(current).append(')');
                    } else if (addAnd) {
                        filter.insert(0, "(&").append(')');
                    }
                }
            } else {
                String floor = annotation.version();
                int current = filter.lastIndexOf(")");
                filter.append("(version>=").append(floor).append(")(!(version>=${versionmask;+00;").append(floor).append("}))");
                if (andAdded) {
                    filter.deleteCharAt(current).append(')');
                } else if (addAnd) {
                    filter.insert(0, "(&").append(')');
                }
            }
        }
        return filter.toString();
    }

    private void doCapability(Annotation a, Capability annotation) throws Exception {
        StringBuilder cap = new StringBuilder();
        cap.append(annotation.namespace());
        if (a.containsKey("name")) {
            cap.append(';').append(annotation.namespace()).append('=').append(annotation.name());
        }
        if (a.containsKey("version")) {
            if (annotation.version().indexOf(36) == -1) {
                try {
                    Version.parseVersion(annotation.version());
                }
                catch (Exception e) {
                    this.analyzer.exception(e, "The version declared by the Capability annotation attached to type %s is invalid", this.current.getFQN());
                }
            }
            cap.append(";version:Version=").append(annotation.version());
        }
        for (String attr : annotation.attribute()) {
            cap.append(';').append(attr);
        }
        if (a.containsKey("uses")) {
            cap.append(a.stream("uses", Descriptors.TypeRef.class).map(Descriptors.TypeRef::getPackageRef).map(Descriptors.PackageRef::getFQN).distinct().collect(Strings.joining(",", ";uses:=\"", "\"", "")));
        }
        if (a.containsKey("effective")) {
            cap.append(";effective:=");
            this.escape(cap, annotation.effective());
        }
        this.add(a, "Provide-Capability", cap.toString());
    }

    private void directivesAndVersion(Attrs attrs, String ... directives) {
        for (String directive : directives) {
            String s = attrs.remove(directive);
            if (s == null) continue;
            attrs.put(directive + ":", s);
        }
        String remove = attrs.remove("version");
        if (remove != null) {
            attrs.putTyped("version", Version.parseVersion(remove));
        }
    }

    private Attrs getAttributes(Annotation a, String ... ignores) {
        List<String> ignoresList = Arrays.asList(ignores);
        Attrs attrs = new Attrs();
        MapStream.of(a.entrySet()).filterKey(key -> !ignoresList.contains(key)).forEachOrdered(attrs::putTyped);
        return attrs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(Annotation annotation, String name, String value) throws IOException {
        if (value == null) {
            return;
        }
        Processor next = new Processor();
        next.addProperties(MapStream.of(annotation.entrySet()).filterKey(k -> k.startsWith("#")).map((k, v) -> {
            Object[] array;
            if (k.equals("#uses") && v instanceof Object[] && (array = (Object[])v).length > 0 && array[0] instanceof Descriptors.TypeRef) {
                String converted = Arrays.stream(array).map(Descriptors.TypeRef.class::cast).map(Descriptors.TypeRef::getPackageRef).map(Descriptors.PackageRef::getFQN).distinct().collect(Collectors.joining(","));
                return MapStream.entry(k, converted);
            }
            return MapStream.entry(k, AnnotationHeaders.convert(v));
        }).collect(MapStream.toMap()));
        next.setProperty("@class", this.current.getFQN());
        next.setProperty("@class-short", this.current.getClassName().getShortName());
        Descriptors.PackageRef pref = this.current.getClassName().getPackageRef();
        next.setProperty("@package", pref.getFQN());
        Attrs info = this.analyzer.getClasspathExports().get(pref);
        if (info == null) {
            info = this.analyzer.getContained().get(pref);
        }
        if (info != null && info.containsKey("version")) {
            next.setProperty("@version", info.get("version"));
        }
        Macro macro = next.getReplacer();
        boolean prev = macro.setNosystem(true);
        try {
            value = OSGiHeader.parseHeader(macro.process(value)).toString();
            this.headers.add(name, value);
            if (!this.analyzer.keySet().contains(name)) {
                this.analyzer.setProperty(name, value);
            }
            next.close();
        }
        finally {
            macro.setNosystem(prev);
        }
    }

    public String getHeader(String name) {
        String value = this.analyzer.getProperty(name);
        if (this.headers.containsKey(name)) {
            TreeSet set = new TreeSet(this.headers.get(name));
            ArrayList<String> result = new ArrayList<String>(set.size() + 1);
            if (value != null && !set.contains(value)) {
                result.add(value);
            }
            result.addAll(set);
            return Strings.join(result);
        }
        return value;
    }

    private void escape(StringBuilder app, String[] s) throws IOException {
        String joined = Strings.join(s);
        this.escape(app, joined);
    }

    private void escape(StringBuilder app, String s) throws IOException {
        Processor.quote(app, s);
    }

    static {
        CONVERTER.hook(null, (t, o) -> {
            if (o.getClass().isArray() && String.class.equals((Object)t)) {
                return Strings.join(",", (Object[])o);
            }
            return null;
        });
        ANNOTATION_INSTRUCTION = new Instruction("java.lang.annotation.Annotation");
        SIMPLE_PARAM_PATTERN = Pattern.compile("\\$\\{(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)\\}");
        DO_NOT_SCAN = Sets.of("org.osgi.annotation.versioning.ProviderType", "org.osgi.annotation.versioning.ConsumerType", "org.osgi.annotation.versioning.Version");
    }

    private final class MetaAnnotationCollector
    extends ClassDataCollector {
        private final Clazz c;
        private final Annotation annotation;
        private Clazz.MethodDef lastMethodSeen;
        private Set<String> processed;
        private Attrs attributesAndDirectives = new Attrs();

        private MetaAnnotationCollector(Clazz c, Annotation annotation, Set<String> processed, Attrs baseAttrs) {
            this.c = c;
            this.annotation = annotation;
            this.processed = processed;
            this.attributesAndDirectives = new Attrs(baseAttrs);
        }

        @Override
        public void annotation(Annotation a) throws Exception {
            String fqn;
            switch (fqn = a.getName().getFQN()) {
                case "aQute.bnd.annotation.headers.BundleCategory": 
                case "aQute.bnd.annotation.headers.BundleContributors": 
                case "aQute.bnd.annotation.headers.BundleCopyright": 
                case "aQute.bnd.annotation.headers.BundleDevelopers": 
                case "aQute.bnd.annotation.headers.BundleDocURL": 
                case "aQute.bnd.annotation.headers.BundleLicense": 
                case "aQute.bnd.annotation.headers.ProvideCapability": 
                case "aQute.bnd.annotation.headers.RequireCapability": {
                    a.merge(this.annotation);
                    a.addDefaults(this.c);
                    AnnotationHeaders.this.annotation(a);
                    break;
                }
                case "org.osgi.annotation.bundle.Capabilities": 
                case "org.osgi.annotation.bundle.Capability": 
                case "org.osgi.annotation.bundle.Requirement": 
                case "org.osgi.annotation.bundle.Requirements": {
                    this.mergeAttributesAndDirectives(a);
                    AnnotationHeaders.this.annotation(a);
                    break;
                }
                case "org.osgi.annotation.bundle.Header": 
                case "org.osgi.annotation.bundle.Headers": {
                    AnnotationHeaders.this.annotation(a);
                    break;
                }
                case "org.osgi.annotation.bundle.Attribute": 
                case "org.osgi.annotation.bundle.Directive": {
                    this.handleAttributeOrDirective(a);
                    break;
                }
                default: {
                    HashSet<String> processed = new HashSet<String>(this.processed);
                    processed.add(this.c.getFQN());
                    AnnotationHeaders.this.doAnnotatedAnnotation(a, a.getName(), processed, this.attributesAndDirectives);
                }
            }
        }

        private void mergeAttributesAndDirectives(Annotation a) {
            String fqn;
            switch (fqn = a.getName().getFQN()) {
                case "org.osgi.annotation.bundle.Capabilities": 
                case "org.osgi.annotation.bundle.Requirements": {
                    Object[] annotations = (Object[])a.get("value");
                    for (int i = 0; i < annotations.length; ++i) {
                        this.mergeAttributesAndDirectives((Annotation)annotations[i]);
                    }
                    break;
                }
                default: {
                    if (this.c.isAnnotation()) {
                        this.c.methods().forEach(ConsumerWithException.asConsumer(method -> {
                            Clazz c;
                            Descriptors.TypeRef returnType = method.getType();
                            if (returnType.isArray()) {
                                returnType = returnType.getComponentTypeRef();
                            }
                            if ((c = AnnotationHeaders.this.analyzer.findClass(returnType)) != null && c.is(Clazz.QUERY.IMPLEMENTS, ANNOTATION_INSTRUCTION, AnnotationHeaders.this.analyzer)) {
                                return;
                            }
                            Object object = this.getOrDefault((Clazz.MethodDef)method);
                            if (object == null) {
                                return;
                            }
                            a.put("#" + method.getName(), object);
                        }));
                    }
                    if (this.attributesAndDirectives.isEmpty()) break;
                    Object[] original = (Object[])a.get("attribute");
                    int length = original != null ? original.length : 0;
                    Object[] updated = new Object[length + this.attributesAndDirectives.size()];
                    if (length > 0) {
                        System.arraycopy(original, 0, updated, 0, length);
                    }
                    for (String key : this.attributesAndDirectives.keySet()) {
                        updated[length++] = this.attributesAndDirectives.toString(key);
                    }
                    a.put("attribute", updated);
                }
            }
        }

        private void handleAttributeOrDirective(Annotation a) {
            Object o = this.annotation.get(this.lastMethodSeen.getName());
            if (o != null) {
                String attributeName = (String)a.get("value");
                if (attributeName == null) {
                    attributeName = this.lastMethodSeen.getName();
                }
                if (AnnotationHeaders.STD_DIRECTIVE.equals(a.getName().getFQN())) {
                    attributeName = attributeName + ":";
                }
                if (!this.attributesAndDirectives.containsKey(attributeName)) {
                    if (this.lastMethodSeen.getType().getFQN().equals(AnnotationHeaders.STD_REQUIREMENT_CARDINALITY) || this.lastMethodSeen.getType().getFQN().equals(AnnotationHeaders.STD_REQUIREMENT_RESOLUTION)) {
                        o = String.valueOf(o).toLowerCase();
                    }
                    this.attributesAndDirectives.putTyped(attributeName, o);
                }
            }
        }

        @Override
        public void method(Clazz.MethodDef defined) {
            this.lastMethodSeen = defined;
        }

        private Object getOrDefault(Clazz.MethodDef method) {
            Object object = this.annotation.get(method.getName());
            if (object == null) {
                try {
                    object = this.c.getDefaults().get(method.getName());
                }
                catch (Exception e) {
                    throw Exceptions.duck(e);
                }
            }
            if (object instanceof Object[] && ((Object[])object).length > 0 && ((Object[])object)[0] instanceof Descriptors.TypeRef) {
                Object[] typeRefs = (Object[])object;
                Object[] copy = new Object[typeRefs.length];
                for (int i = 0; i < typeRefs.length; ++i) {
                    copy[i] = Target.class.getName().equals(typeRefs[i].toString()) ? AnnotationHeaders.this.current.getClassName() : typeRefs[i];
                }
                object = copy;
            } else if (object instanceof Descriptors.TypeRef && Target.class.getName().equals(object.toString())) {
                object = AnnotationHeaders.this.current.getClassName();
            }
            String returnFQN = method.getType().getFQN();
            if (object != null && (returnFQN.equals(AnnotationHeaders.CARDINALITY) || returnFQN.equals(AnnotationHeaders.RESOLUTION) || returnFQN.equals(AnnotationHeaders.STD_REQUIREMENT_CARDINALITY) || returnFQN.equals(AnnotationHeaders.STD_REQUIREMENT_RESOLUTION))) {
                object = String.valueOf(object).toLowerCase();
            }
            return object;
        }
    }
}

