/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery.zen;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.store.AlreadyClosedException;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ClusterStateTaskListener;
import org.elasticsearch.cluster.NotMasterException;
import org.elasticsearch.cluster.coordination.JoinTaskExecutor;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.RerouteService;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.service.MasterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.discovery.zen.ElectMasterService;
import org.elasticsearch.discovery.zen.MembershipAction;

public class NodeJoinController {
    private static final Logger logger = LogManager.getLogger(NodeJoinController.class);
    private final MasterService masterService;
    private final JoinTaskExecutor joinTaskExecutor;
    private ElectionContext electionContext = null;

    public NodeJoinController(Settings settings, MasterService masterService, AllocationService allocationService, final ElectMasterService electMaster, RerouteService rerouteService) {
        this.masterService = masterService;
        this.joinTaskExecutor = new JoinTaskExecutor(settings, allocationService, logger, rerouteService){

            @Override
            public void clusterStatePublished(ClusterChangedEvent event) {
                electMaster.logMinimumMasterNodesWarningIfNecessary(event.previousState(), event.state());
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitToBeElectedAsMaster(int requiredMasterJoins, TimeValue timeValue, final ElectionCallback callback) {
        block10: {
            final CountDownLatch done = new CountDownLatch(1);
            ElectionCallback wrapperCallback = new ElectionCallback(){

                @Override
                public void onElectedAsMaster(ClusterState state) {
                    done.countDown();
                    callback.onElectedAsMaster(state);
                }

                @Override
                public void onFailure(Throwable t) {
                    done.countDown();
                    callback.onFailure(t);
                }
            };
            ElectionContext myElectionContext = null;
            try {
                NodeJoinController nodeJoinController = this;
                synchronized (nodeJoinController) {
                    assert (this.electionContext != null) : "waitToBeElectedAsMaster is called we are not accumulating joins";
                    myElectionContext = this.electionContext;
                    this.electionContext.onAttemptToBeElected(requiredMasterJoins, wrapperCallback);
                    this.checkPendingJoinsAndElectIfNeeded();
                }
                try {
                    if (done.await(timeValue.millis(), TimeUnit.MILLISECONDS)) {
                        return;
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (logger.isTraceEnabled()) {
                    int pendingNodes = myElectionContext.getPendingMasterJoinsCount();
                    logger.trace("timed out waiting to be elected. waited [{}]. pending master node joins [{}]", (Object)timeValue, (Object)pendingNodes);
                }
                this.failContextIfNeeded(myElectionContext, "timed out waiting to be elected");
            }
            catch (Exception e) {
                logger.error("unexpected failure while waiting for incoming joins", (Throwable)e);
                if (myElectionContext == null) break block10;
                this.failContextIfNeeded(myElectionContext, "unexpected failure while waiting for pending joins [" + e.getMessage() + "]");
            }
        }
    }

    private synchronized void failContextIfNeeded(ElectionContext context, String reason) {
        if (this.electionContext == context) {
            this.stopElectionContext(reason);
        }
    }

    public synchronized void startElectionContext() {
        logger.trace("starting an election context, will accumulate joins");
        assert (this.electionContext == null) : "double startElectionContext() calls";
        this.electionContext = new ElectionContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopElectionContext(String reason) {
        logger.trace("stopping election ([{}])", (Object)reason);
        NodeJoinController nodeJoinController = this;
        synchronized (nodeJoinController) {
            assert (this.electionContext != null) : "stopElectionContext() called but not accumulating";
            this.electionContext.closeAndProcessPending(reason);
            this.electionContext = null;
        }
    }

    public synchronized void handleJoinRequest(DiscoveryNode node, MembershipAction.JoinCallback callback) {
        if (this.electionContext != null) {
            this.electionContext.addIncomingJoin(node, callback);
            this.checkPendingJoinsAndElectIfNeeded();
        } else {
            this.masterService.submitStateUpdateTask("zen-disco-node-join", new JoinTaskExecutor.Task(node, "no election context"), ClusterStateTaskConfig.build(Priority.URGENT), this.joinTaskExecutor, new JoinTaskListener(callback, logger));
        }
    }

    private synchronized void checkPendingJoinsAndElectIfNeeded() {
        assert (this.electionContext != null) : "election check requested but no active context";
        int pendingMasterJoins = this.electionContext.getPendingMasterJoinsCount();
        if (!this.electionContext.isEnoughPendingJoins(pendingMasterJoins)) {
            if (logger.isTraceEnabled()) {
                logger.trace("not enough joins for election. Got [{}], required [{}]", (Object)pendingMasterJoins, (Object)this.electionContext.requiredMasterJoins);
            }
        } else {
            if (logger.isTraceEnabled()) {
                logger.trace("have enough joins for election. Got [{}], required [{}]", (Object)pendingMasterJoins, (Object)this.electionContext.requiredMasterJoins);
            }
            this.electionContext.closeAndBecomeMaster();
            this.electionContext = null;
        }
    }

    static class JoinTaskListener
    implements ClusterStateTaskListener {
        final List<MembershipAction.JoinCallback> callbacks;
        private final Logger logger;

        JoinTaskListener(MembershipAction.JoinCallback callback, Logger logger) {
            this(Collections.singletonList(callback), logger);
        }

        JoinTaskListener(List<MembershipAction.JoinCallback> callbacks, Logger logger) {
            this.callbacks = callbacks;
            this.logger = logger;
        }

        @Override
        public void onFailure(String source, Exception e) {
            for (MembershipAction.JoinCallback callback : this.callbacks) {
                try {
                    callback.onFailure(e);
                }
                catch (Exception inner) {
                    this.logger.error(() -> new ParameterizedMessage("error handling task failure [{}]", (Object)e), (Throwable)inner);
                }
            }
        }

        @Override
        public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
            for (MembershipAction.JoinCallback callback : this.callbacks) {
                try {
                    callback.onSuccess();
                }
                catch (Exception e) {
                    this.logger.error(() -> new ParameterizedMessage("unexpected error during [{}]", (Object)source), (Throwable)e);
                }
            }
        }
    }

    class ElectionContext {
        private ElectionCallback callback = null;
        private int requiredMasterJoins = -1;
        private final Map<DiscoveryNode, List<MembershipAction.JoinCallback>> joinRequestAccumulator = new HashMap<DiscoveryNode, List<MembershipAction.JoinCallback>>();
        final AtomicBoolean closed = new AtomicBoolean();
        private final ClusterStateTaskListener electionFinishedListener = new ClusterStateTaskListener(){

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                if (newState.nodes().isLocalNodeElectedMaster()) {
                    ElectionContext.this.onElectedAsMaster(newState);
                } else {
                    this.onFailure(source, new NotMasterException("election stopped [" + source + "]"));
                }
            }

            @Override
            public void onFailure(String source, Exception e) {
                ElectionContext.this.onFailure(e);
            }
        };

        ElectionContext() {
        }

        public synchronized void onAttemptToBeElected(int requiredMasterJoins, ElectionCallback callback) {
            this.ensureOpen();
            assert (this.requiredMasterJoins < 0);
            assert (this.callback == null);
            this.requiredMasterJoins = requiredMasterJoins;
            this.callback = callback;
        }

        public synchronized void addIncomingJoin(DiscoveryNode node, MembershipAction.JoinCallback callback) {
            this.ensureOpen();
            this.joinRequestAccumulator.computeIfAbsent(node, n -> new ArrayList()).add(callback);
        }

        public synchronized boolean isEnoughPendingJoins(int pendingMasterJoins) {
            boolean hasEnough;
            if (this.requiredMasterJoins < 0) {
                hasEnough = false;
            } else {
                assert (this.callback != null) : "requiredMasterJoins is set but not the callback";
                hasEnough = pendingMasterJoins >= this.requiredMasterJoins;
            }
            return hasEnough;
        }

        private Map<JoinTaskExecutor.Task, ClusterStateTaskListener> getPendingAsTasks(String reason) {
            HashMap<JoinTaskExecutor.Task, ClusterStateTaskListener> tasks = new HashMap<JoinTaskExecutor.Task, ClusterStateTaskListener>();
            this.joinRequestAccumulator.entrySet().stream().forEach(e -> tasks.put(new JoinTaskExecutor.Task((DiscoveryNode)e.getKey(), reason), new JoinTaskListener((List)e.getValue(), logger)));
            return tasks;
        }

        public synchronized int getPendingMasterJoinsCount() {
            int pendingMasterJoins = 0;
            for (DiscoveryNode node : this.joinRequestAccumulator.keySet()) {
                if (!node.isMasterNode()) continue;
                ++pendingMasterJoins;
            }
            return pendingMasterJoins;
        }

        public synchronized void closeAndBecomeMaster() {
            assert (this.callback != null) : "becoming a master but the callback is not yet set";
            assert (this.isEnoughPendingJoins(this.getPendingMasterJoinsCount())) : "becoming a master but pending joins of " + this.getPendingMasterJoinsCount() + " are not enough. needs [" + this.requiredMasterJoins + "];";
            this.innerClose();
            Map<JoinTaskExecutor.Task, ClusterStateTaskListener> tasks = this.getPendingAsTasks("become master");
            String source = "zen-disco-elected-as-master ([" + tasks.size() + "] nodes joined)";
            tasks.put(JoinTaskExecutor.newBecomeMasterTask(), (source1, e) -> {});
            tasks.put(JoinTaskExecutor.newFinishElectionTask(), this.electionFinishedListener);
            NodeJoinController.this.masterService.submitStateUpdateTasks(source, tasks, ClusterStateTaskConfig.build(Priority.URGENT), NodeJoinController.this.joinTaskExecutor);
        }

        public synchronized void closeAndProcessPending(String reason) {
            this.innerClose();
            Map<JoinTaskExecutor.Task, ClusterStateTaskListener> tasks = this.getPendingAsTasks(reason);
            String source = "zen-disco-election-stop [" + reason + "]";
            tasks.put(JoinTaskExecutor.newFinishElectionTask(), this.electionFinishedListener);
            NodeJoinController.this.masterService.submitStateUpdateTasks(source, tasks, ClusterStateTaskConfig.build(Priority.URGENT), NodeJoinController.this.joinTaskExecutor);
        }

        private void innerClose() {
            if (this.closed.getAndSet(true)) {
                throw new AlreadyClosedException("election context is already closed");
            }
        }

        private void ensureOpen() {
            if (this.closed.get()) {
                throw new AlreadyClosedException("election context is already closed");
            }
        }

        private synchronized ElectionCallback getCallback() {
            return this.callback;
        }

        private void onElectedAsMaster(ClusterState state) {
            assert (MasterService.assertMasterUpdateThread());
            assert (state.nodes().isLocalNodeElectedMaster()) : "onElectedAsMaster called but local node is not master";
            ElectionCallback callback = this.getCallback();
            if (callback != null) {
                callback.onElectedAsMaster(state);
            }
        }

        private void onFailure(Throwable t) {
            assert (MasterService.assertMasterUpdateThread());
            ElectionCallback callback = this.getCallback();
            if (callback != null) {
                callback.onFailure(t);
            }
        }
    }

    public static interface ElectionCallback {
        public void onElectedAsMaster(ClusterState var1);

        public void onFailure(Throwable var1);
    }
}

