/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.internal.service;

import java.net.URI;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;

public class FeatureRepoFinder
implements ManagedService {
    public static final String FEATURES_REPOS_PID = "org.apache.karaf.features.repos";
    final Map<String, String> nameToArtifactMap = new HashMap<String, String>();

    public static Dictionary<String, Object> getServiceProperties() {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("service.pid", FEATURES_REPOS_PID);
        return props;
    }

    public synchronized String[] getNames() {
        Set<String> strings = this.nameToArtifactMap.keySet();
        return strings.toArray(new String[strings.size()]);
    }

    public synchronized URI getUriFor(String name, String version) {
        String artifactUri = this.nameToArtifactMap.get(name);
        if (artifactUri == null) {
            return null;
        }
        if (version != null) {
            artifactUri = FeatureRepoFinder.replaceVersion(artifactUri, version);
        }
        return URI.create(artifactUri);
    }

    public synchronized void updated(Dictionary properties) throws ConfigurationException {
        if (properties != null) {
            this.nameToArtifactMap.clear();
            Enumeration keys = properties.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                if (this.isSystemKey(key)) continue;
                this.nameToArtifactMap.put(key, (String)properties.get(key));
            }
        }
    }

    private boolean isSystemKey(String key) {
        return "felix.fileinstall.filename".equals(key) || "service.pid".equals(key);
    }

    private static String replaceVersion(String url, String version) {
        if (url.startsWith("mvn:")) {
            int firstSlash = url.indexOf(47);
            int secondSlash = url.indexOf(47, firstSlash + 1);
            String before = url.substring(0, secondSlash);
            int thirdSlash = url.indexOf(47, secondSlash + 1);
            String after = url.substring(thirdSlash + 1);
            return before + "/" + version + "/" + after;
        }
        return url;
    }
}

